/*
 * Decompiled with CFR 0.152.
 */
package com.easysurvive.event;

import com.easysurvive.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FarmingHandler {
    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)Config.AUTO_REPLANT_ENABLED.get()).booleanValue()) {
            return;
        }
        Level level = event.getLevel();
        if (level.f_46443_) {
            return;
        }
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        ItemStack heldItem = player.m_21120_(event.getHand());
        if (!this.isSeedOrSapling(heldItem.m_41720_())) {
            return;
        }
        if (event.getHand() == InteractionHand.MAIN_HAND) {
            this.plantInArea(level, player, pos, heldItem);
        }
    }

    private void plantInArea(Level level, Player player, BlockPos centerPos, ItemStack seedStack) {
        Item seed = seedStack.m_41720_();
        int planted = 0;
        int radius = 1;
        boolean isSapling = this.isSapling(seed);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                Block cropToPlant;
                BlockPos targetPos = centerPos.m_7918_(x, 0, z);
                BlockState groundState = level.m_8055_(targetPos);
                BlockState aboveState = level.m_8055_(targetPos.m_7494_());
                if (!aboveState.m_60795_() || !this.canPlantOn(groundState.m_60734_(), isSapling) || (cropToPlant = this.getCropFromSeed(seed)) == null) continue;
                level.m_7731_(targetPos.m_7494_(), cropToPlant.m_49966_(), 3);
                if (!player.m_7500_()) {
                    seedStack.m_41774_(1);
                    if (seedStack.m_41619_()) {
                        return;
                    }
                }
                ++planted;
            }
        }
    }

    private boolean canPlantOn(Block block, boolean isSapling) {
        if (isSapling) {
            return block == Blocks.f_50440_ || block == Blocks.f_50493_ || block == Blocks.f_50599_ || block == Blocks.f_50546_;
        }
        return block == Blocks.f_50093_;
    }

    private boolean isSapling(Item item) {
        return item == Items.f_42799_ || item == Items.f_42800_ || item == Items.f_42801_ || item == Items.f_41826_ || item == Items.f_41827_ || item == Items.f_41828_ || item == Items.f_271375_ || item == Items.f_220175_;
    }

    private boolean isSeedOrSapling(Item item) {
        return item == Items.f_42404_ || item == Items.f_42620_ || item == Items.f_42619_ || item == Items.f_42733_ || item == Items.f_42578_ || item == Items.f_42577_ || item == Items.f_271133_ || item == Items.f_276594_ || item == Items.f_42799_ || item == Items.f_42800_ || item == Items.f_42801_ || item == Items.f_41826_ || item == Items.f_41827_ || item == Items.f_41828_ || item == Items.f_271375_ || item == Items.f_220175_ || item == Items.f_41911_ || item == Items.f_41909_ || item == Items.f_41982_ || item == Items.f_42780_ || item == Items.f_151079_ || item == Items.f_42588_ || item == Items.f_42533_;
    }

    private Block getCropFromSeed(Item seed) {
        if (seed == Items.f_42404_) {
            return Blocks.f_50092_;
        }
        if (seed == Items.f_42620_) {
            return Blocks.f_50250_;
        }
        if (seed == Items.f_42619_) {
            return Blocks.f_50249_;
        }
        if (seed == Items.f_42733_) {
            return Blocks.f_50444_;
        }
        if (seed == Items.f_42578_) {
            return Blocks.f_50190_;
        }
        if (seed == Items.f_42577_) {
            return Blocks.f_50189_;
        }
        if (seed == Items.f_271133_) {
            return Blocks.f_271410_;
        }
        if (seed == Items.f_276594_) {
            return Blocks.f_276665_;
        }
        if (seed == Items.f_42799_) {
            return Blocks.f_50746_;
        }
        if (seed == Items.f_42800_) {
            return Blocks.f_50747_;
        }
        if (seed == Items.f_42801_) {
            return Blocks.f_50748_;
        }
        if (seed == Items.f_41826_) {
            return Blocks.f_50749_;
        }
        if (seed == Items.f_41827_) {
            return Blocks.f_50750_;
        }
        if (seed == Items.f_41828_) {
            return Blocks.f_50751_;
        }
        if (seed == Items.f_271375_) {
            return Blocks.f_271334_;
        }
        if (seed == Items.f_220175_) {
            return Blocks.f_220831_;
        }
        if (seed == Items.f_41911_) {
            return Blocks.f_50571_;
        }
        if (seed == Items.f_41909_) {
            return Blocks.f_50130_;
        }
        if (seed == Items.f_41982_) {
            return Blocks.f_50128_;
        }
        if (seed == Items.f_42780_) {
            return Blocks.f_50685_;
        }
        if (seed == Items.f_42588_) {
            return Blocks.f_50200_;
        }
        return null;
    }
}

