/*
 * Decompiled with CFR 0.152.
 */
package com.easysurvive.event;

import com.easysurvive.config.Config;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class InventoryHandler {
    private int tickCounter = 0;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!((Boolean)Config.AUTO_INVENTORY_SORT_ENABLED.get()).booleanValue()) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().f_46443_) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % (Integer)Config.AUTO_INVENTORY_SORT_INTERVAL.get() != 0) {
            return;
        }
        this.sortInventory(player);
    }

    private void sortInventory(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 9; i < 36; ++i) {
            ItemStack stack2 = player.m_150109_().m_8020_(i);
            if (stack2.m_41619_()) continue;
            items.add(stack2.m_41777_());
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
        }
        items.sort(Comparator.comparing(stack -> stack.m_41720_().toString()));
        int slot = 9;
        for (ItemStack stack3 : items) {
            if (slot >= 36) continue;
            player.m_150109_().m_6836_(slot++, stack3);
        }
    }
}

