/*
 * Decompiled with CFR 0.152.
 */
package com.easysurvive.event;

import com.easysurvive.config.Config;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TreeChopHandler {
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!((Boolean)Config.TREE_CHOP_ENABLED.get()).booleanValue()) {
            return;
        }
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        Player player = event.getPlayer();
        BlockState state = event.getState();
        Block block = state.m_60734_();
        if (!this.isLog(block)) {
            return;
        }
        ItemStack tool = player.m_21205_();
        if (!this.isAxe(tool)) {
            return;
        }
        BlockPos startPos = event.getPos();
        this.chopTree(level, player, startPos, block);
    }

    private boolean isAxe(ItemStack tool) {
        if (tool.m_41619_()) {
            return false;
        }
        String itemName = tool.m_41720_().toString().toLowerCase();
        return itemName.contains("axe");
    }

    private boolean isLog(Block block) {
        String name = block.toString().toLowerCase();
        return name.contains("log") || name.contains("wood") && !name.contains("planks");
    }

    private void chopTree(ServerLevel level, Player player, BlockPos startPos, Block targetBlock) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(startPos);
        visited.add(startPos);
        int maxBlocks = (Integer)Config.TREE_CHOP_MAX_BLOCKS.get();
        int broken = 0;
        ItemStack tool = player.m_21205_();
        while (!queue.isEmpty() && broken < maxBlocks) {
            BlockPos pos = (BlockPos)queue.poll();
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos neighborPos;
                        if (x == 0 && y == 0 && z == 0 || visited.contains(neighborPos = pos.m_7918_(x, y, z))) continue;
                        visited.add(neighborPos);
                        BlockState neighborState = level.m_8055_(neighborPos);
                        Block neighborBlock = neighborState.m_60734_();
                        if (!this.isLog(neighborBlock)) continue;
                        queue.add(neighborPos);
                        if (neighborPos.equals((Object)startPos)) continue;
                        if (tool.m_41763_() && !player.m_7500_()) {
                            tool.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                            if (tool.m_41619_()) {
                                return;
                            }
                        }
                        level.m_46953_(neighborPos, true, (Entity)player);
                        if (++broken < maxBlocks) continue;
                        return;
                    }
                }
            }
        }
    }

    private boolean isLeaves(Block block) {
        String name = block.toString().toLowerCase();
        return name.contains("leaves");
    }
}

