/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.camera;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import yesman.epicfight.api.client.event.EpicFightClientHooks;
import yesman.epicfight.api.client.event.types.ActivateTPSCamera;
import yesman.epicfight.api.client.event.types.BuildCameraTransform;
import yesman.epicfight.api.client.event.types.CoupleTPSCamera;
import yesman.epicfight.api.client.event.types.ItemUsedInDecoupledCamera;
import yesman.epicfight.api.client.event.types.LockOnEvent;
import yesman.epicfight.api.client.input.InputManager;
import yesman.epicfight.api.client.input.action.EpicFightInputAction;
import yesman.epicfight.api.client.input.action.MinecraftInputAction;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPSetPlayerTarget;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public final class EpicFightCameraAPI {
    private static final EpicFightCameraAPI INSTANCE = new EpicFightCameraAPI();
    private static final int MAX_ZOOM_TICK = 8;
    private final Minecraft minecraft;
    private final Set<UseAnim> tpsItemAnimations = Set.of(UseAnim.BLOCK, UseAnim.BOW, UseAnim.SPEAR, UseAnim.CROSSBOW);
    private boolean zoomingIn;
    private int zoomTick = 0;
    private int zoomOutDelay = 0;
    private float cameraXRotO;
    private float cameraXRot;
    private float cameraYRotO;
    private float cameraYRot;
    private boolean couplingYRot;
    private float fpvXRotO;
    private float fpvXRot;
    private float fpvYRotO;
    private float fpvYRot;
    private int fpvLerpTick = -1;
    private int maxFpvLerpTick;
    @Nullable
    private HitResult crosshairHitResult;
    @Nullable
    private LivingEntity focusingEntity;
    private boolean lockingOnTarget;
    private double accumulatedX;
    private int quickShiftDelay;

    public static EpicFightCameraAPI getInstance() {
        return INSTANCE;
    }

    private EpicFightCameraAPI() {
        this.minecraft = Minecraft.getInstance();
    }

    public boolean isTPSMode() {
        if (this.minecraft.options.getCameraType() == CameraType.THIRD_PERSON_BACK && ClientConfig.cameraMode.shouldSwitch(this)) {
            ActivateTPSCamera event = new ActivateTPSCamera(this);
            EpicFightClientHooks.Camera.ACTIVATE_TPS_CAMERA.post(event);
            return !event.hasCanceled();
        }
        return false;
    }

    public boolean isFirstPerson() {
        return this.minecraft.options.getCameraType() == CameraType.FIRST_PERSON;
    }

    public boolean isZooming() {
        return this.zoomTick > 0;
    }

    public int zoomCount() {
        return this.zoomTick;
    }

    public void zoomIn() {
        if (!this.zoomingIn) {
            this.zoomingIn = true;
            this.zoomTick = this.zoomTick == 0 ? 1 : this.zoomTick;
        }
    }

    public void zoomOut(int zoomOutTicks) {
        if (this.zoomingIn) {
            this.zoomingIn = false;
            this.zoomOutDelay = zoomOutTicks;
        }
    }

    public float getCameraXRotO() {
        return this.cameraXRotO;
    }

    public float getCameraYRotO() {
        return this.cameraYRotO;
    }

    public float getCameraXRot() {
        return this.cameraXRot;
    }

    public float getCameraYRot() {
        return this.cameraYRot;
    }

    public void setCameraXRot(float xRot) {
        this.cameraXRot = xRot;
    }

    public void setCameraYRot(float yRot) {
        this.cameraYRot = yRot;
    }

    public void setCameraRotations(float xRot, float yRot, boolean syncOld) {
        this.cameraXRot = xRot;
        this.cameraYRot = yRot;
        if (syncOld) {
            this.cameraXRotO = this.cameraXRot;
            this.cameraYRotO = this.cameraYRot;
        }
    }

    public void setCouplingState(boolean flag) {
        this.couplingYRot = this.isTPSMode() ? flag : true;
    }

    public boolean getCouplingState() {
        return this.couplingYRot;
    }

    public float getForwardXRot() {
        return this.isTPSMode() ? this.cameraXRot : this.minecraft.player.getXRot();
    }

    public float getForwardYRot() {
        return this.isTPSMode() ? this.cameraYRot : this.minecraft.player.getYRot();
    }

    public void fixFpvRotation(float xRot, float yRot, int lerpTick) {
        if (this.minecraft.player == null) {
            return;
        }
        this.fpvXRotO = Mth.wrapDegrees((float)this.minecraft.player.getXRot());
        this.fpvXRot = Mth.wrapDegrees((float)xRot);
        this.fpvYRotO = Mth.wrapDegrees((float)this.minecraft.player.getYRot());
        this.fpvYRot = Mth.wrapDegrees((float)yRot);
        this.fpvLerpTick = lerpTick;
        this.maxFpvLerpTick = lerpTick;
    }

    public float getLerpedFpvXRot(float partialTick) {
        float delta = (float)this.fpvLerpTick / (float)this.maxFpvLerpTick + (1.0f - partialTick) * 0.2f;
        return Mth.rotLerp((float)delta, (float)this.fpvXRot, (float)this.fpvXRotO);
    }

    public float getLerpedFpvYRot(float partialTick) {
        float delta = (float)this.fpvLerpTick / (float)this.maxFpvLerpTick + (1.0f - partialTick) * 0.2f;
        return Mth.rotLerp((float)delta, (float)this.fpvYRot, (float)this.fpvYRotO);
    }

    public boolean isLerpingFpv() {
        return this.fpvLerpTick > -1;
    }

    @Nullable
    public HitResult getCrosshairHitResult() {
        return this.crosshairHitResult;
    }

    @Nullable
    public LivingEntity getFocusingEntity() {
        return this.focusingEntity;
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public void setLockOn(boolean flag) {
        if (this.lockingOnTarget == flag) {
            return;
        }
        boolean newlyFoundFocusingEntity = false;
        if (flag && this.focusingEntity == null) {
            newlyFoundFocusingEntity = this.setNextLockOnTarget(0, false, false);
        }
        if (!flag || this.focusingEntity != null) {
            boolean eventCanceled;
            if (flag) {
                LockOnEvent.Start lockOnEvent = new LockOnEvent.Start(this, this.focusingEntity);
                EpicFightClientHooks.Camera.LOCK_ON_START.post(lockOnEvent);
                eventCanceled = lockOnEvent.hasCanceled();
                if (eventCanceled && newlyFoundFocusingEntity) {
                    this.focusingEntity = null;
                }
            } else {
                LockOnEvent.Release lockOnEvent = new LockOnEvent.Release(this, this.focusingEntity);
                EpicFightClientHooks.Camera.LOCK_ON_RELEASED.post(lockOnEvent);
                eventCanceled = lockOnEvent.hasCanceled();
            }
            if (!eventCanceled) {
                this.lockingOnTarget = flag;
            }
            if (flag && newlyFoundFocusingEntity) {
                this.sendTargeting(this.focusingEntity);
            }
            if (!this.isTPSMode()) {
                if (!flag) {
                    this.minecraft.player.setXRot(this.cameraXRot);
                } else {
                    this.setCameraRotations(this.minecraft.player.getXRot(), this.minecraft.player.getYRot(), true);
                }
            }
        }
    }

    public void toggleLockOn() {
        this.setLockOn(!this.lockingOnTarget);
    }

    public boolean isLockingOnTarget() {
        return this.lockingOnTarget;
    }

    public int getFocusingEntityPickRange() {
        if (this.minecraft.player == null) {
            return 0;
        }
        return ClientConfig.lockOnRange;
    }

    public boolean setNextLockOnTarget(int direction) {
        return this.setNextLockOnTarget(direction, false, true);
    }

    public boolean setNextLockOnTarget(int direction, boolean necessarilyLockingOn, boolean sendChange) {
        if (!this.lockingOnTarget && necessarilyLockingOn) {
            return false;
        }
        ArrayList entitiesInLevel = new ArrayList();
        this.minecraft.level.entitiesForRendering().forEach(entitiesInLevel::add);
        Vec3 cameraLocation = this.minecraft.gameRenderer.getMainCamera().getPosition();
        Matrix4f compactProjection = this.getCompactProjectionMatrix();
        double lockOnRange = this.getFocusingEntityPickRange();
        Optional<Pair> next = entitiesInLevel.stream().filter(entity -> this.predicateFocusableEntity((Entity)entity) && !entity.is((Entity)this.focusingEntity) && MathUtils.canBeSeen(entity, (Entity)this.minecraft.player, lockOnRange) && (this.minecraft.getEntityRenderDispatcher().shouldRender(entity, this.minecraft.levelRenderer.getFrustum(), cameraLocation.x(), cameraLocation.y(), cameraLocation.z()) || entity.hasIndirectPassenger((Entity)this.minecraft.player)) && entity.distanceToSqr((Entity)this.minecraft.player) < lockOnRange * lockOnRange).map(entity -> Pair.of((Object)((LivingEntity)entity), (Object)Float.valueOf(MathUtils.worldToScreenCoord((Matrix4f)compactProjection, (Camera)this.minecraft.gameRenderer.getMainCamera(), (Vec3)entity.getBoundingBox().getCenter()).x))).filter(pair -> ((Float)pair.getSecond()).floatValue() >= -1.0f && ((Float)pair.getSecond()).floatValue() <= 1.0f && (direction == 0 || MathUtils.getSign(((Float)pair.getSecond()).floatValue()) == MathUtils.getSign(direction))).min((p1, p2) -> Float.compare(Math.abs(((Float)p1.getSecond()).floatValue()), Math.abs(((Float)p2.getSecond()).floatValue())));
        next.ifPresent(pair -> {
            this.focusingEntity = (LivingEntity)pair.getFirst();
            if (sendChange) {
                this.sendTargeting(this.focusingEntity);
            }
        });
        return next.isPresent();
    }

    private Matrix4f getCompactProjectionMatrix() {
        PoseStack posestack = new PoseStack();
        double fov = this.minecraft.gameRenderer.getFov(this.minecraft.gameRenderer.getMainCamera(), 1.0f, true);
        posestack.mulPose(this.minecraft.gameRenderer.getProjectionMatrix(fov));
        return posestack.last().pose();
    }

    public void alignPlayerLookToCameraRotation(boolean noInterpolation, boolean syncBodyRot, boolean syncToServer) {
        if (this.minecraft.player == null) {
            return;
        }
        this.minecraft.player.setXRot(this.cameraXRot);
        this.minecraft.player.setYRot(this.cameraYRot);
        this.minecraft.player.setYHeadRot(this.cameraYRot);
        if (syncBodyRot) {
            this.minecraft.player.setYBodyRot(this.cameraYRot);
        }
        if (noInterpolation) {
            this.minecraft.player.xRotO = this.cameraXRot;
            this.minecraft.player.yRotO = this.cameraYRot;
            this.minecraft.player.yHeadRotO = this.cameraYRot;
            if (syncBodyRot) {
                this.minecraft.player.yBodyRotO = this.cameraYRot;
            }
        }
        if (syncToServer) {
            this.minecraft.player.connection.send((Packet)new ServerboundMovePlayerPacket.Rot(this.cameraYRot, this.cameraXRot, this.minecraft.player.onGround()));
        }
    }

    public void alignPlayerLookToCrosshair(boolean noInterpolation, boolean syncBodyRot, boolean syncToServer) {
        if (this.minecraft.player == null) {
            return;
        }
        if (this.crosshairHitResult == null) {
            this.alignPlayerLookToCameraRotation(noInterpolation, syncBodyRot, syncToServer);
            return;
        }
        Vec3 fromEyeToDest = this.crosshairHitResult.getLocation().subtract(this.minecraft.player.getEyePosition());
        float xRot = (float)MathUtils.getXRotOfVector(fromEyeToDest);
        float yRot = (float)MathUtils.getYRotOfVector(fromEyeToDest);
        this.minecraft.player.setXRot(xRot);
        this.minecraft.player.setYRot(yRot);
        this.minecraft.player.setYHeadRot(yRot);
        if (syncBodyRot) {
            this.minecraft.player.setYBodyRot(yRot);
        }
        if (noInterpolation) {
            this.minecraft.player.xRotO = xRot;
            this.minecraft.player.yRotO = yRot;
            this.minecraft.player.yHeadRotO = yRot;
            if (syncBodyRot) {
                this.minecraft.player.yBodyRotO = yRot;
            }
        }
        if (syncToServer) {
            this.minecraft.player.connection.send((Packet)new ServerboundMovePlayerPacket.Rot(this.cameraYRot, this.cameraXRot, this.minecraft.player.onGround()));
        }
    }

    public Vec3 getRelativeMove(Vec3 relative, float magnitude) {
        return Entity.getInputVector((Vec3)relative, (float)magnitude, (float)(this.isTPSMode() && !this.lockingOnTarget ? this.cameraYRot : this.minecraft.player.getYRot()));
    }

    public boolean shouldHighlightTarget(@NotNull Entity entity) {
        if (!ClientConfig.enableTargetEntityGuide || this.minecraft.player == null || !entity.is((Entity)this.focusingEntity)) {
            return false;
        }
        if (!EpicFightCapabilities.getUnparameterizedEntityPatch(entity, EntityPatch.class).map(entitypatch -> entitypatch.isOutlineVisible(this.minecraft.player)).orElse(false).booleanValue()) {
            return false;
        }
        if (this.lockingOnTarget) {
            return true;
        }
        if (ClientConfig.combatPreferredItems.contains(this.minecraft.player.getMainHandItem().getItem())) {
            if (RenderEngine.hitResultEquals(this.minecraft.hitResult, HitResult.Type.BLOCK)) {
                BlockPos bp = ((BlockHitResult)this.minecraft.hitResult).getBlockPos();
                BlockState bs = this.minecraft.level.getBlockState(bp);
                return !this.minecraft.player.getMainHandItem().getItem().canAttackBlock(bs, this.minecraft.player.level(), bp, (Player)this.minecraft.player) || !this.minecraft.player.getMainHandItem().isCorrectToolForDrops(bs);
            }
            return true;
        }
        return !RenderEngine.hitResultEquals(this.minecraft.hitResult, HitResult.Type.BLOCK);
    }

    @ApiStatus.Internal
    public boolean turnCamera(double dy, double dx) {
        MutableBoolean cancel = new MutableBoolean(false);
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(playerpatch -> {
            cancel.setValue(this.isTPSMode() || this.lockingOnTarget);
            if (cancel.booleanValue()) {
                float modifier = !this.lockingOnTarget || InputManager.isActionActive(EpicFightInputAction.LOCK_ON_SHIFT_FREELY) ? 0.15f : (ClientConfig.lockOnQuickShift ? 0.005f : 0.0f);
                this.setCameraRotations(Mth.clamp((float)(this.cameraXRot + (float)dx * modifier), (float)-90.0f, (float)90.0f), this.cameraYRot + (float)dy * modifier, false);
                if (ClientConfig.lockOnQuickShift && this.quickShiftDelay <= 0) {
                    this.accumulatedX += -dy * (double)0.15f;
                    if (Math.abs(this.accumulatedX) > 20.0 && this.lockingOnTarget) {
                        this.setNextLockOnTarget(Mth.sign((double)this.accumulatedX), true, true);
                        this.accumulatedX = 0.0;
                        this.quickShiftDelay = 4;
                    }
                }
                this.accumulatedX *= 0.98;
            }
        });
        return cancel.booleanValue();
    }

    @ApiStatus.Internal
    public void preClientTick() {
        this.cameraXRotO = this.cameraXRot;
        this.cameraYRotO = this.cameraYRot;
        if (this.zoomTick > 0) {
            if (this.zoomOutDelay > 0) {
                --this.zoomOutDelay;
            } else {
                this.zoomTick += this.zoomingIn ? 1 : -1;
                this.zoomTick = Math.min(8, this.zoomTick);
            }
        }
        if (this.quickShiftDelay > 0) {
            --this.quickShiftDelay;
        }
    }

    @ApiStatus.Internal
    public void postClientTick() {
        boolean tpsMode;
        LocalPlayer localPlayer;
        Vec3 lookVec;
        Vec3 cameraPos;
        block44: {
            block46: {
                int focusingRange;
                Camera mainCamera;
                block45: {
                    boolean releaseLockOn;
                    if (this.minecraft.isPaused() || this.minecraft.player == null) {
                        return;
                    }
                    EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class).ifPresent(playerpatch -> {
                        CapabilityItem mainhandItemCap = playerpatch.getAdvancedHoldingItemCapability(InteractionHand.MAIN_HAND);
                        CapabilityItem offhandItemCap = playerpatch.getAdvancedHoldingItemCapability(InteractionHand.OFF_HAND);
                        CapabilityItem.ZoomInType rangeWeaponZoomInType = mainhandItemCap.isEmpty() || mainhandItemCap.getZoomInType() == CapabilityItem.ZoomInType.NONE ? offhandItemCap.getZoomInType() : mainhandItemCap.getZoomInType();
                        switch (rangeWeaponZoomInType) {
                            case ALWAYS: {
                                this.zoomIn();
                                break;
                            }
                            case USE_TICK: {
                                if (((LocalPlayer)playerpatch.getOriginal()).getUseItemRemainingTicks() > 0) {
                                    this.zoomIn();
                                    break;
                                }
                                this.zoomOut(8);
                                break;
                            }
                            case AIMING: {
                                if (playerpatch.getClientAnimator().isAiming()) {
                                    this.zoomIn();
                                    break;
                                }
                                this.zoomOut(8);
                                break;
                            }
                            case CUSTOM: {
                                break;
                            }
                            default: {
                                this.zoomOut(1);
                            }
                        }
                    });
                    double pickRange = (double)((Integer)this.minecraft.options.renderDistance().get()).intValue() * 16.0;
                    mainCamera = this.minecraft.gameRenderer.getMainCamera();
                    cameraPos = mainCamera.getPosition();
                    lookVec = new Vec3(mainCamera.getLookVector());
                    Vec3 rayEed = cameraPos.add(lookVec.x * pickRange, lookVec.y * pickRange, lookVec.z * pickRange);
                    localPlayer = this.minecraft.player;
                    this.crosshairHitResult = localPlayer.level().clip(new ClipContext(cameraPos, rayEed, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)localPlayer));
                    focusingRange = this.getFocusingEntityPickRange();
                    double entityPickRange = Math.min(this.crosshairHitResult.getLocation().distanceToSqr(cameraPos), (double)(focusingRange * focusingRange));
                    AABB aabb = localPlayer.getBoundingBox().move(cameraPos.subtract(localPlayer.getEyePosition(1.0f))).expandTowards(lookVec.scale(entityPickRange)).inflate(1.0, 1.0, 1.0);
                    EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)localPlayer, (Vec3)cameraPos, (Vec3)rayEed, (AABB)aabb, this::predicateFocusableEntity, (double)entityPickRange);
                    if (entityHitResult != null) {
                        this.crosshairHitResult = entityHitResult;
                        if (!entityHitResult.getEntity().is((Entity)this.focusingEntity)) {
                            Entity entity = entityHitResult.getEntity();
                            if (entity instanceof LivingEntity) {
                                LivingEntity livingentity = (LivingEntity)entity;
                                if (!(entityHitResult.getEntity() instanceof ArmorStand || this.lockingOnTarget && !InputManager.isActionActive(EpicFightInputAction.LOCK_ON_SHIFT_FREELY))) {
                                    this.focusingEntity = livingentity;
                                }
                            } else {
                                entity = entityHitResult.getEntity();
                                if (entity instanceof PartEntity) {
                                    PartEntity partEntity = (PartEntity)entity;
                                    Entity parent = partEntity.getParent();
                                    if (parent instanceof LivingEntity) {
                                        LivingEntity parentLivingEntity = (LivingEntity)parent;
                                        if (!this.lockingOnTarget || InputManager.isActionActive(EpicFightInputAction.LOCK_ON_SHIFT_FREELY)) {
                                            this.focusingEntity = parentLivingEntity;
                                        }
                                    }
                                } else {
                                    this.setLockOn(false);
                                    this.focusingEntity = null;
                                }
                            }
                            if (this.focusingEntity != null) {
                                this.sendTargeting(this.focusingEntity);
                            }
                        }
                    }
                    if (tpsMode = this.isTPSMode()) {
                        double dot;
                        Vec3 view = new Vec3(mainCamera.getLookVector());
                        if (view.dot(this.crosshairHitResult.getLocation().subtract(localPlayer.getEyePosition()).normalize()) < -0.1) {
                            this.crosshairHitResult = BlockHitResult.miss((Vec3)cameraPos.add(lookVec.x * 50.0, lookVec.y * 50.0, lookVec.z * 50.0), (Direction)Direction.UP, (BlockPos)BlockPos.ZERO);
                            if (!this.lockingOnTarget) {
                                this.focusingEntity = null;
                            }
                        }
                        if (this.focusingEntity != null && (dot = view.dot(this.focusingEntity.getEyePosition().subtract(localPlayer.getEyePosition()))) < -0.1 && !this.lockingOnTarget) {
                            this.focusingEntity = null;
                        }
                    }
                    if (this.focusingEntity == null) break block44;
                    if (!this.lockingOnTarget || this.focusingEntity.isAlive()) break block45;
                    boolean bl = releaseLockOn = !ClientConfig.lockOnQuickShift || !this.setNextLockOnTarget(0, true, true);
                    if (releaseLockOn) {
                        this.setLockOn(false);
                    }
                    break block44;
                }
                double distance = cameraPos.distanceToSqr(this.focusingEntity.position());
                double maxLockOnDistance = focusingRange * focusingRange;
                if (this.focusingEntity.isInvisibleTo((Player)localPlayer) || distance > maxLockOnDistance || !MathUtils.canBeSeen((Entity)this.focusingEntity, (Entity)this.minecraft.player, maxLockOnDistance)) break block46;
                if (this.lockingOnTarget) break block44;
                Vec3 vec3 = new Vec3(mainCamera.getLookVector());
                if (!(this.focusingEntity.getBoundingBox().getCenter().subtract(mainCamera.getPosition()).normalize().dot(vec3) < Mth.clampedLerp((double)0.0, (double)0.99, (double)Mth.inverseLerp((double)Mth.clamp((double)distance, (double)1.0, (double)3.5), (double)1.0, (double)3.5)))) break block44;
            }
            if (this.lockingOnTarget) {
                this.setLockOn(false);
            }
            this.focusingEntity = null;
            this.sendTargeting(null);
        }
        if (this.isFirstPerson() && this.isLerpingFpv()) {
            --this.fpvLerpTick;
            if (!this.isLerpingFpv()) {
                this.minecraft.player.setXRot(this.fpvXRot);
                this.minecraft.player.setYRot(this.fpvYRot);
            }
        } else if (!this.isTPSMode() && !this.lockingOnTarget) {
            this.cameraXRot = this.minecraft.player.getXRot();
            this.cameraYRot = this.minecraft.player.getYRot();
        } else {
            @Nullable LocalPlayerPatch playerpatch2 = EpicFightCapabilities.getEntityPatch((Entity)localPlayer, LocalPlayerPatch.class);
            float clamp = 30.0f;
            float desiredXRot = 0.0f;
            float desiredYRot = 0.0f;
            if (this.focusingEntity != null && this.lockingOnTarget && !this.isLerpingFpv() && !InputManager.isActionActive(EpicFightInputAction.LOCK_ON_SHIFT_FREELY)) {
                Vec3 lockEnd;
                Vec3 lockStart;
                if (tpsMode) {
                    double toTargetDistanceSqr = localPlayer.position().distanceToSqr(this.focusingEntity.position());
                    lockStart = MathUtils.lerpVector(localPlayer.getEyePosition(), cameraPos, (float)Mth.clampedMap((double)toTargetDistanceSqr, (double)1.0, (double)18.0, (double)0.2f, (double)1.0));
                    lockEnd = MathUtils.lerpVector(this.focusingEntity.getEyePosition(), this.focusingEntity.getBoundingBox().getCenter(), (float)Mth.clampedMap((double)toTargetDistanceSqr, (double)0.0, (double)18.0, (double)0.5, (double)1.0));
                } else {
                    lockStart = localPlayer.getEyePosition();
                    lockEnd = this.focusingEntity.getEyePosition();
                }
                Vec3 toTarget = lockEnd.subtract(lockStart);
                float xRot = (float)MathUtils.getXRotOfVector(toTarget);
                float yRot = (float)MathUtils.getYRotOfVector(toTarget);
                CameraType cameraType = this.minecraft.options.getCameraType();
                if (!cameraType.isFirstPerson()) {
                    xRot = Mth.clamp((float)xRot, (float)(-clamp), (float)clamp);
                }
                float xLerp = Mth.clamp((float)(Mth.wrapDegrees((float)((xRot += cameraType.isFirstPerson() || tpsMode ? 0.0f : 30.0f + xRot * 0.5f) - this.cameraXRot)) * 0.4f), (float)(-clamp), (float)clamp);
                float yLerp = Mth.clamp((float)(Mth.wrapDegrees((float)(yRot - this.cameraYRot)) * 0.4f), (float)(-clamp), (float)clamp);
                Vec3 playerToTarget = lockEnd.subtract(localPlayer.getEyePosition());
                this.setCameraRotations(this.cameraXRot + xLerp, this.cameraYRot + yLerp, false);
                desiredXRot = (float)MathUtils.getXRotOfVector(playerToTarget);
                desiredYRot = (float)MathUtils.getYRotOfVector(playerToTarget);
            } else if (this.lockingOnTarget && InputManager.isActionActive(EpicFightInputAction.LOCK_ON_SHIFT_FREELY)) {
                desiredXRot = this.cameraXRot;
                desiredYRot = this.cameraYRot;
            } else if (tpsMode) {
                CoupleTPSCamera coupleCameraEvent = this.predicateCouplingPlayer();
                boolean shouldCoupling = coupleCameraEvent.shouldCoupleCamera();
                if (Mth.abs((float)Mth.wrapDegrees((float)(this.cameraYRot - localPlayer.yBodyRot))) <= 51.0f || shouldCoupling) {
                    if (coupleCameraEvent.isOnlyMoving()) {
                        Vec2 movemoventPulse = localPlayer.input.getMoveVector();
                        desiredYRot = this.cameraYRot + (float)MathUtils.getYRotOfVector(new Vec3((double)movemoventPulse.x, 0.0, (double)movemoventPulse.y));
                        desiredXRot = desiredYRot == this.cameraYRot ? this.cameraXRot : 0.0f;
                    } else {
                        Vec3 toHitResult;
                        if (this.lockingOnTarget) {
                            toHitResult = this.focusingEntity.getEyePosition();
                        } else if (this.crosshairHitResult.getType() == HitResult.Type.MISS) {
                            double delta = Mth.clamp((float)localPlayer.getXRot(), (float)-30.0f, (float)0.0f) / -30.0f;
                            double lookVecScale = Mth.clampedLerp((double)30.0, (double)75.0, (double)delta);
                            toHitResult = cameraPos.add(lookVec.scale(lookVecScale));
                        } else {
                            toHitResult = this.crosshairHitResult.getLocation();
                        }
                        toHitResult = toHitResult.subtract(localPlayer.getEyePosition());
                        desiredXRot = (float)MathUtils.getXRotOfVector(toHitResult);
                        desiredYRot = shouldCoupling ? (Math.abs(this.cameraXRot) > 80.0f ? this.cameraYRot : (float)MathUtils.getYRotOfVector(toHitResult)) : this.cameraYRot;
                    }
                } else {
                    desiredXRot = 0.0f;
                    desiredYRot = localPlayer.yBodyRot;
                    clamp = 15.0f;
                }
            }
            if (this.focusingEntity != null && this.lockingOnTarget) {
                LockOnEvent.Tick lockOnEventTick = new LockOnEvent.Tick(this, this.focusingEntity, desiredXRot, desiredYRot);
                EpicFightClientHooks.Camera.LOCK_ON_TICK.post(lockOnEventTick);
                desiredXRot = lockOnEventTick.getModifiedXRot();
                desiredYRot = lockOnEventTick.getModifiedYRot();
            }
            if ((playerpatch2 == null || !playerpatch2.getEntityState().turningLocked() || playerpatch2.getEntityState().lookTarget()) && (tpsMode || this.minecraft.options.getCameraType() == CameraType.THIRD_PERSON_BACK && this.lockingOnTarget)) {
                float xDelta = Mth.clamp((float)Mth.wrapDegrees((float)(desiredXRot - localPlayer.getXRot())), (float)(-clamp), (float)clamp);
                float yDelta = Mth.clamp((float)Mth.wrapDegrees((float)(desiredYRot - localPlayer.getYRot())), (float)(-clamp), (float)clamp);
                localPlayer.setXRot(localPlayer.getXRot() + xDelta);
                localPlayer.setYRot(localPlayer.getYRot() + yDelta);
            }
        }
    }

    @ApiStatus.Internal
    public BuildCameraTransform.Pre setupCamera(Camera camera, float partialTick) {
        BuildCameraTransform.Pre buildCameraEventPre = new BuildCameraTransform.Pre(this, camera, partialTick);
        if (!camera.getEntity().is((Entity)this.minecraft.player)) {
            buildCameraEventPre.cancel();
            return buildCameraEventPre;
        }
        EpicFightClientHooks.Camera.BUILD_TRANSFORM_PRE.post(buildCameraEventPre);
        if (buildCameraEventPre.hasCanceled()) {
            return buildCameraEventPre;
        }
        if (this.isTPSMode()) {
            float partialZoomTick = this.zoomTick == 0 ? 0.0f : Math.min((float)this.zoomTick + (this.zoomingIn ? partialTick : -partialTick), 7.0f);
            float delta = ClientConfig.cameraMode == ClientConfig.TPSType.WHEN_AIMING ? partialZoomTick / 7.0f : 1.0f;
            float xRot = Mth.rotLerp((float)delta, (float)this.minecraft.player.getXRot(), (float)Mth.rotLerp((float)partialTick, (float)this.cameraXRotO, (float)this.cameraXRot));
            float yRot2 = Mth.rotLerp((float)delta, (float)this.minecraft.player.getYRot(), (float)Mth.rotLerp((float)partialTick, (float)this.cameraYRotO, (float)this.cameraYRot));
            camera.setRotation(yRot2, xRot);
            Vec3 playerPos = new Vec3(Mth.lerp((double)partialTick, (double)camera.getEntity().xo, (double)camera.getEntity().getX()), Mth.lerp((double)partialTick, (double)camera.getEntity().yo, (double)camera.getEntity().getY()) + Mth.lerp((double)partialTick, (double)camera.eyeHeightOld, (double)camera.eyeHeight), Mth.lerp((double)partialTick, (double)camera.getEntity().zo, (double)camera.getEntity().getZ()));
            Vec3f relocation = new Vec3f((float)ClientConfig.cameraHorizontalLocation * 0.2f, (float)ClientConfig.cameraVerticalLocation * 0.2f, 0.0f);
            OpenMatrix4f.transform3v(OpenMatrix4f.createRotatorDeg(-yRot2, Vec3f.Y_AXIS), relocation, relocation);
            double cameraZoom = (double)ClientConfig.cameraZoom * 0.5 - (double)partialZoomTick * 0.1;
            double hitDistance = 1.0;
            for (int i = 0; i < 8; ++i) {
                double d0;
                float f = (i & 1) * 2 - 1;
                float f1 = (i >> 1 & 1) * 2 - 1;
                float f2 = (i >> 2 & 1) * 2 - 1;
                Vec3 vec3 = playerPos.add((double)(f *= 0.1f), (double)(f1 *= 0.1f), (double)(f2 *= 0.1f));
                Vec3 vec31 = new Vec3(playerPos.x + ((double)relocation.x - (double)camera.getLookVector().x() * cameraZoom) + (double)f, playerPos.y + ((double)relocation.y - (double)camera.getLookVector().y() * cameraZoom) + (double)f1, playerPos.z + ((double)relocation.z - (double)camera.getLookVector().z() * cameraZoom) + (double)f2);
                double length = vec3.distanceTo(vec31);
                BlockHitResult hitresult = this.minecraft.level.clip(new ClipContext(vec3, vec31, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, camera.getEntity()));
                if (hitresult.getType() == HitResult.Type.MISS || !((d0 = hitresult.getLocation().distanceTo(playerPos) / length) < hitDistance)) continue;
                hitDistance = d0;
            }
            double nearestX = playerPos.x + ((double)relocation.x - (double)camera.getLookVector().x() * cameraZoom) * hitDistance;
            double nearestY = playerPos.y + ((double)relocation.y - (double)camera.getLookVector().y() * cameraZoom) * hitDistance;
            double nearestZ = playerPos.z + ((double)relocation.z - (double)camera.getLookVector().z() * cameraZoom) * hitDistance;
            if (Float.compare(1.0f, delta) == 0) {
                camera.setPosition(nearestX, nearestY, nearestZ);
            } else {
                camera.setRotation(this.minecraft.player.getViewYRot(partialTick), this.minecraft.player.getViewXRot(partialTick));
                camera.setPosition(Mth.lerp((double)partialTick, (double)this.minecraft.player.xo, (double)this.minecraft.player.getX()), Mth.lerp((double)partialTick, (double)this.minecraft.player.yo, (double)this.minecraft.player.getY()) + (double)Mth.lerp((float)partialTick, (float)camera.eyeHeightOld, (float)camera.eyeHeight), Mth.lerp((double)partialTick, (double)this.minecraft.player.zo, (double)this.minecraft.player.getZ()));
                camera.move(-camera.getMaxZoom(4.0f), 0.0f, 0.0f);
                camera.setRotation(yRot2, xRot);
                camera.setPosition(camera.getPosition().x() + (nearestX - camera.getPosition().x()) * (double)delta, camera.getPosition().y() + (nearestY - camera.getPosition().y()) * (double)delta, camera.getPosition().z() + (nearestZ - camera.getPosition().z()) * (double)delta);
            }
            buildCameraEventPre.setVanillaCameraSetupCanceled(true);
            return buildCameraEventPre;
        }
        if (this.lockingOnTarget && this.focusingEntity != null) {
            if (this.minecraft.options.getCameraType() == CameraType.THIRD_PERSON_BACK) {
                float xRot = Mth.rotLerp((float)partialTick, (float)this.cameraXRotO, (float)this.cameraXRot);
                float yRot = Mth.rotLerp((float)partialTick, (float)this.cameraYRotO, (float)this.cameraYRot);
                camera.setRotation(yRot, xRot);
                camera.setPosition(Mth.lerp((double)partialTick, (double)camera.getEntity().xo, (double)camera.getEntity().getX()), Mth.lerp((double)partialTick, (double)camera.getEntity().yo, (double)camera.getEntity().getY()) + (double)Mth.lerp((float)partialTick, (float)camera.eyeHeightOld, (float)camera.eyeHeight), Mth.lerp((double)partialTick, (double)camera.getEntity().zo, (double)camera.getEntity().getZ()));
                if (camera.isDetached()) {
                    camera.move(-camera.getMaxZoom(4.0f), 0.0f, 0.0f);
                } else {
                    LivingEntity livingEntity;
                    Entity yRot2 = camera.getEntity();
                    if (yRot2 instanceof LivingEntity && (livingEntity = (LivingEntity)yRot2).isSleeping()) {
                        Direction direction = ((LivingEntity)camera.getEntity()).getBedOrientation();
                        camera.setRotation(direction != null ? direction.toYRot() - 180.0f : 0.0f, 0.0f);
                        camera.move(0.0f, 0.3f, 0.0f);
                    }
                }
                buildCameraEventPre.setVanillaCameraSetupCanceled(true);
                return buildCameraEventPre;
            }
            if (this.minecraft.options.getCameraType() == CameraType.FIRST_PERSON) {
                if (!InputManager.isActionActive(EpicFightInputAction.LOCK_ON_SHIFT_FREELY)) {
                    camera.getEntity().setXRot(Mth.rotLerp((float)partialTick, (float)this.cameraXRotO, (float)this.cameraXRot));
                    camera.getEntity().setYRot(Mth.rotLerp((float)partialTick, (float)this.cameraYRotO, (float)this.cameraYRot));
                } else {
                    this.cameraXRot = camera.getEntity().getXRot();
                    this.cameraYRot = camera.getEntity().getYRot();
                }
            }
        }
        return buildCameraEventPre;
    }

    @ApiStatus.Internal
    public void fireCameraBuildPost(Camera camera, float partialTick) {
        EpicFightClientHooks.Camera.BUILD_TRANSFORM_POST.post(new BuildCameraTransform.Post(this, camera, partialTick));
    }

    @ApiStatus.Internal
    public float getYRotForHead(Player player) {
        if (!player.isLocalPlayer()) {
            throw new IllegalArgumentException("Must pass a LocalPlayer to getYRotForHead(Player)");
        }
        if (!this.isTPSMode()) {
            return player.getYRot();
        }
        CoupleTPSCamera coupleCamera = this.predicateCouplingPlayer();
        if (coupleCamera.shouldCoupleCamera()) {
            return coupleCamera.isOnlyMoving() ? player.getYRot() : this.cameraYRot;
        }
        return Mth.abs((float)Mth.wrapDegrees((float)(this.cameraYRot - player.yBodyRot))) <= 51.0f ? this.cameraYRot : player.getYRot();
    }

    @ApiStatus.Internal
    public void onItemUseEvent(Player player, PlayerPatch<?> playerpatch, ItemStack itemstack, InteractionHand hand) {
        if (this.isTPSMode()) {
            EpicFightClientHooks.Camera.ITEM_USED_WHEN_DECOUPLED.post(new ItemUsedInDecoupledCamera(this, player, playerpatch, itemstack, hand));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean predicateFocusableEntity(Entity entity) {
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (entity.isSpectator()) return false;
        if (!entity.isPickable()) return false;
        if (!entity.isAlive()) return false;
        if (entity.is((Entity)this.minecraft.player)) return false;
        if (!this.minecraft.player.canAttack(livingEntity)) return false;
        return true;
    }

    private CoupleTPSCamera predicateCouplingPlayer() {
        @Nullable LocalPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class);
        CoupleTPSCamera coupleTPSCameraEvent = new CoupleTPSCamera(this, InputManager.getInputState(this.minecraft.player.input).getMoveVector().lengthSquared() > 0.0f, InputManager.isActionActive(MinecraftInputAction.ATTACK_DESTROY), this.minecraft.player.isUsingItem() && this.tpsItemAnimations.contains(this.minecraft.player.getUseItem().getUseAnimation()), this.isZooming(), playerpatch == null || playerpatch.isHoldingAny(), this.couplingYRot);
        EpicFightClientHooks.Camera.COUPLE_CAMERA.post(coupleTPSCameraEvent);
        return coupleTPSCameraEvent;
    }

    private void sendTargeting(@Nullable LivingEntity target) {
        EpicFightNetworkManager.sendToServer(new CPSetPlayerTarget(target == null ? -1 : target.getId()), new CustomPacketPayload[0]);
    }
}

