/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.ModList;
import yesman.epicfight.main.EpicFightMod;

public class VersionNotifier {
    private final Minecraft minecraft;
    private final boolean visible;
    private int count = 0;

    public VersionNotifier(Minecraft minecraft) {
        this.minecraft = minecraft;
        this.visible = ModList.get().getModFileById("epicfight").versionString().matches("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+");
    }

    public void init() {
        this.count = 0;
    }

    public void render(GuiGraphics guiGraphics, boolean inWorld) {
        if (!this.visible) {
            return;
        }
        if (this.count > 600 && inWorld) {
            return;
        }
        ++this.count;
        Window sr = this.minecraft.getWindow();
        int width = sr.getGuiScaledWidth();
        if (inWorld) {
            String l1 = Component.translatable((String)EpicFightMod.format("%s.messages.test_version_warning_line1")).getString();
            String l2 = Component.translatable((String)EpicFightMod.format("%s.messages.test_version_warning_line2"), (Object[])new Object[]{ModList.get().getModFileById("epicfight").versionString()}).getString();
            guiGraphics.drawString(this.minecraft.font, l1, width - this.minecraft.font.width(l1) - 2, 8, 0xFFFFFF);
            guiGraphics.drawString(this.minecraft.font, l2, width - this.minecraft.font.width(l2) - 2, 20, 0xFFFFFF);
        } else {
            String l1 = Component.translatable((String)EpicFightMod.format("%s.messages.version_notifier"), (Object[])new Object[]{ModList.get().getModFileById("epicfight").versionString()}).getString();
            guiGraphics.drawString(this.minecraft.font, l1, width - this.minecraft.font.width(l1) - 2, 8, 0xFFFFFF);
        }
    }
}

