/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import net.minecraft.client.CameraType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import yesman.epicfight.config.ClientConfig;

public class TPSSettingScreen
extends Screen {
    private static final ResourceLocation BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/widget/camera_settings.png");
    protected final Screen parentScreen;
    protected Button up;
    protected Button down;
    protected Button left;
    protected Button right;
    protected ZoomScroll zoomScroll;

    protected TPSSettingScreen(Screen parentScreen) {
        super((Component)Component.translatable((String)String.format("gui.%s.configuration.tps_mode_setting", "epicfight")));
        this.parentScreen = parentScreen;
    }

    public void init() {
        this.up = new CameraMoveButton(this, this.width / 2 - 7, this.height / 5 - 7, 14, 14, button -> {
            ClientConfig.cameraVerticalLocation = Math.min(5, ClientConfig.cameraVerticalLocation + 1);
            this.down.active = true;
            if (ClientConfig.cameraVerticalLocation >= 5) {
                this.up.active = false;
            }
        }, CameraMoveButton.Direction.UP);
        this.down = new CameraMoveButton(this, this.width / 2 - 7, this.height / 5 * 4 - 7, 14, 14, button -> {
            ClientConfig.cameraVerticalLocation = Math.max(-2, ClientConfig.cameraVerticalLocation - 1);
            this.up.active = true;
            if (ClientConfig.cameraVerticalLocation <= -2) {
                this.down.active = false;
            }
        }, CameraMoveButton.Direction.DOWN);
        this.left = new CameraMoveButton(this, this.width / 5 - 7, this.height / 2 - 7, 14, 14, button -> {
            ClientConfig.cameraHorizontalLocation = Math.min(10, ClientConfig.cameraHorizontalLocation + 1);
            this.right.active = true;
            if (ClientConfig.cameraHorizontalLocation >= 10) {
                this.left.active = false;
            }
        }, CameraMoveButton.Direction.LEFT);
        this.right = new CameraMoveButton(this, this.width / 5 * 4 - 7, this.height / 2 - 7, 14, 14, button -> {
            ClientConfig.cameraHorizontalLocation = Math.max(-10, ClientConfig.cameraHorizontalLocation - 1);
            this.left.active = true;
            if (ClientConfig.cameraHorizontalLocation <= -10) {
                this.right.active = false;
            }
        }, CameraMoveButton.Direction.RIGHT);
        this.zoomScroll = new ZoomScroll(this, this.width / 2 + 24, this.height / 2 - 26, ClientConfig.cameraZoom - 3);
        if (ClientConfig.cameraVerticalLocation >= 5) {
            this.up.active = false;
        }
        if (ClientConfig.cameraVerticalLocation <= -2) {
            this.down.active = false;
        }
        if (ClientConfig.cameraHorizontalLocation >= 10) {
            this.left.active = false;
        }
        if (ClientConfig.cameraHorizontalLocation <= -10) {
            this.right.active = false;
        }
        this.addRenderableWidget((GuiEventListener)this.up);
        this.addRenderableWidget((GuiEventListener)this.down);
        this.addRenderableWidget((GuiEventListener)this.left);
        this.addRenderableWidget((GuiEventListener)this.right);
        this.addRenderableWidget((GuiEventListener)this.zoomScroll);
        this.minecraft.options.setCameraType(CameraType.THIRD_PERSON_BACK);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.title, 6, 6, 0xFFFFFF);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)"Exit"), this.width - 24, 6, mouseX > this.width - 24 && mouseY < 16 ? 0x707070 : 0xFFFFFF);
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    public void onClose() {
        ClientConfig.saveChanges();
        this.minecraft.setScreen(this.parentScreen);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX > (double)(this.width - 24) && mouseY < 16.0) {
            ClientConfig.saveChanges();
            this.minecraft.setScreen(null);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double xScroll, double yScroll) {
        if (!super.mouseScrolled(pMouseX, pMouseY, xScroll, yScroll)) {
            this.zoomScroll.setScrollPosition(this.zoomScroll.scrollPosition - yScroll);
            return false;
        }
        return true;
    }

    private class CameraMoveButton
    extends Button {
        private final Direction direction;

        protected CameraMoveButton(TPSSettingScreen tPSSettingScreen, int x, int y, int width, int height, Button.OnPress onPress, Direction direction) {
            super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
            this.direction = direction;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            guiGraphics.pose().pushPose();
            int u = this.active ? 0 : 16;
            int v = this.active && this.isHovered() ? 16 : 0;
            guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
            guiGraphics.pose().translate(8.0f, 8.0f, 0.0f);
            switch (this.direction.ordinal()) {
                case 0: {
                    guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(90.0f));
                    break;
                }
                case 1: {
                    guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(270.0f));
                    break;
                }
                case 3: {
                    guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
                }
            }
            guiGraphics.pose().translate(-8.0f, -8.0f, 0.0f);
            guiGraphics.blit(BUTTON_TEXTURE, 0, 0, 0, (float)u, (float)v, 16, 16, 64, 64);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.pose().popPose();
        }

        public static enum Direction {
            UP,
            DOWN,
            LEFT,
            RIGHT;

        }
    }

    private class ZoomScroll
    extends AbstractWidget {
        private double scrollPosition;

        public ZoomScroll(TPSSettingScreen tPSSettingScreen, int x, int y, int initPos) {
            super(x, y, 12, 64, (Component)Component.empty());
            this.scrollPosition = initPos;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.blit(BUTTON_TEXTURE, this.getX(), this.getY(), 0, 52.0f, 0.0f, this.width, this.height, 64, 64);
            int scrollCoord = (int)this.scrollPosition * 6;
            guiGraphics.fill(this.getX() + 3, this.getY() + scrollCoord + 3, this.getX() + 9, this.getY() + scrollCoord + 7, -1);
        }

        public void onClick(double mouseX, double mouseY) {
            if ((double)(this.getX() + 3) <= mouseX && mouseX <= (double)(this.getX() + 9) && (double)(this.getY() + 1) <= mouseY && mouseY <= (double)(this.getY() + 63)) {
                this.setScrollBaseOnYPressed(mouseY);
            }
        }

        protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
            if ((double)(this.getX() + 3) <= mouseX && mouseX <= (double)(this.getX() + 9) && (double)(this.getY() + 1) <= mouseY + dragY && mouseY + dragY <= (double)(this.getY() + 63)) {
                this.setScrollBaseOnYPressed(mouseY + dragY);
            }
        }

        private void setScrollBaseOnYPressed(double y) {
            double relativeY = y - (double)this.getY() + 1.0;
            this.setScrollPosition(relativeY / 6.0);
        }

        private void setScrollPosition(double pos) {
            this.scrollPosition = (int)Mth.clamp((double)pos, (double)0.0, (double)7.0);
            ClientConfig.cameraZoom = (int)this.scrollPosition + 3;
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        }
    }
}

