/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.block.state.BlockState;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.level.block.FractureBlockState;

public class GroundSlamParticle
extends NoRenderParticle {
    protected GroundSlamParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, BlockPos bp, BlockState bs) {
        super(level, x, y, z, dx, dy, dz);
        FractureBlockState fractureBlockState;
        if (bs.isAir()) {
            bs = level.getBlockState(bp.below());
        }
        if (bs instanceof FractureBlockState && (bs = (fractureBlockState = (FractureBlockState)bs).getOriginalBlockState(bp)) == null) {
            bs = level.getBlockState(bp);
        }
        if (!bs.shouldSpawnTerrainParticles()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        for (int i = 0; i < (int)dy; ++i) {
            OpenMatrix4f mat = OpenMatrix4f.createRotatorDeg((float)Math.random() * 360.0f, Vec3f.Y_AXIS);
            Vec3f positionVec = OpenMatrix4f.transform3v(mat, Vec3f.Z_AXIS, null).scale((float)dx);
            Vec3f moveVec = OpenMatrix4f.transform3v(mat, Vec3f.Z_AXIS, null).scale((float)dz);
            TerrainParticle blockParticle = new TerrainParticle(level, x + (double)positionVec.x, y, z + (double)positionVec.z, 0.0, 0.0, 0.0, bs, bp);
            blockParticle.setParticleSpeed(((double)moveVec.x + (Math.random() - 0.5)) * 0.3, Math.random() * 0.5, ((double)moveVec.z + (Math.random() - 0.5)) * 0.3);
            blockParticle.setLifetime(60 + new Random().nextInt(20));
            Particle smokeParticle = mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x + (double)positionVec.x * 0.5, y + 1.5, z + (double)positionVec.z * 0.5, 0.0, 0.0, 0.0);
            smokeParticle.setParticleSpeed((double)moveVec.x * 0.1, Math.random() * 0.05, (double)moveVec.z * 0.1);
            smokeParticle.scale(3.0f);
            smokeParticle.alpha = 0.33f;
            mc.particleEngine.add((Particle)blockParticle);
            mc.particleEngine.add(smokeParticle);
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(x, y, z);
            BlockState blockstate = level.getBlockState((BlockPos)blockpos);
            if (blockstate == null) {
                return null;
            }
            return new GroundSlamParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, (BlockPos)blockpos, blockstate);
        }
    }
}

