/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import yesman.epicfight.api.utils.ByteBufCodecsExtends;
import yesman.epicfight.network.ManagedCustomPacketPayload;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public abstract class SPModifyPlayerData
implements ManagedCustomPacketPayload {
    private final int entityId;

    public static SetPlayerYRot setPlayerYRot(int entityId, float yaw) {
        return new SetPlayerYRot(entityId, yaw);
    }

    public static DisablePlayerYRot disablePlayerYRot(int entityId) {
        return new DisablePlayerYRot(entityId);
    }

    public static SetLastAttackResult setLastAttackResult(int entityId, boolean lastAttackSuccess) {
        return new SetLastAttackResult(entityId, lastAttackSuccess);
    }

    public static SetPlayerMode setPlayerMode(int entityId, PlayerPatch.PlayerMode mode) {
        return new SetPlayerMode(entityId, mode);
    }

    public static SetGrapplingTarget setGrapplingTarget(int entityId, Entity grapplingTarget) {
        return new SetGrapplingTarget(entityId, grapplingTarget == null ? -1 : grapplingTarget.getId());
    }

    private SPModifyPlayerData(int entityId) {
        this.entityId = entityId;
    }

    public int entityId() {
        return this.entityId;
    }

    public static class SetPlayerYRot
    extends SPModifyPlayerData {
        public static final StreamCodec<ByteBuf, SetPlayerYRot> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SPModifyPlayerData::entityId, (StreamCodec)ByteBufCodecs.FLOAT, SetPlayerYRot::yRot, SetPlayerYRot::new);
        private final float yRot;

        public SetPlayerYRot(int entityId, float yRot) {
            super(entityId);
            this.yRot = yRot;
        }

        public float yRot() {
            return this.yRot;
        }
    }

    public static class DisablePlayerYRot
    extends SPModifyPlayerData {
        public static final StreamCodec<ByteBuf, DisablePlayerYRot> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SPModifyPlayerData::entityId, DisablePlayerYRot::new);

        public DisablePlayerYRot(int entityId) {
            super(entityId);
        }
    }

    public static class SetLastAttackResult
    extends SPModifyPlayerData {
        public static final StreamCodec<ByteBuf, SetLastAttackResult> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SPModifyPlayerData::entityId, (StreamCodec)ByteBufCodecs.BOOL, SetLastAttackResult::lastAttackSuccess, SetLastAttackResult::new);
        private final boolean lastAttackSuccess;

        public SetLastAttackResult(int entityId, boolean lastAttackSuccess) {
            super(entityId);
            this.lastAttackSuccess = lastAttackSuccess;
        }

        public boolean lastAttackSuccess() {
            return this.lastAttackSuccess;
        }
    }

    public static class SetPlayerMode
    extends SPModifyPlayerData {
        public static final StreamCodec<ByteBuf, SetPlayerMode> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SPModifyPlayerData::entityId, ByteBufCodecsExtends.enumCodec(PlayerPatch.PlayerMode.class), SetPlayerMode::mode, SetPlayerMode::new);
        private final PlayerPatch.PlayerMode mode;

        public SetPlayerMode(int entityId, PlayerPatch.PlayerMode mode) {
            super(entityId);
            this.mode = mode;
        }

        public PlayerPatch.PlayerMode mode() {
            return this.mode;
        }
    }

    public static class SetGrapplingTarget
    extends SPModifyPlayerData {
        public static final StreamCodec<ByteBuf, SetGrapplingTarget> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SPModifyPlayerData::entityId, (StreamCodec)ByteBufCodecs.INT, SetGrapplingTarget::grapplingTargetEntityId, SetGrapplingTarget::new);
        private final int grapplingTargetEntityId;

        public SetGrapplingTarget(int entityId, int grapplingTargetEntityId) {
            super(entityId);
            this.grapplingTargetEntityId = grapplingTargetEntityId;
        }

        public int grapplingTargetEntityId() {
            return this.grapplingTargetEntityId;
        }
    }
}

