/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.data.reloader.ItemCapabilityReloadListener;
import yesman.epicfight.api.neoevent.WeaponCapabilityPresetRegistryEvent;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.server.SPDatapackSync;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.registry.EpicFightRegistries;
import yesman.epicfight.registry.entries.EpicFightConditions;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.item.WeaponCapabilityPresets;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public class WeaponTypeReloadListener
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "capabilities/weapons/types";
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<ResourceLocation, Function<Item, ? extends CapabilityItem.Builder<?>>> PRESETS = Maps.newHashMap();
    private static final Map<ResourceLocation, CompoundTag> CAPABILITY_COMPOUNDS = Maps.newHashMap();

    public static void registerDefaultWeaponTypes() {
        HashMap typeEntry = Maps.newHashMap();
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"axe"), WeaponCapabilityPresets.AXE);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"fist"), WeaponCapabilityPresets.FIST);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"hoe"), WeaponCapabilityPresets.HOE);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"pickaxe"), WeaponCapabilityPresets.PICKAXE);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"shovel"), WeaponCapabilityPresets.SHOVEL);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"sword"), WeaponCapabilityPresets.SWORD);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"spear"), WeaponCapabilityPresets.SPEAR);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"greatsword"), WeaponCapabilityPresets.GREATSWORD);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"uchigatana"), WeaponCapabilityPresets.UCHIGATANA);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"tachi"), WeaponCapabilityPresets.TACHI);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"longsword"), WeaponCapabilityPresets.LONGSWORD);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"dagger"), WeaponCapabilityPresets.DAGGER);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"bow"), WeaponCapabilityPresets.BOW);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"crossbow"), WeaponCapabilityPresets.CROSSBOW);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"trident"), WeaponCapabilityPresets.TRIDENT);
        typeEntry.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"shield"), WeaponCapabilityPresets.SHIELD);
        WeaponCapabilityPresetRegistryEvent weaponCapabilityPresetRegistryEvent = new WeaponCapabilityPresetRegistryEvent(typeEntry);
        ModLoader.postEvent((Event)weaponCapabilityPresetRegistryEvent);
        PRESETS.putAll(weaponCapabilityPresetRegistryEvent.getTypeEntry());
    }

    public WeaponTypeReloadListener() {
        super(GSON, DIRECTORY);
    }

    protected void apply(Map<ResourceLocation, JsonElement> packEntry, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        WeaponTypeReloadListener.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : packEntry.entrySet()) {
            CompoundTag compTag = null;
            try {
                compTag = TagParser.parseTag((String)entry.getValue().toString());
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            try {
                CompoundTag comptagFinal = compTag;
                PRESETS.put(entry.getKey(), itemstack -> WeaponTypeReloadListener.deserializeWeaponCapabilityBuilder((ResourceLocation)entry.getKey(), comptagFinal));
                CAPABILITY_COMPOUNDS.put(entry.getKey(), compTag);
            }
            catch (Exception e) {
                EpicFightMod.LOGGER.warn("Error while deserializing weapon type datapack: " + String.valueOf(entry.getKey()));
                e.printStackTrace();
            }
        }
    }

    public static Function<Item, ? extends CapabilityItem.Builder<?>> getOrThrow(String typeName) {
        ResourceLocation rl = ResourceLocation.parse((String)typeName);
        if (!PRESETS.containsKey(rl)) {
            throw new IllegalArgumentException("Can't find weapon type: " + String.valueOf(rl));
        }
        return PRESETS.get(rl);
    }

    public static Function<Item, ? extends CapabilityItem.Builder<?>> get(String typeName) {
        return WeaponTypeReloadListener.get(ResourceLocation.parse((String)typeName));
    }

    public static Function<Item, ? extends CapabilityItem.Builder<?>> get(ResourceLocation typeName) {
        return PRESETS.get(typeName);
    }

    public static <T extends CapabilityItem.Builder<?>> void register(ResourceLocation rl, T builder) {
        PRESETS.put(rl, item -> builder);
    }

    public static WeaponCapability.Builder deserializeWeaponCapabilityBuilder(ResourceLocation rl, CompoundTag tag) {
        SoundEvent sound;
        WeaponCapability.Builder builder = WeaponCapability.builder();
        if (!tag.contains("category") || StringUtil.isNullOrEmpty((String)tag.getString("category"))) {
            throw new IllegalArgumentException("Define weapon category.");
        }
        builder.category(WeaponCategory.ENUM_MANAGER.getOrThrow(tag.getString("category")));
        builder.collider(ColliderPreset.deserializeSimpleCollider(tag.getCompound("collider")));
        builder.canBePlacedOffhand(tag.contains("usable_in_offhand") ? tag.getBoolean("usable_in_offhand") : true);
        if (tag.contains("hit_particle")) {
            ParticleType particleType = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)tag.getString("hit_particle")));
            if (particleType == null) {
                EpicFightMod.LOGGER.warn("Can't find a particle type " + tag.getString("hit_particle") + " in " + String.valueOf(rl));
            } else if (!(particleType instanceof HitParticleType)) {
                EpicFightMod.LOGGER.warn(tag.getString("hit_particle") + " is not a hit particle type in " + String.valueOf(rl));
            } else {
                builder.hitParticle((HitParticleType)particleType);
            }
        }
        if (tag.contains("swing_sound")) {
            sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)tag.getString("swing_sound")));
            if (sound == null) {
                EpicFightMod.LOGGER.warn("Can't find a swing sound " + tag.getString("swing_sound") + " in " + String.valueOf(rl));
            } else {
                builder.swingSound(sound);
            }
        }
        if (tag.contains("hit_sound")) {
            sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)tag.getString("hit_sound")));
            if (sound == null) {
                EpicFightMod.LOGGER.warn("Can't find a hit sound " + tag.getString("hit_sound") + " in " + String.valueOf(rl));
            } else {
                builder.hitSound(sound);
            }
        }
        CompoundTag combosTag = tag.getCompound("combos");
        for (Object key : combosTag.getAllKeys()) {
            Style style = Style.ENUM_MANAGER.getOrThrow((String)key);
            ListTag comboAnimations = combosTag.getList((String)key, 8);
            AnimationManager.AnimationAccessor[] animArray = new AnimationManager.AnimationAccessor[comboAnimations.size()];
            for (int i = 0; i < comboAnimations.size(); ++i) {
                animArray[i] = AnimationManager.byKey(comboAnimations.getString(i));
            }
            builder.newStyleCombo(style, animArray);
        }
        CompoundTag innateSkillsTag = tag.getCompound("innate_skills");
        for (Object key : innateSkillsTag.getAllKeys()) {
            Style style = Style.ENUM_MANAGER.getOrThrow((String)key);
            Skill skill = (Skill)EpicFightRegistries.SKILL.get(ResourceLocation.parse((String)innateSkillsTag.getString((String)key)));
            builder.innateSkill(style, itemstack -> skill);
        }
        CompoundTag livingmotionModifierTag = tag.getCompound("livingmotion_modifier");
        for (String sStyle : livingmotionModifierTag.getAllKeys()) {
            Style style = Style.ENUM_MANAGER.getOrThrow(sStyle);
            CompoundTag styleAnimationTag = livingmotionModifierTag.getCompound(sStyle);
            for (String sLivingmotion : styleAnimationTag.getAllKeys()) {
                LivingMotion livingmotion = LivingMotion.ENUM_MANAGER.getOrThrow(sLivingmotion);
                AnimationManager.AnimationAccessor animation = AnimationManager.byKey(styleAnimationTag.getString(sLivingmotion));
                builder.livingMotionModifier(style, livingmotion, animation);
            }
        }
        CompoundTag stylesTag = tag.getCompound("styles");
        ArrayList conditions = Lists.newArrayList();
        Style defaultStyle = Style.ENUM_MANAGER.getOrThrow(stylesTag.getString("default"));
        for (Tag caseTag : stylesTag.getList("cases", 10)) {
            CompoundTag caseCompTag = (CompoundTag)caseTag;
            ArrayList conditionList = Lists.newArrayList();
            for (Tag offhandTag : caseCompTag.getList("conditions", 10)) {
                CompoundTag offhandCompound = (CompoundTag)offhandTag;
                Supplier conditionProvider = EpicFightConditions.getConditionOrThrow(ResourceLocation.parse((String)offhandCompound.getString("predicate")));
                Condition.EntityPatchCondition condition = (Condition.EntityPatchCondition)conditionProvider.get();
                condition.read(offhandCompound);
                conditionList.add(condition);
            }
            conditions.add(Pair.of(entitypatch -> {
                for (Condition.EntityPatchCondition condition : conditionList) {
                    if (condition.predicate(entitypatch)) continue;
                    return false;
                }
                return true;
            }, (Object)Style.ENUM_MANAGER.getOrThrow(caseCompTag.getString("style"))));
        }
        builder.styleProvider(entitypatch -> {
            for (Pair entry : conditions) {
                if (!((Predicate)entry.getFirst()).test(entitypatch)) continue;
                return (Style)entry.getSecond();
            }
            return defaultStyle;
        });
        if (tag.contains("offhand_item_compatible_predicate")) {
            ListTag offhandValidatorList = tag.getList("offhand_item_compatible_predicate", 10);
            ArrayList conditionList = Lists.newArrayList();
            for (Tag offhandTag : offhandValidatorList) {
                CompoundTag offhandCompound = (CompoundTag)offhandTag;
                Supplier conditionProvider = EpicFightConditions.getConditionOrThrow(ResourceLocation.parse((String)offhandCompound.getString("predicate")));
                Condition.EntityPatchCondition condition = (Condition.EntityPatchCondition)conditionProvider.get();
                condition.read(offhandCompound);
                conditionList.add(condition);
            }
            builder.weaponCombinationPredicator(entitypatch -> {
                for (Condition.EntityPatchCondition condition : conditionList) {
                    if (condition.predicate(entitypatch)) continue;
                    return false;
                }
                return true;
            });
        }
        return builder;
    }

    public static Stream<CompoundTag> getWeaponTypeDataStream() {
        Stream<CompoundTag> tagStream = CAPABILITY_COMPOUNDS.entrySet().stream().map(entry -> {
            ((CompoundTag)entry.getValue()).putString("registry_name", ((ResourceLocation)entry.getKey()).toString());
            return (CompoundTag)entry.getValue();
        });
        return tagStream;
    }

    public static Set<Map.Entry<ResourceLocation, Function<Item, ? extends CapabilityItem.Builder<?>>>> entries() {
        return PRESETS.entrySet();
    }

    public static void clear() {
        PRESETS.clear();
        WeaponTypeReloadListener.registerDefaultWeaponTypes();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processServerPacket(SPDatapackSync packet) {
        if (packet.packetType() == SPDatapackSync.PacketType.WEAPON_TYPE) {
            PRESETS.clear();
            WeaponTypeReloadListener.registerDefaultWeaponTypes();
            for (CompoundTag tag : packet.tags()) {
                ResourceLocation rl = ResourceLocation.parse((String)tag.getString("registry_name"));
                try {
                    PRESETS.put(rl, itemstack -> WeaponTypeReloadListener.deserializeWeaponCapabilityBuilder(rl, tag));
                }
                catch (Exception e) {
                    throw new RuntimeException("Weapon type " + String.valueOf(rl) + " encountered an error", e);
                }
            }
            ItemCapabilityReloadListener.weaponTypeProcessedCheck();
        }
    }
}

