/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.provider;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.world.capabilities.item.ArmorCapability;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.ItemKeywordReloadListener;
import yesman.epicfight.world.capabilities.item.MapCapability;
import yesman.epicfight.world.capabilities.item.RuntimeCapability;
import yesman.epicfight.world.capabilities.item.WeaponCapabilityPresets;
import yesman.epicfight.world.capabilities.item.WeaponTypeReloadListener;

public final class CommonItemCapabilityProvider
implements ICapabilityProvider<ItemStack, Void, CapabilityItem> {
    public static final CommonItemCapabilityProvider INSTANCE = new CommonItemCapabilityProvider();
    private final Map<Class<? extends Item>, Function<Item, ? extends CapabilityItem.Builder<?>>> typedCapabilities = new HashMap();
    private final Map<Item, CapabilityItem> capabilities = new HashMap<Item, CapabilityItem>();

    private CommonItemCapabilityProvider() {
    }

    public void registerWeaponTypesByClass() {
        this.typedCapabilities.put(ArmorItem.class, item -> ArmorCapability.builder().byItem((Item)item));
        this.typedCapabilities.put(ShieldItem.class, WeaponCapabilityPresets.SHIELD);
        this.typedCapabilities.put(SwordItem.class, WeaponCapabilityPresets.SWORD);
        this.typedCapabilities.put(PickaxeItem.class, WeaponCapabilityPresets.PICKAXE);
        this.typedCapabilities.put(AxeItem.class, WeaponCapabilityPresets.AXE);
        this.typedCapabilities.put(ShovelItem.class, WeaponCapabilityPresets.SHOVEL);
        this.typedCapabilities.put(HoeItem.class, WeaponCapabilityPresets.HOE);
        this.typedCapabilities.put(BowItem.class, WeaponCapabilityPresets.BOW);
        this.typedCapabilities.put(CrossbowItem.class, WeaponCapabilityPresets.CROSSBOW);
        this.typedCapabilities.put(MapItem.class, item -> MapCapability.builder());
    }

    public void put(Item item, CapabilityItem cap) {
        this.capabilities.put(item, cap);
    }

    public CapabilityItem get(Item item) {
        return this.capabilities.getOrDefault(item, this.typedCapabilities.containsKey(item.getClass()) ? this.typedCapabilities.get(item.getClass()).apply(item).build() : null);
    }

    public void clear() {
        this.capabilities.clear();
    }

    public void addDefaultItems() {
        BuiltInRegistries.ITEM.entrySet().stream().filter(entry -> !this.capabilities.containsKey(entry.getValue())).forEach(entry -> {
            Function<Item, CapabilityItem.Builder<?>> type = null;
            Item item = (Item)entry.getValue();
            if (item instanceof BlockItem) {
                return;
            }
            for (Map.Entry<ResourceLocation, ItemKeywordReloadListener.ItemRegex> regexEntry : ItemKeywordReloadListener.getRegexes().entrySet()) {
                if (!regexEntry.getValue().matchesAny(((ResourceKey)entry.getKey()).location().toString()) || (type = WeaponTypeReloadListener.get(regexEntry.getKey())) == null) continue;
                this.capabilities.put(item, type.apply(item).build());
                break;
            }
            if (type == null) {
                CapabilityItem capability = null;
                for (Class<?> clazz = item.getClass(); clazz != null && capability == null; clazz = clazz.getSuperclass()) {
                    if (!this.typedCapabilities.containsKey(clazz)) continue;
                    capability = this.typedCapabilities.get(clazz).apply(item).build();
                }
                if (capability != null) {
                    this.capabilities.put(item, capability);
                }
            }
        });
    }

    @Nullable
    public CapabilityItem getCapability(ItemStack itemstack, Void context) {
        if (this.capabilities.containsKey(itemstack.getItem())) {
            CapabilityItem itemCapability = this.capabilities.get(itemstack.getItem());
            if (itemCapability instanceof RuntimeCapability) {
                return itemCapability.findRecursive(itemstack);
            }
            return itemCapability;
        }
        return null;
    }
}

