/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.damagesource;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.common.extensions.ILevelReaderExtension;
import yesman.epicfight.world.capabilities.item.WeaponCapabilityPresets;

public class ExtraDamageInstance {
    public static final ExtraDamage EVISCERATE_LOST_HEALTH = new ExtraDamage((attacker, itemstack, target, baseDamage, params) -> {
        int tier = 0;
        Item patt0$temp = itemstack.getItem();
        if (patt0$temp instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)patt0$temp;
            tier += WeaponCapabilityPresets.vanillaTierToLevel(tieredItem.getTier());
        }
        return (target.getMaxHealth() - target.getHealth()) * (params[0] + 0.05f * (float)tier);
    }, (levelReader, itemstack, tooltips, baseDamage, params) -> {
        int tier = 0;
        Item patt0$temp = itemstack.getItem();
        if (patt0$temp instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)patt0$temp;
            tier += WeaponCapabilityPresets.vanillaTierToLevel(tieredItem.getTier());
        }
        tooltips.append((Component)Component.translatable((String)"damage_source.epicfight.target_lost_health", (Object[])new Object[]{Component.literal((String)(ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format((params[0] + (float)tier * 0.05f) * 100.0f) + "%")).withStyle(ChatFormatting.RED)}).withStyle(ChatFormatting.DARK_GRAY));
    });
    public static final ExtraDamage SWEEPING_EDGE_ENCHANTMENT = new ExtraDamage((attacker, itemstack, target, baseDamage, params) -> {
        int i = itemstack.getEnchantmentLevel(attacker.level().holderOrThrow(Enchantments.SWEEPING_EDGE));
        float modifier = i > 0 ? (float)i / ((float)i + 1.0f) : 0.0f;
        return baseDamage * modifier;
    }, (levelReader, itemstack, tooltips, baseDamage, params) -> {
        int i = itemstack.getEnchantmentLevel(levelReader.holderOrThrow(Enchantments.SWEEPING_EDGE));
        if (i > 0) {
            double modifier = (double)i / ((double)i + 1.0);
            double damage = baseDamage * modifier;
            MutableComponent sweepedgetooltip = Component.translatable((String)"damage_source.epicfight.sweeping_edge_enchant_level", (Object[])new Object[]{Component.literal((String)ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(damage)).withStyle(ChatFormatting.DARK_PURPLE), i}).withStyle(ChatFormatting.DARK_GRAY);
            tooltips.append((Component)sweepedgetooltip);
        }
    });
    private final ExtraDamage calculator;
    private final float[] params;

    public ExtraDamageInstance(ExtraDamage calculator, float ... params) {
        this.calculator = calculator;
        this.params = params;
    }

    public float[] getParams() {
        return this.params;
    }

    public Object[] toTransableComponentParams() {
        Object[] params = new Object[this.params.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = Component.literal((String)(ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.params[i] * 100.0f) + "%")).withStyle(ChatFormatting.RED);
        }
        return params;
    }

    public float get(LivingEntity attacker, ItemStack hurtItem, LivingEntity target, float baseDamage) {
        return this.calculator.extraDamage.getBonusDamage(attacker, hurtItem, target, baseDamage, this.params);
    }

    public void setTooltips(ILevelReaderExtension levelReader, ItemStack itemstack, MutableComponent tooltip, double baseDamage) {
        this.calculator.tooltip.setTooltip(levelReader, itemstack, tooltip, baseDamage, this.params);
    }

    public static class ExtraDamage {
        ExtraDamageFunction extraDamage;
        ExtraDamageTooltipFunction tooltip;

        public ExtraDamage(ExtraDamageFunction extraDamage, ExtraDamageTooltipFunction tooltip) {
            this.extraDamage = extraDamage;
            this.tooltip = tooltip;
        }

        public ExtraDamageInstance create(float ... params) {
            return new ExtraDamageInstance(this, params);
        }
    }

    @FunctionalInterface
    public static interface ExtraDamageFunction {
        public float getBonusDamage(LivingEntity var1, ItemStack var2, LivingEntity var3, float var4, float[] var5);
    }

    @FunctionalInterface
    public static interface ExtraDamageTooltipFunction {
        public void setTooltip(ILevelReaderExtension var1, ItemStack var2, MutableComponent var3, double var4, float[] var6);
    }
}

