/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.AnimationSubFileReader;
import yesman.epicfight.api.client.camera.EpicFightCameraAPI;
import yesman.epicfight.api.client.forgeevent.PatchedRenderersEvent;
import yesman.epicfight.api.client.forgeevent.RenderEnderDragonEvent;
import yesman.epicfight.api.client.input.InputManager;
import yesman.epicfight.api.client.input.action.EpicFightInputAction;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.EntityUI;
import yesman.epicfight.client.gui.VersionNotifier;
import yesman.epicfight.client.gui.screen.config.UISetupScreen;
import yesman.epicfight.client.gui.screen.overlay.OverlayManager;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.mesh.PiglinMesh;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.FakeBlockRenderer;
import yesman.epicfight.client.renderer.FirstPersonRenderer;
import yesman.epicfight.client.renderer.VanillaFakeBlockRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCreeperRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCustomEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PCustomHumanoidEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PDrownedRenderer;
import yesman.epicfight.client.renderer.patched.entity.PEnderDragonRenderer;
import yesman.epicfight.client.renderer.patched.entity.PEndermanRenderer;
import yesman.epicfight.client.renderer.patched.entity.PHoglinRenderer;
import yesman.epicfight.client.renderer.patched.entity.PHumanoidRenderer;
import yesman.epicfight.client.renderer.patched.entity.PIllagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PIronGolemRenderer;
import yesman.epicfight.client.renderer.patched.entity.PPlayerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PRavagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PSpiderRenderer;
import yesman.epicfight.client.renderer.patched.entity.PStrayRenderer;
import yesman.epicfight.client.renderer.patched.entity.PVexRenderer;
import yesman.epicfight.client.renderer.patched.entity.PVindicatorRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitchRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherRenderer;
import yesman.epicfight.client.renderer.patched.entity.PWitherSkeletonMinionRenderer;
import yesman.epicfight.client.renderer.patched.entity.PZombieVillagerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PresetRenderer;
import yesman.epicfight.client.renderer.patched.entity.WitherGhostCloneRenderer;
import yesman.epicfight.client.renderer.patched.item.RenderFilledMap;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.client.renderer.patched.item.RenderKatana;
import yesman.epicfight.client.renderer.patched.item.RenderShield;
import yesman.epicfight.client.renderer.patched.item.RenderTrident;
import yesman.epicfight.client.renderer.patched.item.RenderTwoHandedRangedWeapon;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.BossPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.BowCapability;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.CrossbowCapability;
import yesman.epicfight.world.capabilities.item.MapCapability;
import yesman.epicfight.world.capabilities.item.ShieldCapability;
import yesman.epicfight.world.capabilities.item.TridentCapability;
import yesman.epicfight.world.entity.EpicFightEntities;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class RenderEngine {
    public final BattleModeGui battleModeUI;
    public final VersionNotifier versionNotifier;
    public final Minecraft minecraft;
    private Map<ResourceLocation, Function<JsonElement, RenderItemBase>> itemRenderers;
    private final BiMap<EntityType<?>, Function<EntityType<?>, PatchedEntityRenderer>> entityRendererProvider;
    private final Map<EntityType<?>, PatchedEntityRenderer> entityRendererCache;
    private final Map<Item, RenderItemBase> itemRendererMapByInstance;
    private final Map<Class<?>, RenderItemBase> itemRendererMapByClass;
    private final Map<UUID, BossPatch> bossEventOwners = Maps.newConcurrentMap();
    private final OverlayManager overlayManager;
    private FakeBlockRenderer fakeBlockRenderer;
    private FirstPersonRenderer firstPersonRenderer;
    private PHumanoidRenderer<?, ?, ?, ?, ?> basicHumanoidRenderer;
    private int modelInitTimer;

    public RenderEngine() {
        Events.renderEngine = this;
        this.minecraft = Minecraft.m_91087_();
        this.battleModeUI = new BattleModeGui(this.minecraft);
        this.versionNotifier = new VersionNotifier(this.minecraft);
        this.entityRendererProvider = HashBiMap.create();
        this.entityRendererCache = Maps.newHashMap();
        this.itemRendererMapByInstance = Maps.newHashMap();
        this.itemRendererMapByClass = Maps.newHashMap();
        this.overlayManager = new OverlayManager();
        this.fakeBlockRenderer = new VanillaFakeBlockRenderer();
    }

    public void initialize() {
        HashMap builder = Maps.newHashMap();
        builder.put(ResourceLocation.withDefaultNamespace((String)"base"), RenderItemBase::new);
        builder.put(ResourceLocation.withDefaultNamespace((String)"ranged"), RenderTwoHandedRangedWeapon::new);
        builder.put(ResourceLocation.withDefaultNamespace((String)"map"), RenderFilledMap::new);
        builder.put(ResourceLocation.withDefaultNamespace((String)"shield"), RenderShield::new);
        builder.put(ResourceLocation.withDefaultNamespace((String)"trident"), RenderTrident::new);
        builder.put(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"uchigatana"), RenderKatana::new);
        ModLoader.get().postEvent((Event)new PatchedRenderersEvent.RegisterItemRenderer(builder));
        this.itemRenderers = ImmutableMap.copyOf((Map)builder);
    }

    public void reloadFakeBlockRenderer(FakeBlockRenderer fakeBlockRenderer) {
        this.fakeBlockRenderer = fakeBlockRenderer;
    }

    public void reloadEntityRenderers(EntityRendererProvider.Context context) {
        this.entityRendererProvider.clear();
        this.entityRendererProvider.put((Object)EntityType.f_20558_, entityType -> new PCreeperRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20566_, entityType -> new PEndermanRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20501_, entityType -> new PHumanoidRenderer((AssetAccessor<HumanoidMesh>)Meshes.BIPED_OLD_TEX, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20530_, entityType -> new PZombieVillagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20531_, entityType -> new PHumanoidRenderer((AssetAccessor<PiglinMesh>)Meshes.PIGLIN, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20458_, entityType -> new PHumanoidRenderer((AssetAccessor<HumanoidMesh>)Meshes.BIPED_OLD_TEX, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20524_, entityType -> new PHumanoidRenderer((AssetAccessor<HumanoidMesh>)Meshes.SKELETON, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20497_, entityType -> new PHumanoidRenderer((AssetAccessor<HumanoidMesh>)Meshes.SKELETON, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20481_, entityType -> new PStrayRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20532_, entityType -> new PPlayerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20479_, entityType -> new PSpiderRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20554_, entityType -> new PSpiderRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20460_, entityType -> new PIronGolemRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20493_, entityType -> new PVindicatorRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20568_, entityType -> new PIllagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20495_, entityType -> new PWitchRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20562_, entityType -> new PDrownedRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20513_, entityType -> new PIllagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20518_, entityType -> new PRavagerRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20491_, entityType -> new PVexRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20511_, entityType -> new PHumanoidRenderer((AssetAccessor<PiglinMesh>)Meshes.PIGLIN, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20512_, entityType -> new PHumanoidRenderer((AssetAccessor<PiglinMesh>)Meshes.PIGLIN, context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20456_, entityType -> new PHoglinRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20500_, entityType -> new PHoglinRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)EntityType.f_20565_, entityType -> new PEnderDragonRenderer());
        this.entityRendererProvider.put((Object)EntityType.f_20496_, entityType -> new PWitherRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)((EntityType)EpicFightEntities.WITHER_SKELETON_MINION.get()), entityType -> new PWitherSkeletonMinionRenderer(context, (EntityType<?>)entityType).initLayerLast(context, (EntityType<?>)entityType));
        this.entityRendererProvider.put((Object)((EntityType)EpicFightEntities.WITHER_GHOST_CLONE.get()), entityType -> new WitherGhostCloneRenderer());
        this.firstPersonRenderer = new FirstPersonRenderer(context, EntityType.f_20532_);
        this.basicHumanoidRenderer = new PHumanoidRenderer(Meshes.BIPED, context, EntityType.f_20532_);
        ModLoader.get().postEvent((Event)new PatchedRenderersEvent.Add((Map<EntityType<?>, Function<EntityType<?>, PatchedEntityRenderer>>)this.entityRendererProvider, context));
        this.resetRenderers();
    }

    public void reloadItemRenderers(Map<ResourceLocation, JsonElement> objects) {
        this.itemRendererMapByInstance.clear();
        this.itemRendererMapByClass.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objects.entrySet()) {
            Function<JsonElement, RenderItemBase> rendererProvider;
            ResourceLocation rl = entry.getKey();
            String pathString = rl.m_135815_();
            ResourceLocation registryName = ResourceLocation.fromNamespaceAndPath((String)rl.m_135827_(), (String)pathString);
            if (!ForgeRegistries.ITEMS.containsKey(registryName)) {
                EpicFightMod.LOGGER.warn("Failed to load item skin: no item named " + registryName);
                continue;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
            if (entry.getValue().getAsJsonObject().has("renderer")) {
                ResourceLocation rendererName = ResourceLocation.parse((String)entry.getValue().getAsJsonObject().get("renderer").getAsString());
                if (this.itemRenderers.containsKey(rendererName)) {
                    rendererProvider = this.itemRenderers.get(rendererName);
                } else {
                    EpicFightMod.LOGGER.warn("No renderer named " + rendererName);
                    rendererProvider = RenderItemBase::new;
                }
            } else {
                rendererProvider = RenderItemBase::new;
            }
            RenderItemBase itemRenderer = rendererProvider.apply(entry.getValue());
            this.itemRendererMapByInstance.put(item, itemRenderer);
        }
        RenderItemBase baseRenderer = new RenderItemBase((JsonElement)new JsonObject());
        RenderTwoHandedRangedWeapon bowRenderer = new RenderTwoHandedRangedWeapon((JsonElement)objects.get(ForgeRegistries.ITEMS.getKey((Object)Items.f_42411_)).getAsJsonObject());
        RenderTwoHandedRangedWeapon crossbowRenderer = new RenderTwoHandedRangedWeapon((JsonElement)objects.get(ForgeRegistries.ITEMS.getKey((Object)Items.f_42717_)).getAsJsonObject());
        RenderTrident tridentRenderer = new RenderTrident((JsonElement)objects.get(ForgeRegistries.ITEMS.getKey((Object)Items.f_42713_)).getAsJsonObject());
        RenderFilledMap mapRenderer = new RenderFilledMap((JsonElement)objects.get(ForgeRegistries.ITEMS.getKey((Object)Items.f_42573_)).getAsJsonObject());
        RenderShield shieldRenderer = new RenderShield((JsonElement)objects.get(ForgeRegistries.ITEMS.getKey((Object)Items.f_42740_)).getAsJsonObject());
        this.itemRendererMapByClass.put(BowItem.class, bowRenderer);
        this.itemRendererMapByClass.put(CrossbowItem.class, crossbowRenderer);
        this.itemRendererMapByClass.put(ShieldItem.class, baseRenderer);
        this.itemRendererMapByClass.put(TridentItem.class, tridentRenderer);
        this.itemRendererMapByClass.put(ShieldItem.class, shieldRenderer);
        this.itemRendererMapByClass.put(BowCapability.class, bowRenderer);
        this.itemRendererMapByClass.put(CrossbowCapability.class, crossbowRenderer);
        this.itemRendererMapByClass.put(TridentCapability.class, tridentRenderer);
        this.itemRendererMapByClass.put(MapCapability.class, mapRenderer);
        this.itemRendererMapByClass.put(ShieldCapability.class, shieldRenderer);
    }

    public void resetRenderers() {
        this.entityRendererCache.clear();
        for (Map.Entry entry : this.entityRendererProvider.entrySet()) {
            this.entityRendererCache.put((EntityType)entry.getKey(), (PatchedEntityRenderer)((Function)entry.getValue()).apply((EntityType)entry.getKey()));
        }
        ModLoader.get().postEvent((Event)new PatchedRenderersEvent.Modify(this.entityRendererCache));
    }

    public void registerCustomEntityRenderer(EntityType<?> entityType, String rendererName, CompoundTag compound) {
        if (StringUtil.m_14408_((String)rendererName)) {
            return;
        }
        EntityRenderDispatcher erd = this.minecraft.m_91290_();
        EntityRendererProvider.Context context = new EntityRendererProvider.Context(erd, this.minecraft.m_91291_(), this.minecraft.m_91289_(), erd.m_234586_(), this.minecraft.m_91098_(), this.minecraft.m_167973_(), this.minecraft.f_91062_);
        if ("player".equals(rendererName)) {
            this.entityRendererCache.put(entityType, this.basicHumanoidRenderer);
        } else if ("epicfight:custom".equals(rendererName)) {
            if (compound.m_128471_("humanoid")) {
                this.entityRendererCache.put(entityType, new PCustomHumanoidEntityRenderer<HumanoidMesh>(Meshes.getOrCreate(ResourceLocation.parse((String)compound.m_128461_("model")), jsonAssetLoader -> jsonAssetLoader.loadSkinnedMesh(HumanoidMesh::new)), context, entityType));
            } else {
                this.entityRendererCache.put(entityType, new PCustomEntityRenderer(Meshes.getOrCreate(ResourceLocation.parse((String)compound.m_128461_("model")), jsonAssetLoader -> jsonAssetLoader.loadSkinnedMesh(HumanoidMesh::new)), context));
            }
        } else {
            EntityType presetEntityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.parse((String)rendererName));
            if (this.entityRendererProvider.containsKey((Object)presetEntityType)) {
                PatchedEntityRenderer renderer = (PatchedEntityRenderer)((Function)this.entityRendererProvider.get((Object)presetEntityType)).apply(entityType);
                if (!(this.minecraft.m_91290_().f_114362_.get(entityType) instanceof LivingEntityRenderer) && renderer instanceof PatchedLivingEntityRenderer) {
                    PatchedLivingEntityRenderer patchedLivingEntityRenderer = (PatchedLivingEntityRenderer)renderer;
                    this.entityRendererCache.put(entityType, new PresetRenderer(context, entityType, (LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>>)((LivingEntityRenderer)context.m_174022_().f_114362_.get(presetEntityType)), patchedLivingEntityRenderer.getDefaultMesh()));
                } else {
                    this.entityRendererCache.put(entityType, (PatchedEntityRenderer)((Function)this.entityRendererProvider.get((Object)presetEntityType)).apply(entityType));
                }
            } else {
                throw new IllegalArgumentException("Datapack Mob Patch Crash: Invalid Renderer type " + rendererName);
            }
        }
    }

    public RenderItemBase getItemRenderer(ItemStack itemstack) {
        RenderItemBase renderItem = this.itemRendererMapByInstance.get(itemstack.m_41720_());
        if (renderItem == null) {
            renderItem = this.findMatchingRendererByClass(itemstack.m_41720_().getClass());
            if (renderItem == null) {
                CapabilityItem itemCap = EpicFightCapabilities.getItemStackCapability(itemstack);
                renderItem = this.findMatchingRendererByClass(itemCap.getClass());
            }
            if (renderItem == null) {
                renderItem = this.itemRendererMapByInstance.get(Items.f_41852_);
            }
            this.itemRendererMapByInstance.put(itemstack.m_41720_(), renderItem);
        }
        return renderItem;
    }

    private RenderItemBase findMatchingRendererByClass(Class<?> clazz) {
        RenderItemBase renderer = null;
        while (clazz != null && renderer == null) {
            renderer = this.itemRendererMapByClass.get(clazz);
            clazz = clazz.getSuperclass();
        }
        return renderer;
    }

    public void renderEntityArmatureModel(LivingEntity livingEntity, LivingEntityPatch<?> entitypatch, EntityRenderer<? extends Entity> renderer, MultiBufferSource buffer, PoseStack matStack, int packedLight, float partialTicks) {
        this.getEntityRenderer((Entity)livingEntity).render(livingEntity, entitypatch, renderer, buffer, matStack, packedLight, partialTicks);
    }

    public PatchedEntityRenderer getEntityRenderer(Entity entity) {
        return this.getEntityRenderer(entity.m_6095_());
    }

    public PatchedEntityRenderer getEntityRenderer(EntityType entityType) {
        return this.entityRendererCache.get(entityType);
    }

    public boolean hasRendererFor(Entity entity) {
        return this.entityRendererCache.computeIfAbsent(entity.m_6095_(), key -> this.entityRendererProvider.containsKey(key) ? (PatchedEntityRenderer)((Function)this.entityRendererProvider.get((Object)entity.m_6095_())).apply(entity.m_6095_()) : null) != null;
    }

    public Set<ResourceLocation> getRendererEntries() {
        Set<ResourceLocation> availableRendererEntities = this.entityRendererProvider.keySet().stream().map(entityType -> EntityType.m_20613_((EntityType)entityType)).collect(Collectors.toSet());
        availableRendererEntities.add(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"custom"));
        return availableRendererEntities;
    }

    public void setModelInitializerTimer(int tick) {
        this.modelInitTimer = tick;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public FirstPersonRenderer getFirstPersonRenderer() {
        return this.firstPersonRenderer;
    }

    public void upSlideSkillUI() {
        this.battleModeUI.slideUp();
    }

    public void downSlideSkillUI() {
        this.battleModeUI.slideDown();
    }

    public boolean shouldRenderVanillaModel() {
        return ClientEngine.getInstance().isVanillaModelDebuggingMode() || this.modelInitTimer > 0;
    }

    public void addBossEventOwner(UUID uuid, BossPatch bosspatch) {
        this.bossEventOwners.put(uuid, bosspatch);
    }

    public void removeBossEventOwner(UUID uuid, BossPatch bosspatch) {
        this.bossEventOwners.remove(uuid);
    }

    public void initHUD() {
        this.battleModeUI.init();
        this.versionNotifier.init();
    }

    public void freeUnusedSources() {
        this.bossEventOwners.entrySet().removeIf(entry -> {
            Object entity = ((EntityPatch)((BossPatch)entry.getValue()).cast()).getOriginal();
            return !entity.m_6084_() || entity.m_213877_();
        });
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> EpicFightRenderTypes.freeUnusedWorldRenderTypes());
        } else {
            EpicFightRenderTypes.freeUnusedWorldRenderTypes();
        }
    }

    public void clear() {
        EpicFightCameraAPI.getInstance().zoomOut(0);
        this.bossEventOwners.clear();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                this.resetRenderers();
                EpicFightRenderTypes.clearWorldRenderTypes();
            });
        } else {
            this.resetRenderers();
            EpicFightRenderTypes.clearWorldRenderTypes();
        }
    }

    public static boolean hitResultEquals(@Nullable HitResult hitResult, HitResult.Type hitType) {
        return hitResult == null ? false : hitType.equals((Object)hitResult.m_6662_());
    }

    public static boolean hitResultNotEquals(@Nullable HitResult hitResult, HitResult.Type hitType) {
        return hitResult == null ? true : !hitType.equals((Object)hitResult.m_6662_());
    }

    @Deprecated
    public void correctCamera(ViewportEvent.ComputeCameraAngles event, float partialTicks) {
        event.getCamera().m_90572_(1.0f, 1.0f);
    }

    @Deprecated
    public void setRangedWeaponThirdPerson(ViewportEvent.ComputeCameraAngles event, CameraType pov, double partialTicks) {
    }

    @Deprecated(forRemoval=true)
    public void zoomIn() {
        EpicFightCameraAPI.getInstance().zoomIn();
    }

    @Deprecated(forRemoval=true)
    public void zoomOut(int zoomOutTicks) {
        EpicFightCameraAPI.getInstance().zoomOut(zoomOutTicks);
    }

    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static RenderEngine renderEngine;
        private static final Vector3f CAMERA_ROTATION_EULER;
        private static final OpenMatrix4f PLAYER_ROTATION;
        private static final ResourceLocation GUI_ICONS;

        @SubscribeEvent
        public static void renderLivingEvent(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
            LivingEntity livingentity = event.getEntity();
            if (livingentity.m_9236_() == null) {
                return;
            }
            if (renderEngine.hasRendererFor((Entity)livingentity)) {
                LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, LivingEntityPatch.class);
                float originalYRot = 0.0f;
                if ((event.getPartialTick() == 0.0f || event.getPartialTick() == 1.0f) && entitypatch instanceof LocalPlayerPatch) {
                    LocalPlayerPatch localplayerpatch = (LocalPlayerPatch)entitypatch;
                    if (entitypatch.overrideRender()) {
                        originalYRot = localplayerpatch.getModelYRot();
                        localplayerpatch.setModelYRotInGui(livingentity.m_146908_());
                        event.getPoseStack().m_85837_(0.0, 0.1, 0.0);
                        boolean compusteShaderSetting = ClientConfig.activateComputeShader;
                        ClientConfig.activateComputeShader = false;
                        renderEngine.renderEntityArmatureModel(livingentity, entitypatch, (EntityRenderer<? extends Entity>)event.getRenderer(), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                        ClientConfig.activateComputeShader = compusteShaderSetting;
                        event.setCanceled(true);
                        localplayerpatch.disableModelYRotInGui(originalYRot);
                    }
                    return;
                }
                if (entitypatch != null && entitypatch.overrideRender()) {
                    renderEngine.renderEntityArmatureModel(livingentity, entitypatch, (EntityRenderer<? extends Entity>)event.getRenderer(), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                    if (renderEngine.shouldRenderVanillaModel()) {
                        event.getPoseStack().m_252880_(Events.renderEngine.modelInitTimer > 0 ? 10000.0f : 1.5f, 0.0f, 0.0f);
                        --Events.renderEngine.modelInitTimer;
                    } else {
                        event.setCanceled(true);
                    }
                }
            }
            if (!Events.renderEngine.minecraft.f_91066_.f_92062_ && !EpicFightGameRules.DISABLE_ENTITY_UI.getRuleValue(livingentity.m_9236_()).booleanValue()) {
                EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)Events.renderEngine.minecraft.f_91074_, LocalPlayerPatch.class).ifPresent(playerpatch -> {
                    LivingEntityPatch entityPatch = EpicFightCapabilities.getEntityPatch((Entity)livingentity, LivingEntityPatch.class);
                    for (EntityUI entityIndicator : EntityUI.ENTITY_UI_LIST) {
                        if (!entityIndicator.shouldDraw(livingentity, entityPatch, (LocalPlayerPatch)playerpatch, event.getPartialTick())) continue;
                        entityIndicator.draw(livingentity, entityPatch, (LocalPlayerPatch)playerpatch, event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick());
                    }
                });
            }
        }

        @SubscribeEvent
        public static void itemTooltip(ItemTooltipEvent event) {
            if (ClientConfig.showEpicFightAttributesInTooltip && event.getEntity() != null && event.getEntity().m_9236_().f_46443_) {
                EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), LocalPlayerPatch.class).ifPresent(playerpatch -> {
                    CapabilityItem cap = EpicFightCapabilities.getItemStackCapabilityOr(event.getItemStack(), null);
                    if (cap != null) {
                        if (InputManager.isActionPhysicallyActive(EpicFightInputAction.WEAPON_INNATE_SKILL_TOOLTIP)) {
                            Skill weaponInnateSkill = cap.getInnateSkill((PlayerPatch<?>)playerpatch, event.getItemStack());
                            if (weaponInnateSkill != null) {
                                event.getToolTip().clear();
                                List<Component> skilltooltip = weaponInnateSkill.getTooltipOnItem(event.getItemStack(), cap, (PlayerPatch<?>)playerpatch);
                                for (Component s : skilltooltip) {
                                    event.getToolTip().add(s);
                                }
                            }
                        } else {
                            List tooltip = event.getToolTip();
                            cap.modifyItemTooltip(event.getItemStack(), event.getToolTip(), (LivingEntityPatch<?>)playerpatch);
                            for (int i = 0; i < tooltip.size(); ++i) {
                                MutableComponent mutableComponent$2;
                                ComponentContents patt27462$temp;
                                Object patt27363$temp;
                                TranslatableContents translatableContent;
                                MutableComponent mutableComponent;
                                ComponentContents patt27216$temp;
                                Component sibling;
                                Component textComp = (Component)tooltip.get(i);
                                if (textComp.m_7360_().isEmpty() || !((sibling = (Component)textComp.m_7360_().get(0)) instanceof MutableComponent) || !((patt27216$temp = (mutableComponent = (MutableComponent)sibling).m_214077_()) instanceof TranslatableContents) || (translatableContent = (TranslatableContents)patt27216$temp).m_237523_().length <= 1 || !((patt27363$temp = translatableContent.m_237523_()[1]) instanceof MutableComponent) || !((patt27462$temp = (mutableComponent$2 = (MutableComponent)patt27363$temp).m_214077_()) instanceof TranslatableContents)) continue;
                                TranslatableContents translatableContent$2 = (TranslatableContents)patt27462$temp;
                                if (translatableContent$2.m_237508_().equals(Attributes.f_22283_.m_22087_())) {
                                    float weaponSpeed = (float)playerpatch.getWeaponAttribute(Attributes.f_22283_, event.getItemStack());
                                    tooltip.remove(i);
                                    tooltip.add(i, Component.m_237113_((String)String.format(" %.2f ", Float.valueOf(playerpatch.getModifiedAttackSpeed(cap, weaponSpeed)))).m_7220_((Component)Component.m_237115_((String)Attributes.f_22283_.m_22087_())));
                                    continue;
                                }
                                if (!translatableContent$2.m_237508_().equals(Attributes.f_22281_.m_22087_())) continue;
                                float weaponDamage = (float)playerpatch.getWeaponAttribute(Attributes.f_22281_, event.getItemStack());
                                float damageBonus = EnchantmentHelper.m_44833_((ItemStack)event.getItemStack(), (MobType)MobType.f_21640_);
                                String damageFormat = ItemStack.f_41584_.format(playerpatch.getModifiedBaseDamage(weaponDamage) + damageBonus);
                                tooltip.remove(i);
                                tooltip.add(i, Component.m_237113_((String)String.format(" %s ", damageFormat)).m_7220_((Component)Component.m_237115_((String)Attributes.f_22281_.m_22087_())).m_130940_(ChatFormatting.DARK_GREEN));
                            }
                            Skill weaponInnateSkill = cap.getInnateSkill((PlayerPatch<?>)playerpatch, event.getItemStack());
                            if (weaponInnateSkill != null) {
                                event.getToolTip().add(Component.m_237110_((String)"inventory.epicfight.guide_innate_tooltip", (Object[])new Object[]{EpicFightKeyMappings.WEAPON_INNATE_SKILL_TOOLTIP.getKey().m_84875_()}).m_130940_(ChatFormatting.DARK_GRAY));
                            }
                        }
                    }
                });
            }
        }

        @SubscribeEvent
        public static void cameraSetupEvent(ViewportEvent.ComputeCameraAngles event) {
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)Events.renderEngine.minecraft.f_91074_, LocalPlayerPatch.class).ifPresent(playerpatch -> {
                if (ClientConfig.enablePovAction && Events.renderEngine.minecraft.f_91066_.m_92176_().m_90612_() && playerpatch.isEpicFightMode() && !playerpatch.getFirstPersonLayer().isOff()) {
                    float partialTick = (float)event.getPartialTick();
                    EpicFightCameraAPI cameraApi = EpicFightCameraAPI.getInstance();
                    if (cameraApi.isLerpingFpv()) {
                        float xRot = cameraApi.getLerpedFpvXRot(partialTick);
                        float yRot = cameraApi.getLerpedFpvYRot(partialTick);
                        Events.renderEngine.minecraft.f_91075_.m_146926_(xRot);
                        Events.renderEngine.minecraft.f_91075_.m_146922_(yRot);
                    } else {
                        AnimationSubFileReader.PovSettings.ViewLimit viewLimit = playerpatch.getPovSettings().viewLimit();
                        if (viewLimit != null) {
                            float clampedXRot = Mth.m_14036_((float)event.getPitch(), (float)viewLimit.xRotMin(), (float)viewLimit.xRotMax());
                            float bodyY = MathUtils.findNearestRotation(event.getYaw(), playerpatch.getYRot());
                            float clampedYRot = Mth.m_14036_((float)event.getYaw(), (float)(bodyY + viewLimit.yRotMin()), (float)(bodyY + viewLimit.yRotMax()));
                            if (Float.compare(clampedXRot, event.getPitch()) != 0 || Float.compare(clampedYRot, event.getYaw()) != 0) {
                                cameraApi.fixFpvRotation(clampedXRot, playerpatch.getYRot(), 5);
                            }
                        }
                    }
                    if (playerpatch.hasCameraAnimation()) {
                        float time = Mth.m_14179_((float)partialTick, (float)playerpatch.getFirstPersonLayer().animationPlayer.getPrevElapsedTime(), (float)playerpatch.getFirstPersonLayer().animationPlayer.getElapsedTime());
                        JointTransform cameraTransform = playerpatch.getFirstPersonLayer().animationPlayer.getAnimation().get().isLinkAnimation() || playerpatch.getPovSettings() == null ? playerpatch.getFirstPersonLayer().getLinkCameraTransform().getInterpolatedTransform(time) : playerpatch.getPovSettings().cameraTransform().getInterpolatedTransform(time);
                        float xRot = ((LocalPlayer)playerpatch.getOriginal()).m_146909_();
                        float yRot = ((LocalPlayer)playerpatch.getOriginal()).m_146908_();
                        Vec3f translation = OpenMatrix4f.transform3v(OpenMatrix4f.ofRotationDegree(yRot, Vec3f.Y_AXIS, PLAYER_ROTATION).rotate(xRot, Vec3f.X_AXIS), cameraTransform.translation(), null);
                        Quaternionf rot = cameraTransform.rotation();
                        rot.getEulerAnglesXYZ(CAMERA_ROTATION_EULER);
                        Events.CAMERA_ROTATION_EULER.x = (float)Math.toDegrees(Events.CAMERA_ROTATION_EULER.x);
                        Events.CAMERA_ROTATION_EULER.y = (float)Math.toDegrees(Events.CAMERA_ROTATION_EULER.y);
                        Events.CAMERA_ROTATION_EULER.z = (float)Math.toDegrees(Events.CAMERA_ROTATION_EULER.z);
                        event.getCamera().m_90568_((double)translation.x, (double)translation.y, (double)translation.z);
                        event.setPitch(event.getPitch() + Events.CAMERA_ROTATION_EULER.x);
                        event.setYaw(event.getYaw() + Events.CAMERA_ROTATION_EULER.y);
                        event.setRoll(event.getRoll() + Events.CAMERA_ROTATION_EULER.z);
                    }
                }
            });
        }

        @SubscribeEvent
        public static void renderGui(RenderGuiEvent.Pre event) {
            Window window = Minecraft.m_91087_().m_91268_();
            LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
            if (playerpatch != null) {
                playerpatch.getSkillCapability().listSkillContainers().forEach(skillContainer -> {
                    if (skillContainer.getSkill() != null) {
                        skillContainer.getSkill().onScreen(playerpatch, window.m_85445_(), window.m_85446_());
                    }
                });
                Events.renderEngine.overlayManager.renderTick(window.m_85445_(), window.m_85446_());
                if (Minecraft.m_91404_() && !(Minecraft.m_91087_().f_91080_ instanceof UISetupScreen)) {
                    Events.renderEngine.battleModeUI.renderTick();
                }
                Events.renderEngine.versionNotifier.render(event.getGuiGraphics(), true);
            }
        }

        @SubscribeEvent(receiveCanceled=true)
        public static void renderGuiOverlay(RenderGuiOverlayEvent.Pre event) {
            if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id())) {
                CameraType cameraType = Events.renderEngine.minecraft.f_91066_.m_92176_();
                if (event.isCanceled() && cameraType.m_90612_()) {
                    return;
                }
                if (cameraType.m_90612_() || cameraType == CameraType.THIRD_PERSON_BACK && EpicFightCameraAPI.getInstance().isTPSMode()) {
                    MutableBoolean itemAction = new MutableBoolean(true);
                    if (ClientConfig.mineBlockGuideOption.switchCrosshair()) {
                        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)Events.renderEngine.minecraft.f_91074_, LocalPlayerPatch.class).ifPresent(playerpatch -> itemAction.setValue(playerpatch.canPlayAttackAnimation() || playerpatch.isVanillaMode()));
                    }
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    if (itemAction.booleanValue()) {
                        event.getGuiGraphics().m_280218_(GUI_ICONS, (event.getGuiGraphics().m_280182_() - 15) / 2, (event.getGuiGraphics().m_280206_() - 15) / 2, 0, 0, 15, 15);
                    } else {
                        event.getGuiGraphics().m_280218_(EntityUI.BATTLE_ICON, (event.getGuiGraphics().m_280182_() - 15) / 2, (event.getGuiGraphics().m_280206_() - 15) / 2, 0, 240, 15, 15);
                    }
                    RenderSystem.defaultBlendFunc();
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void renderGameOverlayPost(CustomizeGuiOverlayEvent.BossEventProgress event) {
            Object entitypatch;
            float stunShield;
            if (event.getBossEvent().m_18861_().getString().equals("Ender Dragon") && Events.renderEngine.bossEventOwners.containsKey(event.getBossEvent().m_18860_()) && (stunShield = ((LivingEntityPatch)(entitypatch = Events.renderEngine.bossEventOwners.get(event.getBossEvent().m_18860_()).cast())).getStunShield()) > 0.0f) {
                float progression = stunShield / ((LivingEntityPatch)entitypatch).getMaxStunShield();
                int x = event.getX();
                int y = event.getY();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                event.getGuiGraphics().m_280411_(BossHealthOverlay.f_93697_, x, y + 6, 183, 2, 0.0f, 45.0f, 182, 6, 255, 255);
                event.getGuiGraphics().m_280411_(BossHealthOverlay.f_93697_, x + (int)(183.0f * progression), y + 6, (int)(183.0f * (1.0f - progression)), 2, 0.0f, 39.0f, 182, 6, 255, 255);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void renderHand(RenderHandEvent event) {
            boolean isBattleMode;
            LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
            if (playerpatch != null && (isBattleMode = playerpatch.isEpicFightMode()) && ClientConfig.enableAnimatedFirstPersonModel) {
                boolean useEpicFightModel;
                RenderItemBase mainhandItemSkin = renderEngine.getItemRenderer(((LocalPlayer)playerpatch.getOriginal()).m_21205_());
                RenderItemBase offhandItemSkin = renderEngine.getItemRenderer(((LocalPlayer)playerpatch.getOriginal()).m_21206_());
                boolean bl = useEpicFightModel = !(mainhandItemSkin != null && mainhandItemSkin.forceVanillaFirstPerson() || offhandItemSkin != null && offhandItemSkin.forceVanillaFirstPerson());
                if (useEpicFightModel) {
                    if (event.getHand() == InteractionHand.MAIN_HAND) {
                        Events.renderEngine.firstPersonRenderer.render((LocalPlayer)playerpatch.getOriginal(), playerpatch, (LivingEntityRenderer<LocalPlayer, PlayerModel<LocalPlayer>>)((LivingEntityRenderer)Events.renderEngine.minecraft.m_91290_().m_114382_((Entity)((LocalPlayer)playerpatch.getOriginal()))), event.getMultiBufferSource(), event.getPoseStack(), event.getPackedLight(), event.getPartialTick());
                    }
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void renderWorldLast(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS && ClientConfig.mineBlockGuideOption.showBlockHighlight() && RenderEngine.hitResultEquals(Events.renderEngine.minecraft.f_91077_, HitResult.Type.BLOCK)) {
                EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)Events.renderEngine.minecraft.f_91074_, LocalPlayerPatch.class).ifPresent(playerpatch -> {
                    if (!playerpatch.canPlayAttackAnimation() && playerpatch.isEpicFightMode()) {
                        Events.renderEngine.fakeBlockRenderer.render(event.getCamera(), event.getPoseStack(), (MultiBufferSource)Events.renderEngine.minecraft.m_91269_().m_110104_(), (Level)Events.renderEngine.minecraft.f_91073_, ((BlockHitResult)Events.renderEngine.minecraft.f_91077_).m_82425_(), 1.0f, 1.0f, 1.0f, 0.4f);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void renderEnderDragonEvent(RenderEnderDragonEvent event) {
            EnderDragon livingentity = event.getEntity();
            if (renderEngine.hasRendererFor((Entity)livingentity)) {
                EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)livingentity, EnderDragonPatch.class).ifPresent(enderdragonpatch -> {
                    event.setCanceled(true);
                    renderEngine.getEntityRenderer((Entity)livingentity).render(livingentity, enderdragonpatch, event.getRenderer(), event.getBuffers(), event.getPoseStack(), event.getLight(), event.getPartialRenderTick());
                });
            }
        }

        @SubscribeEvent
        public static void renderBlockHighlight(RenderHighlightEvent.Block event) {
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)Events.renderEngine.minecraft.f_91074_, LocalPlayerPatch.class).ifPresent(playerpatch -> {
                if (playerpatch.canPlayAttackAnimation()) {
                    event.setCanceled(true);
                }
            });
        }

        @SubscribeEvent
        public static void renderTickEvent(TickEvent.RenderTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                EntityUI.HEALTH_BAR.reset();
            } else {
                EntityUI.HEALTH_BAR.remove();
            }
        }

        @SubscribeEvent
        public static void clientTickEvent(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                renderEngine.freeUnusedSources();
                EpicFightCameraAPI.getInstance().preClientTick();
            } else {
                EpicFightCameraAPI.getInstance().postClientTick();
            }
        }

        @SubscribeEvent
        public static void rightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
            if (event.getSide() != LogicalSide.CLIENT) {
                return;
            }
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)Events.renderEngine.minecraft.f_91074_, LocalPlayerPatch.class).ifPresent(playerpatch -> {
                Vec3 toHit = event.getHitVec().m_82450_().m_82546_(((LocalPlayer)playerpatch.getOriginal()).m_146892_());
                ((LocalPlayer)playerpatch.getOriginal()).m_146926_((float)MathUtils.getXRotOfVector(toHit));
                ((LocalPlayer)playerpatch.getOriginal()).m_146922_((float)MathUtils.getYRotOfVector(toHit));
            });
        }

        @SubscribeEvent
        public static void levelTickEvent(TickEvent.LevelTickEvent event) {
            if (event.level.m_5776_() && event.phase == TickEvent.Phase.END) {
                EntityUI.HEALTH_BAR.tick();
            }
        }

        static {
            CAMERA_ROTATION_EULER = new Vector3f();
            PLAYER_ROTATION = new OpenMatrix4f();
            GUI_ICONS = ResourceLocation.withDefaultNamespace((String)"textures/gui/icons.png");
        }
    }
}

