/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPModifySkillData;
import yesman.epicfight.network.server.SPModifySkillData;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;

public class SkillDataManager {
    private final Map<SkillDataKey<?>, Object> data = Maps.newHashMap();
    private final SkillContainer container;

    public SkillDataManager(SkillContainer container) {
        this.container = container;
    }

    public <T> void registerData(SkillDataKey<T> key) {
        if (this.hasData(key)) {
            throw new IllegalStateException(key + " is already registered!");
        }
        this.data.put(key, key.defaultValue());
    }

    public void transferDataTo(SkillDataManager dest) {
        dest.data.putAll(this.data);
    }

    public <T> void removeData(SkillDataKey<T> key) {
        this.data.remove(key);
    }

    public Set<SkillDataKey<?>> keySet() {
        return this.data.keySet();
    }

    @Deprecated
    public void setDataRawtype(SkillDataKey<?> key, Object data) {
        if (!this.data.containsKey(key)) {
            throw new IllegalStateException(key + " is unregistered.");
        }
        this.data.put(key, data);
    }

    public <T> void setData(SkillDataKey<T> key, T data) {
        this.setDataRawtype(key, data);
    }

    public <T> void setDataF(SkillDataKey<T> key, Function<T, T> dataManipulator) {
        this.setDataRawtype(key, dataManipulator.apply(this.getDataValue(key)));
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    public <T> void setDataSync(SkillDataKey<T> key, T data, ServerPlayer player) {
        this.setData(key, data);
        this.syncServerPlayerData(key, player);
    }

    public <T> void setDataSync(SkillDataKey<T> key, T data) {
        this.setData(key, data);
        if (!this.container.getExecutor().isLogicalClient()) {
            this.syncServerPlayerData(key, (ServerPlayer)this.container.getServerExecutor().getOriginal());
        } else {
            this.syncLocalPlayerData(key, (LocalPlayer)this.container.getClientExecutor().getOriginal());
        }
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    public <T> void setDataSyncF(SkillDataKey<T> key, Function<T, T> dataManipulator, ServerPlayer serverplayer) {
        this.setDataF(key, dataManipulator);
        this.syncServerPlayerData(key, serverplayer);
    }

    public <T> void setDataSyncF(SkillDataKey<T> key, Function<T, T> dataManipulator) {
        this.setDataF(key, dataManipulator);
        if (!this.container.getExecutor().isLogicalClient()) {
            this.syncServerPlayerData(key, (ServerPlayer)this.container.getServerExecutor().getOriginal());
        } else {
            this.syncLocalPlayerData(key, (LocalPlayer)this.container.getClientExecutor().getOriginal());
        }
    }

    private <T> void syncServerPlayerData(SkillDataKey<T> key, ServerPlayer serverplayer) {
        SPModifySkillData msg = new SPModifySkillData(key, this.container.getSlot(), this.getDataValue(key), serverplayer.m_19879_());
        EpicFightNetworkManager.sendToPlayer(msg, serverplayer, new Object[0]);
        if (key.syncronizeToTrackingPlayers()) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)serverplayer, new Object[0]);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private <T> void syncLocalPlayerData(SkillDataKey<T> key, LocalPlayer player) {
        CPModifySkillData msg = new CPModifySkillData(key, this.container.getSlot(), this.getDataValue(key));
        EpicFightNetworkManager.sendToServer(msg);
    }

    public void onTracked(EpicFightNetworkManager.PayloadBundleBuilder bundleBuilder) {
        this.data.forEach((key, val) -> {
            if (key.syncronizeToTrackingPlayers()) {
                bundleBuilder.and(new SPModifySkillData((SkillDataKey<?>)key, this.container.getSlot(), val, ((Player)this.container.executor.getOriginal()).m_19879_()));
            }
        });
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    @OnlyIn(value=Dist.CLIENT)
    public <T> void setDataSync(SkillDataKey<T> key, T data, LocalPlayer player) {
        this.setData(key, data);
        this.syncLocalPlayerData(key, player);
    }

    public <T> T getDataValue(SkillDataKey<T> key) {
        return (T)this.data.get(key);
    }

    public <T> Optional<T> getDataValueOptional(SkillDataKey<T> key) {
        return Optional.ofNullable(this.data.get(key));
    }

    public boolean hasData(SkillDataKey<?> key) {
        return this.data.containsKey(key);
    }

    public void clearData() {
        this.data.clear();
    }
}

