/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.api;

import homeostaticseasons.api.Hemisphere;
import homeostaticseasons.api.Season;
import homeostaticseasons.api.SeasonChangeMethod;
import homeostaticseasons.config.ConfigHandler;
import java.time.Duration;
import java.time.LocalDateTime;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

public class HomeostaticSeasonsAPI {
    public static Season getCurrentSeason(class_1937 level) {
        if (HomeostaticSeasonsAPI.isSeasonalDimension((class_5321<class_1937>)level.method_27983())) {
            if (ConfigHandler.Common.seasonChangeMethod() == SeasonChangeMethod.REALTIME) {
                return HomeostaticSeasonsAPI.getRealtimeSeason();
            }
            if (ConfigHandler.Common.seasonChangeMethod() == SeasonChangeMethod.FIXED) {
                return ConfigHandler.Common.fixedSeason();
            }
            return ConfigHandler.Common.getSeasonFromDayTime(level.method_8532());
        }
        return null;
    }

    public static Season getNextSeason(class_1937 level, Season currentSeason) {
        if (HomeostaticSeasonsAPI.isSeasonalDimension((class_5321<class_1937>)level.method_27983())) {
            return currentSeason.next();
        }
        return null;
    }

    public static long getSeasonTime(class_1937 level, Season season) {
        if (ConfigHandler.Common.seasonChangeMethod() == SeasonChangeMethod.CONFIGURED && HomeostaticSeasonsAPI.isSeasonalDimension((class_5321<class_1937>)level.method_27983())) {
            return ConfigHandler.Common.getSeasonTime(season);
        }
        return -1L;
    }

    public static long getTimeUntilNextSeason(class_1937 level) {
        if (HomeostaticSeasonsAPI.isSeasonalDimension((class_5321<class_1937>)level.method_27983())) {
            if (ConfigHandler.Common.seasonChangeMethod() == SeasonChangeMethod.REALTIME) {
                return HomeostaticSeasonsAPI.getRealtimeUntilNextSeason();
            }
            if (ConfigHandler.Common.seasonChangeMethod() == SeasonChangeMethod.CONFIGURED) {
                return ConfigHandler.Common.getTimeUntilNextSeason(level.method_8532());
            }
        }
        return 0L;
    }

    public static long getTimeUntilSeason(class_1937 level, Season season) {
        if (ConfigHandler.Common.seasonChangeMethod() == SeasonChangeMethod.CONFIGURED && HomeostaticSeasonsAPI.isSeasonalDimension((class_5321<class_1937>)level.method_27983())) {
            return ConfigHandler.Common.getTimeUntilSeason(level.method_8532(), season);
        }
        return -1L;
    }

    private static long getRealtimeUntilNextSeason() {
        LocalDateTime nextSeasonDate;
        LocalDateTime date = LocalDateTime.now();
        Season cuurrentSeason = HomeostaticSeasonsAPI.getRealtimeSeason();
        if (ConfigHandler.Common.hemisphere() == Hemisphere.NORTHERN) {
            nextSeasonDate = switch (cuurrentSeason) {
                default -> throw new MatchException(null, null);
                case Season.EARLY_SPRING -> LocalDateTime.of(date.getYear(), 4, 20, 0, 0);
                case Season.MID_SPRING -> LocalDateTime.of(date.getYear(), 5, 21, 0, 0);
                case Season.LATE_SPRING -> LocalDateTime.of(date.getYear(), 6, 21, 0, 0);
                case Season.EARLY_SUMMER -> LocalDateTime.of(date.getYear(), 7, 23, 0, 0);
                case Season.MID_SUMMER -> LocalDateTime.of(date.getYear(), 8, 23, 0, 0);
                case Season.LATE_SUMMER -> LocalDateTime.of(date.getYear(), 9, 23, 0, 0);
                case Season.EARLY_AUTUMN -> LocalDateTime.of(date.getYear(), 10, 23, 0, 0);
                case Season.MID_AUTUMN -> LocalDateTime.of(date.getYear(), 11, 22, 0, 0);
                case Season.LATE_AUTUMN -> LocalDateTime.of(date.getYear(), 12, 21, 0, 0);
                case Season.EARLY_WINTER -> LocalDateTime.of(date.getYear() + 1, 1, 20, 0, 0);
                case Season.MID_WINTER -> LocalDateTime.of(date.getYear() + 1, 2, 19, 0, 0);
                case Season.LATE_WINTER -> LocalDateTime.of(date.getYear(), 3, 21, 0, 0);
            };
        } else {
            nextSeasonDate = switch (cuurrentSeason) {
                default -> throw new MatchException(null, null);
                case Season.EARLY_SPRING -> LocalDateTime.of(date.getYear(), 10, 23, 0, 0);
                case Season.MID_SPRING -> LocalDateTime.of(date.getYear(), 11, 22, 0, 0);
                case Season.LATE_SPRING -> LocalDateTime.of(date.getYear(), 12, 21, 0, 0);
                case Season.EARLY_SUMMER -> LocalDateTime.of(date.getYear() + 1, 1, 20, 0, 0);
                case Season.MID_SUMMER -> LocalDateTime.of(date.getYear() + 1, 2, 19, 0, 0);
                case Season.LATE_SUMMER -> LocalDateTime.of(date.getYear(), 3, 21, 0, 0);
                case Season.EARLY_AUTUMN -> LocalDateTime.of(date.getYear(), 4, 20, 0, 0);
                case Season.MID_AUTUMN -> LocalDateTime.of(date.getYear(), 5, 21, 0, 0);
                case Season.LATE_AUTUMN -> LocalDateTime.of(date.getYear(), 6, 21, 0, 0);
                case Season.EARLY_WINTER -> LocalDateTime.of(date.getYear(), 7, 23, 0, 0);
                case Season.MID_WINTER -> LocalDateTime.of(date.getYear(), 8, 23, 0, 0);
                case Season.LATE_WINTER -> LocalDateTime.of(date.getYear(), 9, 23, 0, 0);
            };
        }
        Duration duration = Duration.between(date, nextSeasonDate);
        return duration.toDays() * 24000L;
    }

    private static Season getRealtimeSeason() {
        LocalDateTime date = LocalDateTime.now();
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        if (ConfigHandler.Common.hemisphere() == Hemisphere.NORTHERN) {
            if (month == 3 && day >= 21 || month == 4 && day <= 19) {
                return Season.EARLY_SPRING;
            }
            if (month == 4 || month == 5 && day <= 20) {
                return Season.MID_SPRING;
            }
            if (month == 5 || month == 6 && day <= 20) {
                return Season.LATE_SPRING;
            }
            if (month == 6 || month == 7 && day <= 22) {
                return Season.EARLY_SUMMER;
            }
            if (month == 7 || month == 8 && day <= 22) {
                return Season.MID_SUMMER;
            }
            if (month == 8 || month == 9 && day <= 22) {
                return Season.LATE_SUMMER;
            }
            if (month == 9 || month == 10 && day <= 22) {
                return Season.EARLY_AUTUMN;
            }
            if (month == 10 || month == 11 && day <= 21) {
                return Season.MID_AUTUMN;
            }
            if (month == 11 || month == 12 && day <= 20) {
                return Season.LATE_AUTUMN;
            }
            if (month == 12 || month == 1 && day <= 19) {
                return Season.EARLY_WINTER;
            }
            if (month == 1 || month == 2 && day <= 18) {
                return Season.MID_WINTER;
            }
            return Season.LATE_WINTER;
        }
        if (month == 9 && day >= 23 || month == 10 && day <= 22) {
            return Season.EARLY_SPRING;
        }
        if (month == 10 || month == 11 && day <= 21) {
            return Season.MID_SPRING;
        }
        if (month == 11 || month == 12 && day <= 20) {
            return Season.LATE_SPRING;
        }
        if (month == 12 || month == 1 && day <= 19) {
            return Season.EARLY_SUMMER;
        }
        if (month == 1 || month == 2 && day <= 18) {
            return Season.MID_SUMMER;
        }
        if (month == 2 || month == 3 && day <= 20) {
            return Season.LATE_SUMMER;
        }
        if (month == 3 || month == 4 && day <= 19) {
            return Season.EARLY_AUTUMN;
        }
        if (month == 4 || month == 5 && day <= 20) {
            return Season.MID_AUTUMN;
        }
        if (month == 5 || month == 6 && day <= 20) {
            return Season.LATE_AUTUMN;
        }
        if (month == 6 || month == 7 && day <= 22) {
            return Season.EARLY_WINTER;
        }
        if (month == 7 || month == 8 && day <= 22) {
            return Season.MID_WINTER;
        }
        return Season.LATE_WINTER;
    }

    public static boolean isSeasonalDimension(class_5321<class_1937> dimension) {
        return ConfigHandler.Common.isValidDimension(dimension);
    }
}

