/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.api;

import homeostaticseasons.api.Hemisphere;
import homeostaticseasons.api.SeasonChangeMethod;
import homeostaticseasons.config.ConfigHandler;
import java.util.Locale;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;

public enum Season implements class_3542
{
    EARLY_SPRING,
    MID_SPRING,
    LATE_SPRING,
    EARLY_SUMMER,
    MID_SUMMER,
    LATE_SUMMER,
    EARLY_AUTUMN,
    MID_AUTUMN,
    LATE_AUTUMN,
    EARLY_WINTER,
    MID_WINTER,
    LATE_WINTER;


    @NotNull
    public String method_15434() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getTranslationKey() {
        return "homeostaticseasons.season." + this.method_15434();
    }

    public long getSeasonLength() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ConfigHandler.Common.earlySpringDaysLength();
            case 1 -> ConfigHandler.Common.midSpringDaysLength();
            case 2 -> ConfigHandler.Common.lateSpringDaysLength();
            case 3 -> ConfigHandler.Common.earlySummerDaysLength();
            case 4 -> ConfigHandler.Common.midSummerDaysLength();
            case 5 -> ConfigHandler.Common.lateSummerDaysLength();
            case 6 -> ConfigHandler.Common.earlyAutumnDaysLength();
            case 7 -> ConfigHandler.Common.midAutumnDaysLength();
            case 8 -> ConfigHandler.Common.lateAutumnDaysLength();
            case 9 -> ConfigHandler.Common.earlyWinterDaysLength();
            case 10 -> ConfigHandler.Common.midWinterDaysLength();
            case 11 -> ConfigHandler.Common.lateWinterDaysLength();
        };
    }

    public String getHumanReadableName() {
        String name = this.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        String[] words = name.split(" ");
        StringBuilder humanReadableName = new StringBuilder();
        for (String word : words) {
            humanReadableName.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return humanReadableName.toString().trim();
    }

    public Season next() {
        return Season.values()[(this.ordinal() + 1) % Season.values().length];
    }

    public boolean isWetSeason() {
        if (ConfigHandler.Common.seasonChangeMethod() == SeasonChangeMethod.REALTIME) {
            if (ConfigHandler.Common.hemisphere() == Hemisphere.NORTHERN) {
                return this.ordinal() > 6;
            }
            return this.ordinal() < 7 && this.ordinal() > 1;
        }
        return this.ordinal() > 6;
    }
}

