/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.api;

import homeostaticseasons.api.HomeostaticSeasonsAPI;
import homeostaticseasons.common.biome.BiomeTemperature;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class SeasonWeather {
    private static final ThreadLocal<Long2FloatLinkedOpenHashMap> temperatureCache = ThreadLocal.withInitial(() -> (Long2FloatLinkedOpenHashMap)class_156.method_656(() -> {
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(2048, 0.25f){

            protected void rehash(int newSize) {
            }
        };
        long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
        return long2floatlinkedopenhashmap;
    }));
    private static final ThreadLocal<Long2IntLinkedOpenHashMap> precipitationCache = ThreadLocal.withInitial(() -> (Long2IntLinkedOpenHashMap)class_156.method_656(() -> {
        Long2IntLinkedOpenHashMap long2intlinkedopenhashmap = new Long2IntLinkedOpenHashMap(2048, 0.25f){

            protected void rehash(int newSize) {
            }
        };
        long2intlinkedopenhashmap.defaultReturnValue(-1);
        return long2intlinkedopenhashmap;
    }));

    public static boolean warmEnoughToRain(class_1959 biome, class_2338 pos, class_4538 levelReader) {
        class_1937 level;
        if (levelReader instanceof class_1937 && SeasonWeather.isValid(level = (class_1937)levelReader)) {
            return SeasonWeather.warmEnoughToRain(biome, pos, level);
        }
        return biome.method_39927(pos);
    }

    public static boolean warmEnoughToRain(class_1959 biome, class_2338 pos, class_1937 level) {
        BiomeTemperature biomeTemperature = SeasonWeather.getBiomeTemperature(biome, level, pos);
        return biomeTemperature.isWarmEnoughToRain();
    }

    public static boolean canSnow(class_1959 biome, class_2338 pos, class_4538 levelReader) {
        class_1937 level;
        if (levelReader instanceof class_1937 && SeasonWeather.isValid(level = (class_1937)levelReader)) {
            class_1959.class_1963 precipitation = SeasonWeather.getPrecipitationType(biome, pos, level);
            return precipitation == class_1959.class_1963.field_9383;
        }
        return !biome.method_39927(pos);
    }

    public static boolean canSnow(class_1959 biome, class_2338 pos, class_3218 serverLevel) {
        if (SeasonWeather.isValid((class_1937)serverLevel)) {
            class_1959.class_1963 precipitation = SeasonWeather.getPrecipitationType(biome, pos, serverLevel);
            return precipitation == class_1959.class_1963.field_9383;
        }
        return !biome.method_39927(pos);
    }

    public static boolean canPlaceSnow(class_2338 pos, class_4538 level, boolean canSnow) {
        class_2680 blockstate;
        return canSnow && pos.method_10264() >= level.method_31607() && pos.method_10264() < level.method_31600() && level.method_8314(class_1944.field_9282, pos) < 10 && ((blockstate = level.method_8320(pos)).method_26215() || blockstate.method_27852(class_2246.field_10477)) && class_2246.field_10477.method_9564().method_26184(level, pos);
    }

    public static boolean canPlaceSnow(class_1959 biome, class_2338 pos, class_3218 level) {
        return SeasonWeather.canPlaceSnow(pos, (class_4538)level, SeasonWeather.canSnow(biome, pos, level));
    }

    public static boolean canPlaceSnow(class_1959 biome, class_2338 pos, class_4538 level) {
        return SeasonWeather.canPlaceSnow(pos, level, SeasonWeather.canSnow(biome, pos, level));
    }

    public static boolean isRainingAt(class_1937 level, class_2338 pos) {
        if (!level.method_8419()) {
            return false;
        }
        if (level.method_8598(class_2902.class_2903.field_13197, pos).method_10264() > pos.method_10264()) {
            return false;
        }
        class_6880 biome = level.method_23753(pos);
        if (SeasonWeather.isValid(level)) {
            BiomeTemperature biomeTemperature = SeasonWeather.getBiomeTemperature((class_1959)biome.comp_349(), level, pos);
            return biomeTemperature.getPrecipitationType() == class_1959.class_1963.field_9382 && biomeTemperature.isWarmEnoughToRain();
        }
        return BiomeTemperature.getPrecipitationAt((class_1959)biome.comp_349(), pos) == class_1959.class_1963.field_9382;
    }

    public static class_1959.class_1963 getPrecipitationType(class_1959 biome, class_2338 pos, class_3218 level) {
        return SeasonWeather.getPrecipitationType(biome, pos, (class_1937)level);
    }

    public static class_1959.class_1963 getPrecipitationType(class_1959 biome, class_2338 pos, class_1937 level) {
        if (!SeasonWeather.isValid(level)) {
            return biome.method_48162(pos);
        }
        long i = pos.method_10063();
        Long2IntLinkedOpenHashMap long2intlinkedopenhashmap = precipitationCache.get();
        int j = long2intlinkedopenhashmap.get(i);
        if (j != -1) {
            return class_1959.class_1963.values()[j];
        }
        BiomeTemperature biomeTemperature = SeasonWeather.getBiomeTemperature(biome, level, pos);
        class_1959.class_1963 precipitation = biomeTemperature.getPrecipitationType();
        if (long2intlinkedopenhashmap.size() == 2048) {
            long2intlinkedopenhashmap.removeFirstInt();
        }
        long2intlinkedopenhashmap.put(i, precipitation.ordinal());
        return precipitation;
    }

    public static class_1959.class_1963 getPrecipitationType(class_2338 pos, class_1937 level) {
        if (!SeasonWeather.isValid(level)) {
            return null;
        }
        class_6880 biomeHolder = level.method_23753(pos);
        BiomeTemperature biomeTemperature = SeasonWeather.getBiomeTemperature((class_1959)biomeHolder.comp_349(), level, pos);
        return biomeTemperature.getPrecipitationType();
    }

    public static boolean isValid(class_1937 level) {
        return HomeostaticSeasonsAPI.isSeasonalDimension((class_5321<class_1937>)level.method_27983());
    }

    public static BiomeTemperature getBiomeTemperature(class_1959 biome, class_1937 level, class_2338 pos) {
        long i = pos.method_10063();
        Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = temperatureCache.get();
        float f = long2floatlinkedopenhashmap.get(i);
        if (!Float.isNaN(f)) {
            return new BiomeTemperature(biome, level, pos, f);
        }
        BiomeTemperature biomeTemperature = new BiomeTemperature(biome, level, pos, Float.NaN);
        float f1 = biomeTemperature.getAirTemperature();
        if (long2floatlinkedopenhashmap.size() == 2048) {
            long2floatlinkedopenhashmap.removeFirstFloat();
        }
        long2floatlinkedopenhashmap.put(i, f1);
        return biomeTemperature;
    }
}

