/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import homeostaticseasons.api.HomeostaticSeasonsAPI;
import homeostaticseasons.api.Season;
import homeostaticseasons.api.SeasonChangeMethod;
import homeostaticseasons.config.ConfigHandler;
import homeostaticseasons.platform.Services;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5268;
import net.minecraft.class_5321;

public class SeasonCommand {
    private static final SuggestionProvider<class_2168> SUGGEST_SEASONS = (ctx, builder) -> {
        for (Season season : Season.values()) {
            builder.suggest(season.name());
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"season").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(cs -> SeasonCommand.isConfigured() && cs.method_9259(2))).then(class_2170.method_9244((String)"season", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_SEASONS).executes(ctx -> SeasonCommand.setSeasonTime((class_2168)ctx.getSource(), Season.valueOf(StringArgumentType.getString((CommandContext)ctx, (String)"season"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"skip").requires(cs -> SeasonCommand.isConfigured() && cs.method_9259(2))).then(class_2170.method_9244((String)"season", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_SEASONS).executes(ctx -> SeasonCommand.skipToSeason((class_2168)ctx.getSource(), Season.valueOf(StringArgumentType.getString((CommandContext)ctx, (String)"season"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"query").requires(SeasonCommand::isValidDimension)).executes(ctx -> {
            class_3218 level = ((class_2168)ctx.getSource()).method_9225();
            Season currentSeason = HomeostaticSeasonsAPI.getCurrentSeason((class_1937)level);
            long ticksUntilNextSeason = HomeostaticSeasonsAPI.getTimeUntilNextSeason((class_1937)level);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"homeostaticseasons.command.query_season", (Object[])new Object[]{class_2561.method_43471((String)currentSeason.getTranslationKey())}), false);
            if (ConfigHandler.Common.seasonChangeMethod() != SeasonChangeMethod.FIXED) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"homeostaticseasons.command.query_next_season", (Object[])new Object[]{String.format("%.1f", (double)ticksUntilNextSeason / 24000.0), Long.toString(ticksUntilNextSeason), class_2561.method_43471((String)HomeostaticSeasonsAPI.getNextSeason((class_1937)level, currentSeason).getTranslationKey())}), false);
            }
            return currentSeason.ordinal();
        })));
    }

    private static int setSeasonTime(class_2168 source, Season season) {
        for (class_3218 serverlevel : source.method_9211().method_3738()) {
            class_5268 levelData = Services.PLATFORM.getServerLevelData(serverlevel);
            long time = HomeostaticSeasonsAPI.getSeasonTime((class_1937)serverlevel, season);
            if (time == -1L) continue;
            levelData.method_29035(time);
            source.method_9226(() -> class_2561.method_43469((String)"commands.time.set", (Object[])new Object[]{time}), true);
        }
        return (int)source.method_9225().method_8532();
    }

    private static int skipToSeason(class_2168 source, Season season) {
        long currentTime = source.method_9225().method_8532();
        for (class_3218 serverlevel : source.method_9211().method_3738()) {
            class_5268 levelData = Services.PLATFORM.getServerLevelData(serverlevel);
            long timeUntilSeason = HomeostaticSeasonsAPI.getTimeUntilSeason((class_1937)serverlevel, season);
            if (timeUntilSeason == -1L) continue;
            long newTime = currentTime + timeUntilSeason;
            levelData.method_29035(newTime);
            source.method_9226(() -> class_2561.method_43469((String)"commands.time.set", (Object[])new Object[]{newTime}), true);
        }
        return (int)(source.method_9225().method_8532() % 24000L);
    }

    private static boolean isConfigured() {
        return ConfigHandler.Common.seasonChangeMethod() == SeasonChangeMethod.CONFIGURED;
    }

    private static boolean isValidDimension(class_2168 source) {
        return ConfigHandler.Common.isValidDimension((class_5321<class_1937>)source.method_9225().method_27983());
    }
}

