/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.common.biome;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import homeostaticseasons.util.ColorHelper;
import java.lang.reflect.Type;
import java.util.Locale;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import technology.roughness.whitenoise.util.ResourceLocationHelper;

public record BiomeColormap(class_2960 type, int grassColor, float grassSaturation, int foliageColor, float foliageSaturation, int birchColor) {
    public static final Codec<BiomeColormap> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("type").forGetter(BiomeColormap::type), (App)Codec.INT.fieldOf("grass_color").forGetter(BiomeColormap::grassColor), (App)Codec.FLOAT.fieldOf("grass_saturation").forGetter(BiomeColormap::grassSaturation), (App)Codec.INT.fieldOf("foliage_color").forGetter(BiomeColormap::foliageColor), (App)Codec.FLOAT.fieldOf("foliage_saturation").forGetter(BiomeColormap::foliageSaturation), (App)Codec.INT.fieldOf("birch_color").forGetter(BiomeColormap::birchColor)).apply((Applicative)instance, BiomeColormap::new));

    public BiomeColormap(class_2960 type, int grassColor, int foliageColor, int birchColor) {
        this(type, grassColor, -1.0f, foliageColor, -1.0f, birchColor);
    }

    public int getGrassColor(int originalColor, class_6880<class_1959> biomeHolder) {
        return this.getColor(originalColor, this.grassColor, this.grassSaturation, biomeHolder);
    }

    public int getFoliageColor(int originalColor, class_6880<class_1959> biomeHolder) {
        return this.getColor(originalColor, this.foliageColor, this.foliageSaturation, biomeHolder);
    }

    public int getBirchColor(int originalColor, class_6880<class_1959> biomeHolder) {
        return this.getColor(originalColor, this.birchColor, -1.0f, biomeHolder);
    }

    private int getColor(int originalColor, int newColor, float saturation, class_6880<class_1959> biomeHolder) {
        int color;
        int mutedColor = color = newColor == 0xFFFFFF ? originalColor : ColorHelper.blend(originalColor, newColor);
        boolean muted = false;
        if (muted) {
            mutedColor = ColorHelper.mix(color, originalColor, 0.75f);
        }
        return saturation != -1.0f ? ColorHelper.saturate(mutedColor, saturation) : mutedColor;
    }

    @Override
    @NotNull
    public String toString() {
        return "BiomeColormap{grassColor=" + this.grassColor + ", grassSaturation=" + this.grassSaturation + ", foliageColor=" + this.foliageColor + ", foliageSaturation=" + this.foliageSaturation + ", birchColor=" + this.birchColor + "}";
    }

    public static enum ColormapType {
        NORMAL,
        TEMPERATE;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Serializer
    implements JsonDeserializer<BiomeColormap>,
    JsonSerializer<BiomeColormap> {
        public BiomeColormap deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"data");
            return new BiomeColormap(ResourceLocationHelper.parse((String)class_3518.method_15265((JsonObject)json, (String)"type")), class_3518.method_15260((JsonObject)json, (String)"grass_color"), class_3518.method_15259((JsonObject)json, (String)"grass_saturation"), class_3518.method_15260((JsonObject)json, (String)"foliage_color"), class_3518.method_15259((JsonObject)json, (String)"foliage_saturation"), class_3518.method_15260((JsonObject)json, (String)"birch_color"));
        }

        public JsonElement serialize(BiomeColormap biomeColormap, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("type", biomeColormap.type.toString());
            json.addProperty("grass_color", (Number)biomeColormap.grassColor);
            json.addProperty("grass_saturation", (Number)Float.valueOf(biomeColormap.grassSaturation));
            json.addProperty("foliage_color", (Number)biomeColormap.foliageColor);
            json.addProperty("foliage_saturation", (Number)Float.valueOf(biomeColormap.foliageSaturation));
            json.addProperty("birch_color", (Number)biomeColormap.birchColor);
            return json;
        }
    }
}

