/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.common.biome;

import climatesettings.ClimateSettings;
import climatesettings.common.biome.BiomeCategory;
import climatesettings.common.biome.BiomeCategoryManager;
import climatesettings.network.IPacket;
import climatesettings.platform.Services;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import homeostaticseasons.HomeostaticSeasons;
import homeostaticseasons.api.Season;
import homeostaticseasons.common.biome.BiomeColormap;
import homeostaticseasons.network.SyncBiomeColormap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class BiomeColormapManager
extends class_4309 {
    private static final Map<class_2960, BiomeColormap> COLORMAPS = new HashMap<class_2960, BiomeColormap>();
    private static final Map<class_2960, BiomeColormap.ColormapType> BIOMETYPE_TO_COLORMAPTYPE = new HashMap<class_2960, BiomeColormap.ColormapType>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(BiomeColormap.class, (Object)new BiomeColormap.Serializer()).create();

    public BiomeColormapManager() {
        super(GSON, "biome/colormaps");
        block3: for (BiomeCategory.Type type : BiomeCategory.Type.values()) {
            switch (type) {
                case BOG: 
                case COLD_DESERT: 
                case DESERT: 
                case DRYLAND: 
                case LUSH_DESERT: 
                case MESA: 
                case MUSHROOM: 
                case RAINFOREST: 
                case SAVANNA: 
                case SWAMP: 
                case VOLCANIC: 
                case WARM_OCEAN: {
                    BIOMETYPE_TO_COLORMAPTYPE.put(ClimateSettings.prefix((String)type.toString()), BiomeColormap.ColormapType.TEMPERATE);
                    continue block3;
                }
                default: {
                    BIOMETYPE_TO_COLORMAPTYPE.put(ClimateSettings.prefix((String)type.toString()), BiomeColormap.ColormapType.NORMAL);
                }
            }
        }
    }

    private static class_2960 getSerializedName(BiomeColormap.ColormapType type, Season season) {
        return HomeostaticSeasons.prefix(season.method_15434() + "_" + type.toString());
    }

    public static JsonElement parseBiomeColormapData(BiomeColormap biomeColormap) {
        return GSON.toJsonTree((Object)biomeColormap);
    }

    public static BiomeColormap getBiomeColormap(class_2960 type) {
        return COLORMAPS.get(type);
    }

    public static BiomeColormap getColormap(class_6880<class_1959> biome, Season season) {
        BiomeColormap.ColormapType biomeTypeColormap = BiomeColormapManager.getColormapType(biome);
        return BiomeColormapManager.getBiomeColormap(BiomeColormapManager.getSerializedName(biomeTypeColormap, season));
    }

    public static BiomeColormap.ColormapType getColormapType(class_6880<class_1959> biome) {
        class_2960 biomeCategory = ClimateSettings.prefix((String)BiomeCategoryManager.getBiomeCategory(biome).toString());
        return BIOMETYPE_TO_COLORMAPTYPE.getOrDefault(biomeCategory, BiomeColormap.ColormapType.NORMAL);
    }

    public static void update(List<BiomeColormap> biomeColormapList) {
        COLORMAPS.clear();
        for (BiomeColormap biomeColormap : biomeColormapList) {
            COLORMAPS.put(biomeColormap.type(), biomeColormap);
        }
        HomeostaticSeasons.LOGGER.info("Updated {} biome colormap entries.", (Object)COLORMAPS.size());
    }

    protected void apply(Map<class_2960, JsonElement> pObject, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        COLORMAPS.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            try {
                BiomeColormap biomeColormap = (BiomeColormap)GSON.fromJson(entry.getValue(), BiomeColormap.class);
                COLORMAPS.put(entry.getKey(), biomeColormap);
            }
            catch (Exception e) {
                HomeostaticSeasons.LOGGER.error("Couldn't parse biome colormap data {} {}", (Object)entry.getKey(), (Object)e);
            }
        }
        HomeostaticSeasons.LOGGER.info("Loaded {} biome colormap entries.", (Object)COLORMAPS.size());
    }

    public static void syncWithClient(class_3222 player) {
        if (player != null) {
            List<BiomeColormap> biomeColormapList = COLORMAPS.values().stream().toList();
            DataResult result = Codec.list(BiomeColormap.CODEC).encodeStart((DynamicOps)class_2509.field_11560, biomeColormapList);
            class_2520 data = (class_2520)result.getOrThrow(error -> {
                throw new IllegalStateException("Failed to encode biome colormap data for syncing: " + error);
            });
            Services.CLIMATE.syncDataToPlayer((IPacket)new SyncBiomeColormap(data), player);
        }
    }
}

