/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.common.biome;

import climatesettings.common.biome.BiomeTypeData;
import climatesettings.common.biome.BiomeTypeDataManager;
import climatesettings.common.biome.HomeostaticClimateSettings;
import climatesettings.platform.Services;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import homeostaticseasons.api.HomeostaticSeasonsAPI;
import homeostaticseasons.api.Season;
import homeostaticseasons.common.biome.BiomeColormap;
import homeostaticseasons.common.biome.BiomeColormapManager;
import homeostaticseasons.util.RegistryHelper;
import homeostaticseasons.util.TemperatureHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2919;
import net.minecraft.class_3532;
import net.minecraft.class_3543;
import net.minecraft.class_4076;
import net.minecraft.class_5217;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6880;

public class BiomeTemperature {
    private static final class_3543 TEMPERATURE_NOISE = new class_3543((class_5819)new class_2919((class_5819)new class_5820(1234L)), (List)ImmutableList.of((Object)0));
    private final class_6880<class_1959> biomeHolder;
    private final class_1937 level;
    private final class_2338 blockPos;
    private final Season currentSeason;
    private float airTemperature;

    public BiomeTemperature(class_1959 biome, class_1937 level, class_2338 blockPos, float airTemperature) {
        this.biomeHolder = RegistryHelper.getBiomeHolder(biome, level);
        this.level = level;
        this.blockPos = blockPos;
        this.currentSeason = HomeostaticSeasonsAPI.getCurrentSeason(level);
        this.airTemperature = airTemperature;
    }

    public BiomeTemperature(class_6880<class_1959> biomeHolder, class_1937 level, class_2338 blockPos, float airTemperature) {
        this.biomeHolder = biomeHolder;
        this.level = level;
        this.blockPos = blockPos;
        this.currentSeason = HomeostaticSeasonsAPI.getCurrentSeason(level);
        this.airTemperature = airTemperature;
    }

    public boolean isWarmEnoughToRain() {
        return this.getAirTemperature() >= 0.15f;
    }

    public float getAirTemperature() {
        try {
            return this.getAirTemperatureRaw();
        }
        catch (NullPointerException e) {
            return 1.560241f;
        }
    }

    private float getAirTemperatureRaw() {
        if (!Float.isNaN(this.airTemperature)) {
            return this.airTemperature;
        }
        class_5217 info = this.level.method_8401();
        ArrayList<Pair> biomes = new ArrayList<Pair>();
        int chunkRange = 3;
        float accumulatedDryTemp = 0.0f;
        float accumulatedHumidity = 0.0f;
        for (int x = -chunkRange; x <= chunkRange; ++x) {
            for (int z = -chunkRange; z <= chunkRange; ++z) {
                class_2338 chunkPos = this.blockPos.method_10069(x * 16, 0, z * 16);
                if (chunkPos instanceof class_2338.class_2339) {
                    this.level.method_8398().method_12126(class_4076.method_18675((int)this.blockPos.method_10263()), class_4076.method_18675((int)this.blockPos.method_10260()), true);
                    if (this.level.method_31606(this.blockPos)) continue;
                    biomes.add(Pair.of((Object)this.level.method_23753(chunkPos), (Object)chunkPos));
                    continue;
                }
                if (!this.level.method_8477(chunkPos)) continue;
                biomes.add(Pair.of((Object)this.level.method_23753(chunkPos), (Object)chunkPos));
            }
        }
        for (Pair pair : biomes) {
            class_6880 chunkBiome = (class_6880)pair.getFirst();
            class_2338 chunkPos = (class_2338)pair.getSecond();
            float chunkTemp = BiomeTemperature.getHeightAdjustedTemperature(this.level, (class_6880<class_1959>)chunkBiome, chunkPos);
            accumulatedDryTemp += BiomeTemperature.getSeasonAdjustedTemperature(this.level, (class_6880<class_1959>)chunkBiome, chunkTemp, chunkPos, this.currentSeason);
            if (!info.method_146().method_8355(class_1928.field_19406)) continue;
            double chunkHumidity = BiomeTemperature.getBiomeHumidity(this.level, (class_6880<class_1959>)chunkBiome, chunkPos);
            accumulatedHumidity += (float)chunkHumidity;
        }
        double relativeHumidity = accumulatedHumidity / (float)biomes.size();
        float dayNightOffset = BiomeTemperature.getDayNightOffset(this.level, this.biomeHolder, relativeHumidity);
        float dryTemp = accumulatedDryTemp / (float)biomes.size() + dayNightOffset;
        float wetTemp = (float)TemperatureHelper.getHeatIndex(dryTemp, relativeHumidity);
        float blackGlobeTemp = (float)this.getBlackGlobeTemp(this.level, this.blockPos, dryTemp, relativeHumidity);
        this.airTemperature = wetTemp * 0.7f + blackGlobeTemp * 0.2f + dryTemp * 0.1f;
        return this.airTemperature;
    }

    private static float getHeightAdjustedTemperature(class_1937 level, class_6880<class_1959> biomeHolder, class_2338 blockPos) {
        class_1959.class_1963 precipitation = BiomeTemperature.getPrecipitationAt((class_1959)biomeHolder.comp_349(), blockPos);
        BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome(biomeHolder);
        float temperature = biomeTypeData.getTemperature(precipitation);
        if (blockPos.method_10264() > 80) {
            float noise = (float)(TEMPERATURE_NOISE.method_16451((double)((float)blockPos.method_10263() / 8.0f), (double)((float)blockPos.method_10260() / 8.0f), false) * 8.0);
            return temperature - (noise + BiomeTemperature.getAdjustedHeight(level, blockPos.method_10264()) - 80.0f) * 0.05f / 40.0f;
        }
        return temperature;
    }

    private static float getAdjustedHeight(class_1937 level, float y) {
        return y / ((float)level.method_31600() / 256.0f);
    }

    private static float getSeasonAdjustedTemperature(class_1937 level, class_6880<class_1959> biomeHolder, float temperature, class_2338 blockPos, Season currentSeason) {
        BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome(biomeHolder);
        if (currentSeason != null) {
            float lateSummerOffset = 0.111445785f;
            int subSeason = currentSeason.ordinal();
            float variation = biomeTypeData.getSeasonVariation(BiomeTemperature.getPrecipitationAt((class_1959)biomeHolder.comp_349(), blockPos)) / 2.0f;
            int season = subSeason + 9 <= 12 ? subSeason + 9 : subSeason - 3;
            double temp = BiomeTemperature.getSeasonTemperature(season, variation, temperature);
            if (season == 2) {
                temp += (double)lateSummerOffset;
            }
            return (float)temp;
        }
        return temperature;
    }

    private static double getSeasonTemperature(int season, float variation, float biomeTemp) {
        return (double)variation * Math.cos((double)(season - 1) * Math.PI / 6.0) + (double)biomeTemp;
    }

    private double getSunRadiation(class_1937 level, class_2338 blockPos) {
        double radiation = 0.0;
        double sunlight = level.method_8314(class_1944.field_9284, blockPos.method_10084()) - level.method_8594();
        float f = level.method_8442(1.0f);
        if (sunlight > 0.0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            sunlight *= (double)class_3532.method_15362((float)f);
        }
        return Math.max(radiation += sunlight * 100.0, 0.0);
    }

    private double getBlackGlobeTemp(class_1937 level, class_2338 blockPos, float dryTemp, double relativeHumidity) {
        return TemperatureHelper.getBlackGlobe(this.getSunRadiation(level, blockPos), dryTemp, relativeHumidity);
    }

    private static double getBiomeHumidity(class_1937 level, class_6880<class_1959> biomeHolder, class_2338 blockPos) {
        double biomeHumidity;
        class_1959 biome = (class_1959)biomeHolder.comp_349();
        double maxRH = BiomeTemperature.getMaxBiomeHumidity(biomeHolder, blockPos);
        double minRH = maxRH - 20.0;
        if (biome.method_48163()) {
            float rainLevel = level.method_8430(1.0f);
            biomeHumidity = level.method_8419() ? maxRH : minRH + 20.0 * (0.2 - (double)rainLevel);
        } else {
            biomeHumidity = minRH;
        }
        return biomeHumidity;
    }

    private static double getMaxBiomeHumidity(class_6880<class_1959> biomeHolder, class_2338 blockPos) {
        BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome(biomeHolder);
        return biomeTypeData.getHumidity(BiomeTemperature.getPrecipitationAt((class_1959)biomeHolder.comp_349(), blockPos));
    }

    private static float getDayNightOffset(class_1937 level, class_6880<class_1959> biomeHolder, double relativeHumidity) {
        long time = level.method_8532() % 24000L;
        HomeostaticClimateSettings climateSettings = Services.CLIMATE.getClimateSettings(biomeHolder);
        BiomeTypeData biomeTypeData = BiomeTypeDataManager.getDataForBiome(biomeHolder);
        float maxTemp = biomeTypeData.getDayNightOffset(climateSettings.getPrecipitationType());
        if (maxTemp == 0.0f) {
            return maxTemp;
        }
        float increaseTemp = maxTemp / 10000.0f;
        float decreaseTemp = maxTemp / 14000.0f;
        float humidityOffset = 1.0f - (float)(relativeHumidity / 100.0);
        float offset = time > 23000L ? (float)(24001L - time) * increaseTemp : (time < 9001L ? (float)(time + 1000L) * increaseTemp : maxTemp - (float)(time - 9000L) * decreaseTemp);
        return offset * humidityOffset;
    }

    public class_1959.class_1963 getPrecipitationType() {
        BiomeColormap.ColormapType colormapType = BiomeColormapManager.getColormapType(this.biomeHolder);
        if (colormapType == BiomeColormap.ColormapType.TEMPERATE) {
            if (this.currentSeason.isWetSeason()) {
                return this.isWarmEnoughToRain() ? class_1959.class_1963.field_9382 : class_1959.class_1963.field_9383;
            }
            return class_1959.class_1963.field_9384;
        }
        return this.isWarmEnoughToRain() ? class_1959.class_1963.field_9382 : class_1959.class_1963.field_9383;
    }

    public static class_1959.class_1963 getPrecipitationAt(class_1959 biome, class_2338 pos) {
        if (!biome.method_48163()) {
            return class_1959.class_1963.field_9384;
        }
        return BiomeTemperature.coldEnoughToSnow(biome, pos) ? class_1959.class_1963.field_9383 : class_1959.class_1963.field_9382;
    }

    public static boolean coldEnoughToSnow(class_1959 biome, class_2338 pos) {
        return !BiomeTemperature.warmEnoughToRain(biome, pos);
    }

    public static boolean warmEnoughToRain(class_1959 biome, class_2338 pos) {
        return biome.method_21740(pos) >= 0.15f;
    }

    public String toString() {
        return "BiomeTemperature{biome=" + this.biomeHolder.method_55840() + ", pos=" + String.valueOf(this.blockPos) + ", season=" + String.valueOf((Object)this.currentSeason) + ", airTemperature=" + this.airTemperature + "}";
    }
}

