/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.common.biome.client;

import homeostaticseasons.api.HomeostaticSeasonsAPI;
import homeostaticseasons.api.Season;
import homeostaticseasons.common.biome.BiomeColormap;
import homeostaticseasons.common.biome.BiomeColormapManager;
import homeostaticseasons.config.ConfigHandler;
import homeostaticseasons.util.ColorHelper;
import homeostaticseasons.util.RegistryHelper;
import net.minecraft.class_1163;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_6880;

public class ColormapResolvers {
    private static class_6539 builtinGrassColorResolver;
    private static class_6539 builtinFoliageColorResolver;

    public static void init() {
        builtinGrassColorResolver = class_1163.field_5665;
        builtinFoliageColorResolver = class_1163.field_5664;
        class_1163.field_5665 = (biome, temperature, humidity) -> ColormapResolvers.getColor(ColormapType.GRASS, biome, temperature, humidity);
        class_1163.field_5664 = (biome, temperature, humidity) -> ColormapResolvers.getColor(ColormapType.FOLIAGE, biome, temperature, humidity);
    }

    private static int getColor(ColormapType type, class_1959 biome, double temperature, double humidity) {
        int originalColor = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> builtinGrassColorResolver.getColor(biome, temperature, humidity);
            case 1 -> builtinFoliageColorResolver.getColor(biome, temperature, humidity);
        };
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (type == ColormapType.GRASS && !ConfigHandler.Client.changeGrassColor()) {
            return originalColor;
        }
        if (type == ColormapType.FOLIAGE && !ConfigHandler.Client.changeFoliageColor()) {
            return originalColor;
        }
        if (level != null && ConfigHandler.Common.isValidDimension((class_5321<class_1937>)level.method_27983())) {
            class_6880<class_1959> biomeHolder = RegistryHelper.getBiomeHolder(biome, (class_1937)level);
            Season currentSeason = HomeostaticSeasonsAPI.getCurrentSeason((class_1937)level);
            if (biomeHolder != null && currentSeason != null) {
                BiomeColormap biomeColormap = BiomeColormapManager.getColormap(biomeHolder, currentSeason);
                BiomeColormap nextSeasonBiomeColormap = BiomeColormapManager.getColormap(biomeHolder, HomeostaticSeasonsAPI.getNextSeason((class_1937)level, currentSeason));
                if (biomeColormap != null && nextSeasonBiomeColormap != null) {
                    long seasonLength = currentSeason.getSeasonLength();
                    long timeUntilNextSeason = HomeostaticSeasonsAPI.getTimeUntilNextSeason((class_1937)level);
                    if (type == ColormapType.GRASS) {
                        return ColorHelper.mix(biomeColormap.getGrassColor(originalColor, biomeHolder), nextSeasonBiomeColormap.getGrassColor(originalColor, biomeHolder), (float)timeUntilNextSeason / (float)seasonLength);
                    }
                    return ColorHelper.mix(biomeColormap.getFoliageColor(originalColor, biomeHolder), nextSeasonBiomeColormap.getFoliageColor(originalColor, biomeHolder), (float)timeUntilNextSeason / (float)seasonLength);
                }
            }
        }
        return originalColor;
    }

    private static enum ColormapType {
        GRASS,
        FOLIAGE;

    }
}

