/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.common.season;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostaticseasons.HomeostaticSeasons;
import homeostaticseasons.api.Season;
import homeostaticseasons.common.season.WeatherData;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;

public class WeatherDataManager
extends class_4309 {
    private static final Map<Season, WeatherData> WEATHER_DATA = new HashMap<Season, WeatherData>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(WeatherData.class, (Object)new WeatherData.Serializer()).create();

    public WeatherDataManager() {
        super(GSON, "seasons/weather");
    }

    public static WeatherData getWeatherData(Season season) {
        return WEATHER_DATA.getOrDefault((Object)season, null);
    }

    public static JsonElement parseWeatherData(WeatherData weatherData) {
        return GSON.toJsonTree((Object)weatherData);
    }

    protected void apply(@NotNull Map<class_2960, JsonElement> pObject, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        WEATHER_DATA.clear();
        for (Map.Entry<class_2960, JsonElement> entry : pObject.entrySet()) {
            try {
                WeatherData weatherData = (WeatherData)GSON.fromJson(entry.getValue(), WeatherData.class);
                WEATHER_DATA.put(Season.valueOf(entry.getKey().method_12832().toUpperCase(Locale.ROOT)), weatherData);
            }
            catch (Exception e) {
                HomeostaticSeasons.LOGGER.error("Failed to load weather data: {}", (Object)entry.getKey(), (Object)e);
            }
        }
        HomeostaticSeasons.LOGGER.info("Loaded {} weather data entries", (Object)WEATHER_DATA.size());
        HomeostaticSeasons.LOGGER.info("Loaded {} weather data", WEATHER_DATA);
    }
}

