/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.config;

import homeostaticseasons.HomeostaticSeasons;
import homeostaticseasons.api.Hemisphere;
import homeostaticseasons.api.Season;
import homeostaticseasons.api.SeasonChangeMethod;
import homeostaticseasons.common.Translations;
import homeostaticseasons.platform.Services;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public class ConfigHandler {
    public static final WhiteNoiseConfigSpec CLIENT_SPEC;
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Client CLIENT;
    private static final Common COMMON;

    public static void initCommon() {
        Common.seasonLengths = new SeasonLengths((Long)ConfigHandler.COMMON.earlySpringDaysLength.get(), (Long)ConfigHandler.COMMON.midSpringDaysLength.get(), (Long)ConfigHandler.COMMON.lateSpringDaysLength.get(), (Long)ConfigHandler.COMMON.earlySummerDaysLength.get(), (Long)ConfigHandler.COMMON.midSummerDaysLength.get(), (Long)ConfigHandler.COMMON.lateSummerDaysLength.get(), (Long)ConfigHandler.COMMON.earlyAutumnDaysLength.get(), (Long)ConfigHandler.COMMON.midAutumnDaysLength.get(), (Long)ConfigHandler.COMMON.lateAutumnDaysLength.get(), (Long)ConfigHandler.COMMON.earlyWinterDaysLength.get(), (Long)ConfigHandler.COMMON.midWinterDaysLength.get(), (Long)ConfigHandler.COMMON.lateWinterDaysLength.get());
        Common.seasonMap.clear();
        Season startingSeason = Season.EARLY_SPRING;
        for (int i = 0; i < Season.values().length; ++i) {
            Season season = Season.values()[i];
            long cumulativeLength = 0L;
            for (int j = 0; j <= i; ++j) {
                cumulativeLength += Season.values()[j].getSeasonLength();
            }
            Common.seasonMap.put(cumulativeLength - startingSeason.getSeasonLength(), season);
            Common.seasonStartTimes.put(season, cumulativeLength - startingSeason.getSeasonLength());
        }
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            HomeostaticSeasons.LOGGER.warn("initialized seasonMap {}", Common.seasonMap);
        }
    }

    private static String getTranslation(String key) {
        return Translations.get(key);
    }

    static {
        Pair specPairClient = new WhiteNoiseConfigSpec.Builder().configure(Client::new);
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        CLIENT_SPEC = (WhiteNoiseConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    private record SeasonLengths(long earlySpring, long midSpring, long lateSpring, long earlySummer, long midSummer, long lateSummer, long earlyAutumn, long midAutumn, long lateAutumn, long earlyWinter, long midWinter, long lateWinter) {
        private SeasonLengths(long earlySpring, long midSpring, long lateSpring, long earlySummer, long midSummer, long lateSummer, long earlyAutumn, long midAutumn, long lateAutumn, long earlyWinter, long midWinter, long lateWinter) {
            this.earlySpring = earlySpring * 24000L;
            this.midSpring = midSpring * 24000L;
            this.lateSpring = lateSpring * 24000L;
            this.earlySummer = earlySummer * 24000L;
            this.midSummer = midSummer * 24000L;
            this.lateSummer = lateSummer * 24000L;
            this.earlyAutumn = earlyAutumn * 24000L;
            this.midAutumn = midAutumn * 24000L;
            this.lateAutumn = lateAutumn * 24000L;
            this.earlyWinter = earlyWinter * 24000L;
            this.midWinter = midWinter * 24000L;
            this.lateWinter = lateWinter * 24000L;
        }

        public long getTotalLength() {
            return this.earlySpring + this.midSpring + this.lateSpring + this.earlySummer + this.midSummer + this.lateSummer + this.earlyAutumn + this.midAutumn + this.lateAutumn + this.earlyWinter + this.midWinter + this.lateWinter;
        }
    }

    public static final class Common {
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> whitelistDimensions;
        private static final List<String> whitelistDimensionsList = List.of("whitelistDimensions");
        private static final String[] defaultWhitelistDimensions = new String[]{"minecraft:overworld"};
        private static final Predicate<Object> resourceLocationValidator = s -> s instanceof String && ((String)s).matches("[a-z]+[:]{1}[a-z_]+");
        private final WhiteNoiseConfigSpec.EnumValue<SeasonChangeMethod> seasonChangeMethod;
        private final WhiteNoiseConfigSpec.EnumValue<Hemisphere> hemisphere;
        private static SeasonLengths seasonLengths;
        private final WhiteNoiseConfigSpec.EnumValue<Season> fixedSeason;
        private final WhiteNoiseConfigSpec.EnumValue<Season> startingSeason;
        private static final NavigableMap<Long, Season> seasonMap;
        private static final Map<Season, Long> seasonStartTimes;
        private final WhiteNoiseConfigSpec.LongValue earlySpringDaysLength;
        private final WhiteNoiseConfigSpec.LongValue midSpringDaysLength;
        private final WhiteNoiseConfigSpec.LongValue lateSpringDaysLength;
        private final WhiteNoiseConfigSpec.LongValue earlySummerDaysLength;
        private final WhiteNoiseConfigSpec.LongValue midSummerDaysLength;
        private final WhiteNoiseConfigSpec.LongValue lateSummerDaysLength;
        private final WhiteNoiseConfigSpec.LongValue earlyAutumnDaysLength;
        private final WhiteNoiseConfigSpec.LongValue midAutumnDaysLength;
        private final WhiteNoiseConfigSpec.LongValue lateAutumnDaysLength;
        private final WhiteNoiseConfigSpec.LongValue earlyWinterDaysLength;
        private final WhiteNoiseConfigSpec.LongValue midWinterDaysLength;
        private final WhiteNoiseConfigSpec.LongValue lateWinterDaysLength;
        private final WhiteNoiseConfigSpec.BooleanValue seasonalSnowReplaceVegetation;
        private final WhiteNoiseConfigSpec.IntValue snowAccumulationHeight;

        Common(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("seasons").comment(ConfigHandler.getTranslation("seasons"));
            this.whitelistDimensions = builder.comment(ConfigHandler.getTranslation("whitelistdimensions")).defineListAllowEmpty(whitelistDimensionsList, Common.getDefaultWhitelistDimensions(), resourceLocationValidator);
            this.seasonChangeMethod = builder.comment(ConfigHandler.getTranslation("seasonchangemethod")).defineEnum("seasonChangeMethod", (Enum)SeasonChangeMethod.CONFIGURED);
            this.hemisphere = builder.comment(ConfigHandler.getTranslation("hemisphere")).defineEnum("hemisphere", (Enum)Hemisphere.NORTHERN);
            this.fixedSeason = builder.comment(ConfigHandler.getTranslation("fixedseason")).defineEnum("fixedSeason", (Enum)Season.EARLY_SPRING);
            this.startingSeason = builder.comment("The season that the world starts in.").defineEnum("startingSeason", (Enum)Season.EARLY_SPRING);
            this.earlySpringDaysLength = builder.comment(ConfigHandler.getTranslation("earlyspringdayslength")).defineInRange("earlySpringDaysLength", 3L, 1L, 60L);
            this.midSpringDaysLength = builder.comment(ConfigHandler.getTranslation("midspringdayslength")).defineInRange("midSpringDaysLength", 3L, 1L, 60L);
            this.lateSpringDaysLength = builder.comment(ConfigHandler.getTranslation("latespringdayslength")).defineInRange("lateSpringDaysLength", 3L, 1L, 60L);
            this.earlySummerDaysLength = builder.comment(ConfigHandler.getTranslation("earlysummerdayslength")).defineInRange("earlySummerDaysLength", 3L, 1L, 60L);
            this.midSummerDaysLength = builder.comment(ConfigHandler.getTranslation("midsummerdayslength")).defineInRange("midSummerDaysLength", 3L, 1L, 60L);
            this.lateSummerDaysLength = builder.comment(ConfigHandler.getTranslation("latesummerdayslength")).defineInRange("lateSummerDaysLength", 3L, 1L, 60L);
            this.earlyAutumnDaysLength = builder.comment(ConfigHandler.getTranslation("earlyautumndayslength")).defineInRange("earlyAutumnDaysLength", 3L, 1L, 60L);
            this.midAutumnDaysLength = builder.comment(ConfigHandler.getTranslation("midautumndayslength")).defineInRange("midAutumnDaysLength", 3L, 1L, 60L);
            this.lateAutumnDaysLength = builder.comment(ConfigHandler.getTranslation("lateautumndayslength")).defineInRange("lateAutumnDaysLength", 3L, 1L, 60L);
            this.earlyWinterDaysLength = builder.comment(ConfigHandler.getTranslation("earlywinterdayslength")).defineInRange("earlyWinterDaysLength", 3L, 1L, 60L);
            this.midWinterDaysLength = builder.comment(ConfigHandler.getTranslation("midwinterdayslength")).defineInRange("midWinterDaysLength", 3L, 1L, 60L);
            this.lateWinterDaysLength = builder.comment(ConfigHandler.getTranslation("latewinterdayslength")).defineInRange("lateWinterDaysLength", 3L, 1L, 60L);
            builder.pop();
            builder.push("weather").comment(ConfigHandler.getTranslation("weather"));
            this.seasonalSnowReplaceVegetation = builder.comment(ConfigHandler.getTranslation("seasonalsnowreplacevegetation")).define("seasonalSnowReplaceVegetation", true);
            this.snowAccumulationHeight = builder.comment(ConfigHandler.getTranslation("snowaccumulationheight")).defineInRange("snowAccumulationHeight", 1, 1, 8);
            builder.pop();
        }

        public static SeasonChangeMethod seasonChangeMethod() {
            return (SeasonChangeMethod)((Object)ConfigHandler.COMMON.seasonChangeMethod.get());
        }

        public static Hemisphere hemisphere() {
            return (Hemisphere)((Object)ConfigHandler.COMMON.hemisphere.get());
        }

        public static Season fixedSeason() {
            return (Season)((Object)ConfigHandler.COMMON.fixedSeason.get());
        }

        public static Season startingSeason() {
            return (Season)((Object)ConfigHandler.COMMON.startingSeason.get());
        }

        public static long earlySpringDaysLength() {
            return Common.seasonLengths.earlySpring;
        }

        public static long midSpringDaysLength() {
            return Common.seasonLengths.midSpring;
        }

        public static long lateSpringDaysLength() {
            return Common.seasonLengths.lateSpring;
        }

        public static long earlySummerDaysLength() {
            return Common.seasonLengths.earlySummer;
        }

        public static long midSummerDaysLength() {
            return Common.seasonLengths.midSummer;
        }

        public static long lateSummerDaysLength() {
            return Common.seasonLengths.lateSummer;
        }

        public static long earlyAutumnDaysLength() {
            return Common.seasonLengths.earlyAutumn;
        }

        public static long midAutumnDaysLength() {
            return Common.seasonLengths.midAutumn;
        }

        public static long lateAutumnDaysLength() {
            return Common.seasonLengths.lateAutumn;
        }

        public static long earlyWinterDaysLength() {
            return Common.seasonLengths.earlyWinter;
        }

        public static long midWinterDaysLength() {
            return Common.seasonLengths.midWinter;
        }

        public static long lateWinterDaysLength() {
            return Common.seasonLengths.lateWinter;
        }

        public static long getTotalYearLength() {
            return seasonLengths.getTotalLength();
        }

        public static Season getSeasonFromDayTime(long dayTime) {
            long timeOfYear = dayTime < Common.getTotalYearLength() ? dayTime : dayTime % Common.getTotalYearLength();
            return seasonMap.floorEntry(timeOfYear).getValue();
        }

        public static long getTimeUntilNextSeason(long gameTime) {
            long seasonTime = gameTime < Common.getTotalYearLength() ? gameTime : gameTime % Common.getTotalYearLength();
            Long nextKey = seasonMap.higherKey(seasonTime);
            return Objects.requireNonNullElseGet(nextKey, Common::getTotalYearLength) - seasonTime;
        }

        public static long getTimeUntilSeason(long gameTime, Season season) {
            long timeOfYear;
            long seasonStartTime = seasonStartTimes.get((Object)season);
            if (seasonStartTime >= (timeOfYear = gameTime < Common.getTotalYearLength() ? gameTime : gameTime % Common.getTotalYearLength())) {
                return seasonStartTime - timeOfYear;
            }
            return Common.getTotalYearLength() - timeOfYear + seasonStartTime;
        }

        public static long getSeasonTime(Season season) {
            return seasonStartTimes.get((Object)season);
        }

        public static boolean isValidDimension(class_5321<class_1937> dimensionKey) {
            return ((List)ConfigHandler.COMMON.whitelistDimensions.get()).contains(dimensionKey.method_29177().toString());
        }

        private static Supplier<List<? extends String>> getDefaultWhitelistDimensions() {
            return () -> Arrays.asList(defaultWhitelistDimensions);
        }

        public static boolean seasonalSnowReplaceVegetation() {
            return (Boolean)ConfigHandler.COMMON.seasonalSnowReplaceVegetation.get();
        }

        public static int snowAccumulationHeight() {
            return (Integer)ConfigHandler.COMMON.snowAccumulationHeight.get();
        }

        static {
            seasonMap = new TreeMap<Long, Season>();
            seasonStartTimes = new HashMap<Season, Long>(12);
        }
    }

    public static final class Client {
        private final WhiteNoiseConfigSpec.BooleanValue changeFoliageColor;
        private final WhiteNoiseConfigSpec.BooleanValue changeGrassColor;
        private final WhiteNoiseConfigSpec.BooleanValue changeBirchColor;

        Client(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("visuals").comment(ConfigHandler.getTranslation("visuals"));
            this.changeFoliageColor = builder.comment(ConfigHandler.getTranslation("changefoliagecolor")).define("changeFoliageColor", true);
            this.changeGrassColor = builder.comment(ConfigHandler.getTranslation("changegrasscolor")).define("changeGrassColor", true);
            this.changeBirchColor = builder.comment(ConfigHandler.getTranslation("changebirchcolor")).define("changeBirchColor", true);
            builder.pop();
        }

        public static boolean changeFoliageColor() {
            return (Boolean)ConfigHandler.CLIENT.changeFoliageColor.get();
        }

        public static boolean changeGrassColor() {
            return (Boolean)ConfigHandler.CLIENT.changeGrassColor.get();
        }

        public static boolean changeBirchColor() {
            return (Boolean)ConfigHandler.CLIENT.changeBirchColor.get();
        }
    }
}

