/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.data;

import com.google.gson.JsonElement;
import homeostaticseasons.HomeostaticSeasons;
import homeostaticseasons.common.biome.BiomeColormap;
import homeostaticseasons.common.biome.BiomeColormapManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

public class BiomeColormapDataProvider
implements class_2405 {
    private final Map<class_2960, BiomeColormap> BIOME_TYPES_MAP = new HashMap<class_2960, BiomeColormap>();
    private final class_7784 packOutput;

    public BiomeColormapDataProvider(class_7784 packOutput) {
        this.packOutput = packOutput;
    }

    protected void registerBiomeColormapData() {
        this.add(HomeostaticSeasons.prefix("early_spring_normal"), 7312255, 0.75f, 7307647, 0.75f, 8821352);
        this.add(HomeostaticSeasons.prefix("mid_spring_normal"), 5216943, 0.9f, 5211567, 0.9f, 7254658);
        this.add(HomeostaticSeasons.prefix("late_spring_normal"), 6265503, 6260127, 7646836);
        this.add(HomeostaticSeasons.prefix("early_summer_normal"), 7313039, 7307919, 8039011);
        this.add(HomeostaticSeasons.prefix("mid_summer_normal"), 0xFFFFFF, 0xFFFFFF, 8431446);
        this.add(HomeostaticSeasons.prefix("late_summer_normal"), 10449231, 10444623, 10003785);
        this.add(HomeostaticSeasons.prefix("early_autumn_normal"), 12866625, 12861505, 11641921);
        this.add(HomeostaticSeasons.prefix("mid_autumn_normal"), 15676706, 15671586, 14852658);
        this.add(HomeostaticSeasons.prefix("late_autumn_normal"), 16068123, 0.85f, 16063003, 0.85f, 15246379);
        this.add(HomeostaticSeasons.prefix("early_winter_normal"), 16394261, 0.6f, 16389141, 0.6f, 15771172);
        this.add(HomeostaticSeasons.prefix("mid_winter_normal"), 16326155, 0.45f, 16321035, 0.45f, 16098327);
        this.add(HomeostaticSeasons.prefix("late_winter_normal"), 16651779, 0.6f, 16646659, 0.6f, 16622083);
        this.add(HomeostaticSeasons.prefix("early_spring_temperate"), 0xFFFFFF, 0xFFFFFF, 526966);
        this.add(HomeostaticSeasons.prefix("mid_spring_temperate"), 0xFFFFFF, 0xFFFFFF, 526966);
        this.add(HomeostaticSeasons.prefix("late_spring_temperate"), 10847847, 0.8f, 12027532, 0.95f, 10003783);
        this.add(HomeostaticSeasons.prefix("early_summer_temperate"), 10847849, 0.8f, 12027532, 0.95f, 10003803);
        this.add(HomeostaticSeasons.prefix("mid_summer_temperate"), 9337725, 0.9f, 10521479, 0.975f, 8431444);
        this.add(HomeostaticSeasons.prefix("late_summer_temperate"), 9337725, 0.9f, 10521479, 0.975f, 8431444);
        this.add(HomeostaticSeasons.prefix("early_autumn_temperate"), 7703674, 7507089, 8431445);
        this.add(HomeostaticSeasons.prefix("mid_autumn_temperate"), 7703674, 7507073, 8431429);
        this.add(HomeostaticSeasons.prefix("late_autumn_temperate"), 5538676, 2398126, 7777372);
        this.add(HomeostaticSeasons.prefix("early_winter_temperate"), 5538676, 2394286, 7777372);
        this.add(HomeostaticSeasons.prefix("mid_winter_temperate"), 6654329, 5146755, 8431429);
        this.add(HomeostaticSeasons.prefix("late_winter_temperate"), 6654329, 5146755, 8431429);
    }

    protected void add(class_2960 id, int grassColor, float grassSaturation, int foliageColor, float foliageSaturation, int birchColor) {
        BiomeColormap biomeColormap = new BiomeColormap(id, grassColor, grassSaturation, foliageColor, foliageSaturation, birchColor);
        this.BIOME_TYPES_MAP.put(id, biomeColormap);
    }

    protected void add(class_2960 id, int grassColor, int foliageColor, int birchColor) {
        BiomeColormap biomeColormap = new BiomeColormap(id, grassColor, foliageColor, birchColor);
        this.BIOME_TYPES_MAP.put(id, biomeColormap);
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        this.registerBiomeColormapData();
        for (Map.Entry<class_2960, BiomeColormap> entry : this.BIOME_TYPES_MAP.entrySet()) {
            class_7784.class_7489 pathProvider = this.getPath();
            futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)BiomeColormapManager.parseBiomeColormapData(entry.getValue()), (Path)pathProvider.method_44107(entry.getKey())));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String method_10321() {
        return "HomeostaticSeasons - Biome Colormap Data";
    }

    private class_7784.class_7489 getPath() {
        return this.packOutput.method_45973(class_7784.class_7490.field_39367, "biome/colormaps/");
    }
}

