/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.data;

import homeostaticseasons.api.Season;
import homeostaticseasons.common.Translations;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_7225;

public class HomeostaticSeasonsLanguageProvider
extends FabricLanguageProvider {
    protected HomeostaticSeasonsLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, "en_us", registryLookup);
    }

    public void generateTranslations(class_7225.class_7874 provider, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.addCommand(translationBuilder, "query_season", "The current season is %s.");
        this.addCommand(translationBuilder, "query_next_season", "There are %s days (%s ticks) left until %s.");
        this.addConfigTitle(translationBuilder, "Homeostatic Seasons");
        this.addConfigTranslation(translationBuilder, "visuals");
        this.addConfigTranslation(translationBuilder, "changefoliagecolor");
        this.addConfigTranslation(translationBuilder, "changegrasscolor");
        this.addConfigTranslation(translationBuilder, "changebirchcolor");
        this.addConfigTranslation(translationBuilder, "seasons");
        this.addConfigTranslation(translationBuilder, "whitelistdimensions");
        this.addConfigTranslation(translationBuilder, "seasonchangemethod");
        this.addConfigTranslation(translationBuilder, "hemisphere");
        this.addConfigTranslation(translationBuilder, "fixedseason");
        this.addConfigTranslation(translationBuilder, "startingseason");
        this.addConfigTranslation(translationBuilder, "earlyspringdayslength");
        this.addConfigTranslation(translationBuilder, "midspringdayslength");
        this.addConfigTranslation(translationBuilder, "latespringdayslength");
        this.addConfigTranslation(translationBuilder, "earlysummerdayslength");
        this.addConfigTranslation(translationBuilder, "midsummerdayslength");
        this.addConfigTranslation(translationBuilder, "latesummerdayslength");
        this.addConfigTranslation(translationBuilder, "earlyautumndayslength");
        this.addConfigTranslation(translationBuilder, "midautumndayslength");
        this.addConfigTranslation(translationBuilder, "lateautumndayslength");
        this.addConfigTranslation(translationBuilder, "earlywinterdayslength");
        this.addConfigTranslation(translationBuilder, "midwinterdayslength");
        this.addConfigTranslation(translationBuilder, "latewinterdayslength");
        this.addConfigTranslation(translationBuilder, "weather");
        this.addConfigTranslation(translationBuilder, "seasonalsnowreplacevegetation");
        this.addConfigTranslation(translationBuilder, "snowaccumulationheight");
        this.addSeasonTranslations(translationBuilder);
    }

    private void addSeasonTranslations(FabricLanguageProvider.TranslationBuilder builder) {
        for (Season season : Season.values()) {
            builder.add(season.getTranslationKey(), season.getHumanReadableName());
        }
    }

    private void addCommand(FabricLanguageProvider.TranslationBuilder builder, String command, String description) {
        builder.add("homeostaticseasons.command." + command, description);
    }

    private void addConfigTitle(FabricLanguageProvider.TranslationBuilder builder, String title) {
        builder.add("homeostaticseasons.configuration.title", title);
    }

    private void addConfigName(FabricLanguageProvider.TranslationBuilder builder, String id, String name) {
        builder.add("homeostaticseasons.configuration." + id + ".name", name);
    }

    private void addConfigDescription(FabricLanguageProvider.TranslationBuilder builder, String id) {
        builder.add("homeostaticseasons.configuration." + id + ".description", Translations.get(id));
    }

    private void addConfigTranslation(FabricLanguageProvider.TranslationBuilder buildder, String id) {
        this.addConfigName(buildder, id, Translations.get(id + ".title"));
        this.addConfigDescription(buildder, id);
    }
}

