/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.data;

import com.google.gson.JsonElement;
import homeostaticseasons.HomeostaticSeasons;
import homeostaticseasons.api.Season;
import homeostaticseasons.common.season.WeatherData;
import homeostaticseasons.common.season.WeatherDataManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

public class WeatherDataProvider
implements class_2405 {
    private final Map<class_2960, WeatherData> SEASONS_WEATHER_MAP = new HashMap<class_2960, WeatherData>();
    private final class_7784 packOutput;

    public WeatherDataProvider(class_7784 packOutput) {
        this.packOutput = packOutput;
    }

    protected void registerWeatherData() {
        this.add(HomeostaticSeasons.prefix(Season.EARLY_SPRING.method_15434()), new WeatherData(class_3218.field_41749.method_35009(), 65000, class_3218.field_41748.method_35009(), class_3218.field_41748.method_35011()));
        this.add(HomeostaticSeasons.prefix(Season.MID_SPRING.method_15434()), new WeatherData(class_3218.field_41749.method_35009(), 36000, class_3218.field_41748.method_35009(), 96000));
        this.add(HomeostaticSeasons.prefix(Season.LATE_SPRING.method_15434()), new WeatherData(class_3218.field_41749.method_35009(), 65000, class_3218.field_41748.method_35009(), 84000));
        this.add(HomeostaticSeasons.prefix(Season.EARLY_SUMMER.method_15434()), new WeatherData(class_3218.field_41749.method_35009(), class_3218.field_41749.method_35011(), class_3218.field_41748.method_35009(), 72000));
        this.add(HomeostaticSeasons.prefix(Season.MID_SUMMER.method_15434()), new WeatherData(class_3218.field_41749.method_35009(), class_3218.field_41749.method_35011(), class_3218.field_41748.method_35009(), 64000));
        this.add(HomeostaticSeasons.prefix(Season.LATE_SUMMER.method_15434()), new WeatherData(class_3218.field_41749.method_35009(), class_3218.field_41749.method_35011(), class_3218.field_41748.method_35009(), 96000));
        this.add(HomeostaticSeasons.prefix(Season.EARLY_AUTUMN.method_15434()), new WeatherData(class_3218.field_41749.method_35009(), class_3218.field_41749.method_35011(), class_3218.field_41748.method_35009(), class_3218.field_41748.method_35011()));
        this.add(HomeostaticSeasons.prefix(Season.MID_AUTUMN.method_15434()), new WeatherData(class_3218.field_41749.method_35009(), class_3218.field_41749.method_35011(), class_3218.field_41748.method_35009(), class_3218.field_41748.method_35011()));
        this.add(HomeostaticSeasons.prefix(Season.LATE_AUTUMN.method_15434()), new WeatherData(class_3218.field_41749.method_35009(), class_3218.field_41749.method_35011(), class_3218.field_41748.method_35009(), class_3218.field_41748.method_35011()));
        this.add(HomeostaticSeasons.prefix(Season.EARLY_WINTER.method_15434()), new WeatherData(class_3218.field_41749.method_35009(), 90000, -1, -1));
        this.add(HomeostaticSeasons.prefix(Season.MID_WINTER.method_15434()), new WeatherData(class_3218.field_41749.method_35009(), 90000, -1, -1));
        this.add(HomeostaticSeasons.prefix(Season.LATE_WINTER.method_15434()), new WeatherData(class_3218.field_41749.method_35009(), 90000, -1, -1));
    }

    protected void add(class_2960 seasonLoc, WeatherData weatherData) {
        this.SEASONS_WEATHER_MAP.put(seasonLoc, weatherData);
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        this.registerWeatherData();
        for (Map.Entry<class_2960, WeatherData> entry : this.SEASONS_WEATHER_MAP.entrySet()) {
            class_7784.class_7489 pathProvider = this.getPath();
            futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)WeatherDataManager.parseWeatherData(entry.getValue()), (Path)pathProvider.method_44107(entry.getKey())));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String method_10321() {
        return "HomeostaticSeasons - Weather Data";
    }

    private class_7784.class_7489 getPath() {
        return this.packOutput.method_45973(class_7784.class_7490.field_39367, "seasons/weather/");
    }
}

