/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.util;

import java.awt.Color;

public class ColorHelper
extends technology.roughness.whitenoise.util.ColorHelper {
    public static int multiply(int color, int otherColor) {
        return (int)((float)color / 255.0f * ((float)otherColor / 255.0f) * 255.0f);
    }

    public static int blendComponent(int color, int otherColor) {
        int blended = color < 128 ? ColorHelper.multiply(color * 2, otherColor) : 255 - ColorHelper.multiply((255 - color) * 2, 255 - otherColor);
        return blended;
    }

    public static int blend(int color, int otherColor) {
        int r = ColorHelper.blendComponent(color >> 16 & 0xFF, otherColor >> 16 & 0xFF);
        int g = ColorHelper.blendComponent(color >> 8 & 0xFF, otherColor >> 8 & 0xFF);
        int b = ColorHelper.blendComponent(color & 0xFF, otherColor & 0xFF);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int mix(int color, int otherColor, float ratio) {
        Color c1 = new Color(color);
        Color c2 = new Color(otherColor);
        Color mixed = ColorHelper.mix(c1, c2, (double)ratio);
        return mixed.getRGB();
    }

    public static Color mix(Color color1, Color color2, double ratio) {
        ratio = Math.max(0.0, Math.min(1.0, ratio));
        double inverseRatio = 1.0 - ratio;
        int r = (int)((double)color1.getRed() * ratio + (double)color2.getRed() * inverseRatio);
        int g = (int)((double)color1.getGreen() * ratio + (double)color2.getGreen() * inverseRatio);
        int b = (int)((double)color1.getBlue() * ratio + (double)color2.getBlue() * inverseRatio);
        int a = (int)((double)color1.getAlpha() * ratio + (double)color2.getAlpha() * inverseRatio);
        return new Color(r, g, b, a);
    }

    public static int saturate(int color, float saturation) {
        Color c = new Color(color);
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        int saturatedColor = Color.HSBtoRGB(hsb[0], Math.min(1.0f, hsb[1] * saturation), hsb[2]);
        return saturatedColor & 0xFFFFFF | c.getAlpha() << 24;
    }
}

