/*
 * Decompiled with CFR 0.152.
 */
package homeostaticseasons.util;

public class TemperatureHelper {
    public static double getBlackGlobe(double radiation, float dryTemp, double relativeHumidity) {
        double dryTempC = TemperatureHelper.convertMcTemp(dryTemp, false);
        double blackGlobeTemp = 0.01498 * radiation + 1.184 * dryTempC - 0.0789 * (relativeHumidity / 100.0) - 2.739;
        return TemperatureHelper.convertTemp(blackGlobeTemp, false);
    }

    public static double convertMcTemp(float mcTemp, boolean fahrenheit) {
        double temp = 25.27027027 + 44.86486486 * (double)mcTemp;
        if (!fahrenheit) {
            temp = (temp - 32.0) * 0.5556;
        }
        return temp;
    }

    public static double convertTemp(double temp, boolean fahrenheit) {
        double toConvert = temp;
        if (!fahrenheit) {
            toConvert = temp / 0.5556 + 32.0;
        }
        return (toConvert - 25.27027027) / 44.86486486;
    }

    public static double getHeatIndex(float dryTemp, double rh) {
        double hIndex;
        double dryTempF = TemperatureHelper.convertMcTemp(dryTemp, true);
        if (dryTempF < 80.0) {
            hIndex = 0.5 * (dryTempF + 61.0 + (dryTempF - 68.0) * 1.2) + rh * 0.094;
        } else {
            hIndex = -42.379 + 2.04901523 * dryTempF + 10.14333127 * rh;
            hIndex = hIndex - 0.22475541 * dryTempF * rh - 6.83783 * Math.pow(10.0, -3.0) * dryTempF * dryTempF;
            hIndex -= 5.481717 * Math.pow(10.0, -2.0) * rh * rh;
            hIndex += 1.22874 * Math.pow(10.0, -3.0) * dryTempF * dryTempF * rh;
            hIndex += 8.5282 * Math.pow(10.0, -4.0) * dryTempF * rh * rh;
            hIndex -= 1.99 * Math.pow(10.0, -6.0) * dryTempF * dryTempF * rh * rh;
        }
        return TemperatureHelper.convertTemp(hIndex, true);
    }
}

