/*
 * Decompiled with CFR 0.152.
 */
package willatendo.wtfit.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import willatendo.wtfit.api.ResourceEfficiency;
import willatendo.wtfit.api.ToolEfficiency;
import willatendo.wtfit.server.utils.WTFITUtils;

public final class EfficiencyRegistries {
    private static final Map<ResourceLocation, ResourceEfficiency> RESOURCE_EFFICIENCIES = new HashMap<ResourceLocation, ResourceEfficiency>();
    private static final Map<ResourceLocation, Function<BlockState, Boolean>> RESOURCE_EFFICIENCY_TO_APPLICATION = new HashMap<ResourceLocation, Function<BlockState, Boolean>>();
    private static final Map<ResourceLocation, ToolEfficiency> TOOL_EFFICIENCIES = new HashMap<ResourceLocation, ToolEfficiency>();
    private static final Map<ResourceLocation, Function<BlockState, Boolean>> TOOL_EFFICIENCY_TO_APPLICATION = new HashMap<ResourceLocation, Function<BlockState, Boolean>>();

    public static ResourceEfficiency registerResourceEfficiency(ResourceLocation resourceLocation, Function<BlockState, Boolean> apply) {
        if (RESOURCE_EFFICIENCIES.containsKey(resourceLocation)) {
            throw new Error("Resource Efficiency ID conflict! " + String.valueOf(resourceLocation));
        }
        ResourceEfficiency resourceEfficiency = new ResourceEfficiency();
        RESOURCE_EFFICIENCIES.put(resourceLocation, resourceEfficiency);
        RESOURCE_EFFICIENCY_TO_APPLICATION.put(resourceLocation, apply);
        return resourceEfficiency;
    }

    public static ToolEfficiency registerToolEfficiency(ResourceLocation resourceLocation, Function<BlockState, Boolean> apply) {
        if (TOOL_EFFICIENCIES.containsKey(resourceLocation)) {
            throw new Error("Tool Efficiency ID conflict! " + String.valueOf(resourceLocation));
        }
        ToolEfficiency toolEfficiency = new ToolEfficiency();
        TOOL_EFFICIENCIES.put(resourceLocation, toolEfficiency);
        TOOL_EFFICIENCY_TO_APPLICATION.put(resourceLocation, apply);
        return toolEfficiency;
    }

    public static List<ResourceLocation> resourceEfficiencies() {
        return RESOURCE_EFFICIENCIES.keySet().stream().filter(resourceLocation -> !Objects.equals(resourceLocation, WTFITUtils.mc("any"))).toList();
    }

    public static ResourceEfficiency getResourceEfficiency(ResourceLocation resourceLocation) {
        return RESOURCE_EFFICIENCIES.get(resourceLocation);
    }

    public static Function<BlockState, Boolean> getResourceEfficiencyApplication(ResourceLocation resourceLocation) {
        return RESOURCE_EFFICIENCY_TO_APPLICATION.get(resourceLocation);
    }

    public static List<ResourceLocation> toolEfficiencies() {
        return TOOL_EFFICIENCIES.keySet().stream().toList();
    }

    public static ToolEfficiency getToolEfficiency(ResourceLocation resourceLocation) {
        return TOOL_EFFICIENCIES.get(resourceLocation);
    }

    public static Function<BlockState, Boolean> getToolEfficiencyApplication(ResourceLocation resourceLocation) {
        return TOOL_EFFICIENCY_TO_APPLICATION.get(resourceLocation);
    }
}

