/*
 * Decompiled with CFR 0.152.
 */
package willatendo.wtfit.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import willatendo.wtfit.api.EfficiencyRegistries;
import willatendo.wtfit.api.ResourceEfficiency;
import willatendo.wtfit.api.ToolEfficiency;
import willatendo.wtfit.client.VanillaBootstrap;

public final class Tools {
    private static final Map<Pair<ToolEfficiency, ResourceEfficiency>, DrawTool> EFFICIENCY_TO_TOOL = new HashMap<Pair<ToolEfficiency, ResourceEfficiency>, DrawTool>();

    public static void registerItemStack(ToolEfficiency toolEfficiency, ResourceEfficiency resourceEfficiency, Supplier<ItemStack> toolItemStack) {
        EFFICIENCY_TO_TOOL.put((Pair<ToolEfficiency, ResourceEfficiency>)Pair.of((Object)toolEfficiency, (Object)resourceEfficiency), (guiGraphics, x, y) -> guiGraphics.renderItem((ItemStack)toolItemStack.get(), x, y));
    }

    public static void registerSprite(ToolEfficiency toolEfficiency, ResourceEfficiency resourceEfficiency, ResourceLocation sprite) {
        EFFICIENCY_TO_TOOL.put((Pair<ToolEfficiency, ResourceEfficiency>)Pair.of((Object)toolEfficiency, (Object)resourceEfficiency), (guiGraphics, x, y) -> guiGraphics.blitSprite(RenderType::guiTextured, sprite, x, y, 16, 16));
    }

    public static boolean has(ToolEfficiency toolEfficiency, ResourceEfficiency resourceEfficiency) {
        return EFFICIENCY_TO_TOOL.containsKey(Pair.of((Object)toolEfficiency, (Object)resourceEfficiency));
    }

    public static DrawTool get(ToolEfficiency toolEfficiency, ResourceEfficiency resourceEfficiency) {
        return EFFICIENCY_TO_TOOL.get(Pair.of((Object)toolEfficiency, (Object)resourceEfficiency));
    }

    public static List<ToolEfficiency> applyTools(BlockState blockState) {
        ArrayList<ToolEfficiency> efficiencies = new ArrayList<ToolEfficiency>();
        for (ResourceLocation resourceLocation : EfficiencyRegistries.toolEfficiencies()) {
            if (!EfficiencyRegistries.getToolEfficiencyApplication(resourceLocation).apply(blockState).booleanValue()) continue;
            efficiencies.add(EfficiencyRegistries.getToolEfficiency(resourceLocation));
        }
        return efficiencies;
    }

    public static ResourceEfficiency applyResources(BlockState blockState) {
        for (ResourceLocation resourceLocation : EfficiencyRegistries.resourceEfficiencies()) {
            if (!EfficiencyRegistries.getResourceEfficiencyApplication(resourceLocation).apply(blockState).booleanValue()) continue;
            return EfficiencyRegistries.getResourceEfficiency(resourceLocation);
        }
        return blockState.requiresCorrectToolForDrops() ? VanillaBootstrap.WOOD : VanillaBootstrap.ANY;
    }

    public static interface DrawTool {
        public void drawTool(GuiGraphics var1, int var2, int var3);
    }
}

