/*
 * Decompiled with CFR 0.152.
 */
package willatendo.wtfit.client;

import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import willatendo.wtfit.api.BlockOverrides;
import willatendo.wtfit.api.EfficiencyRegistries;
import willatendo.wtfit.api.ResourceEfficiency;
import willatendo.wtfit.api.ToolEfficiency;
import willatendo.wtfit.api.Tools;
import willatendo.wtfit.platform.WTFITModloaderHelper;
import willatendo.wtfit.server.utils.WTFITUtils;

public final class VanillaBootstrap {
    public static final ResourceEfficiency WOOD = EfficiencyRegistries.registerResourceEfficiency(WTFITUtils.mc("wood"), WTFITModloaderHelper.INSTANCE::needsWoodTool);
    public static final ResourceEfficiency STONE = EfficiencyRegistries.registerResourceEfficiency(WTFITUtils.mc("stone"), blockState -> blockState.is(BlockTags.NEEDS_STONE_TOOL));
    public static final ResourceEfficiency IRON = EfficiencyRegistries.registerResourceEfficiency(WTFITUtils.mc("iron"), blockState -> blockState.is(BlockTags.NEEDS_IRON_TOOL));
    public static final ResourceEfficiency GOLD = EfficiencyRegistries.registerResourceEfficiency(WTFITUtils.mc("gold"), WTFITModloaderHelper.INSTANCE::needsGoldTool);
    public static final ResourceEfficiency DIAMOND = EfficiencyRegistries.registerResourceEfficiency(WTFITUtils.mc("diamond"), blockState -> blockState.is(BlockTags.NEEDS_DIAMOND_TOOL));
    public static final ResourceEfficiency NETHERITE = EfficiencyRegistries.registerResourceEfficiency(WTFITUtils.mc("netherite"), WTFITModloaderHelper.INSTANCE::needsNetheriteTool);
    public static final ResourceEfficiency ANY = EfficiencyRegistries.registerResourceEfficiency(WTFITUtils.mc("any"), blockState -> true);
    public static final ToolEfficiency SWORD = EfficiencyRegistries.registerToolEfficiency(WTFITUtils.mc("sword"), blockState -> blockState.is(BlockTags.SWORD_EFFICIENT));
    public static final ToolEfficiency PICKAXE = EfficiencyRegistries.registerToolEfficiency(WTFITUtils.mc("pickaxe"), blockState -> blockState.is(BlockTags.MINEABLE_WITH_PICKAXE));
    public static final ToolEfficiency AXE = EfficiencyRegistries.registerToolEfficiency(WTFITUtils.mc("axe"), blockState -> blockState.is(BlockTags.MINEABLE_WITH_AXE));
    public static final ToolEfficiency SHOVEL = EfficiencyRegistries.registerToolEfficiency(WTFITUtils.mc("shovel"), blockState -> blockState.is(BlockTags.MINEABLE_WITH_SHOVEL));
    public static final ToolEfficiency HOE = EfficiencyRegistries.registerToolEfficiency(WTFITUtils.mc("hoe"), blockState -> blockState.is(BlockTags.MINEABLE_WITH_HOE));
    public static final ToolEfficiency SHEARS = EfficiencyRegistries.registerToolEfficiency(WTFITUtils.mc("shears"), blockState -> blockState.is(BlockTags.LEAVES) || blockState.is(Blocks.COBWEB) || blockState.is(Blocks.SHORT_GRASS) || blockState.is(Blocks.FERN) || blockState.is(Blocks.DEAD_BUSH) || blockState.is(Blocks.HANGING_ROOTS) || blockState.is(Blocks.VINE) || blockState.is(Blocks.TRIPWIRE) || blockState.is(BlockTags.WOOL));

    public static void initVanilla() {
        Tools.registerItemStack(SWORD, WOOD, () -> new ItemStack((ItemLike)Items.WOODEN_SWORD));
        Tools.registerItemStack(SWORD, STONE, () -> new ItemStack((ItemLike)Items.STONE_SWORD));
        Tools.registerItemStack(SWORD, IRON, () -> new ItemStack((ItemLike)Items.IRON_SWORD));
        Tools.registerItemStack(SWORD, GOLD, () -> new ItemStack((ItemLike)Items.GOLDEN_SWORD));
        Tools.registerItemStack(SWORD, DIAMOND, () -> new ItemStack((ItemLike)Items.DIAMOND_SWORD));
        Tools.registerItemStack(SWORD, NETHERITE, () -> new ItemStack((ItemLike)Items.NETHERITE_SWORD));
        Tools.registerSprite(SWORD, ANY, SmithingTemplateItem.EMPTY_SLOT_SWORD);
        Tools.registerItemStack(PICKAXE, WOOD, () -> new ItemStack((ItemLike)Items.WOODEN_PICKAXE));
        Tools.registerItemStack(PICKAXE, STONE, () -> new ItemStack((ItemLike)Items.STONE_PICKAXE));
        Tools.registerItemStack(PICKAXE, IRON, () -> new ItemStack((ItemLike)Items.IRON_PICKAXE));
        Tools.registerItemStack(PICKAXE, GOLD, () -> new ItemStack((ItemLike)Items.GOLDEN_PICKAXE));
        Tools.registerItemStack(PICKAXE, DIAMOND, () -> new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        Tools.registerItemStack(PICKAXE, NETHERITE, () -> new ItemStack((ItemLike)Items.NETHERITE_PICKAXE));
        Tools.registerSprite(PICKAXE, ANY, SmithingTemplateItem.EMPTY_SLOT_PICKAXE);
        Tools.registerItemStack(AXE, WOOD, () -> new ItemStack((ItemLike)Items.WOODEN_AXE));
        Tools.registerItemStack(AXE, STONE, () -> new ItemStack((ItemLike)Items.STONE_AXE));
        Tools.registerItemStack(AXE, IRON, () -> new ItemStack((ItemLike)Items.IRON_AXE));
        Tools.registerItemStack(AXE, GOLD, () -> new ItemStack((ItemLike)Items.GOLDEN_AXE));
        Tools.registerItemStack(AXE, DIAMOND, () -> new ItemStack((ItemLike)Items.DIAMOND_AXE));
        Tools.registerItemStack(AXE, NETHERITE, () -> new ItemStack((ItemLike)Items.NETHERITE_AXE));
        Tools.registerSprite(AXE, ANY, SmithingTemplateItem.EMPTY_SLOT_AXE);
        Tools.registerItemStack(SHOVEL, WOOD, () -> new ItemStack((ItemLike)Items.WOODEN_SHOVEL));
        Tools.registerItemStack(SHOVEL, STONE, () -> new ItemStack((ItemLike)Items.STONE_SHOVEL));
        Tools.registerItemStack(SHOVEL, IRON, () -> new ItemStack((ItemLike)Items.IRON_SHOVEL));
        Tools.registerItemStack(SHOVEL, GOLD, () -> new ItemStack((ItemLike)Items.GOLDEN_SHOVEL));
        Tools.registerItemStack(SHOVEL, DIAMOND, () -> new ItemStack((ItemLike)Items.DIAMOND_SHOVEL));
        Tools.registerItemStack(SHOVEL, NETHERITE, () -> new ItemStack((ItemLike)Items.NETHERITE_SHOVEL));
        Tools.registerSprite(SHOVEL, ANY, SmithingTemplateItem.EMPTY_SLOT_SHOVEL);
        Tools.registerItemStack(HOE, WOOD, () -> new ItemStack((ItemLike)Items.WOODEN_HOE));
        Tools.registerItemStack(HOE, STONE, () -> new ItemStack((ItemLike)Items.STONE_HOE));
        Tools.registerItemStack(HOE, IRON, () -> new ItemStack((ItemLike)Items.IRON_HOE));
        Tools.registerItemStack(HOE, GOLD, () -> new ItemStack((ItemLike)Items.GOLDEN_HOE));
        Tools.registerItemStack(HOE, DIAMOND, () -> new ItemStack((ItemLike)Items.DIAMOND_HOE));
        Tools.registerItemStack(HOE, NETHERITE, () -> new ItemStack((ItemLike)Items.NETHERITE_HOE));
        Tools.registerSprite(HOE, ANY, SmithingTemplateItem.EMPTY_SLOT_HOE);
        Tools.registerSprite(SHEARS, ANY, WTFITUtils.resource("container/slot/shears"));
        BlockOverrides.registerIconOverride(Blocks.POTTED_TORCHFLOWER, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_OAK_SAPLING, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_SPRUCE_SAPLING, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_BIRCH_SAPLING, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_JUNGLE_SAPLING, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_ACACIA_SAPLING, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_CHERRY_SAPLING, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_DARK_OAK_SAPLING, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_PALE_OAK_SAPLING, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_MANGROVE_PROPAGULE, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_FERN, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_DANDELION, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_POPPY, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_BLUE_ORCHID, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_ALLIUM, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_AZURE_BLUET, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_RED_TULIP, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_ORANGE_TULIP, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_WHITE_TULIP, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_PINK_TULIP, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_OXEYE_DAISY, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_CORNFLOWER, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_LILY_OF_THE_VALLEY, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_WITHER_ROSE, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_RED_MUSHROOM, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_BROWN_MUSHROOM, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_DEAD_BUSH, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_BAMBOO, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_CRIMSON_FUNGUS, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_WARPED_FUNGUS, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_CRIMSON_ROOTS, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_WARPED_ROOTS, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_AZALEA, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_FLOWERING_AZALEA, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_OPEN_EYEBLOSSOM, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_CLOSED_EYEBLOSSOM, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.POTTED_CACTUS, new ItemStack((ItemLike)Items.FLOWER_POT));
        BlockOverrides.registerIconOverride(Blocks.CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.RED_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.WHITE_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.ORANGE_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.MAGENTA_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.LIGHT_BLUE_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.YELLOW_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.LIME_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.PINK_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.GRAY_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.LIGHT_GRAY_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.CYAN_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.PURPLE_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.BLUE_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.BROWN_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.GREEN_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.RED_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.BLACK_CANDLE_CAKE, new ItemStack((ItemLike)Items.CAKE));
        BlockOverrides.registerIconOverride(Blocks.PISTON_HEAD, new ItemStack((ItemLike)Items.PISTON));
        BlockOverrides.registerIconOverride(Blocks.TALL_SEAGRASS, new ItemStack((ItemLike)Items.SEAGRASS));
        BlockOverrides.registerIconOverride(Blocks.KELP_PLANT, new ItemStack((ItemLike)Items.KELP));
    }
}

