/*
 * Decompiled with CFR 0.152.
 */
package willatendo.wtfit.client;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import willatendo.wtfit.api.BlockOverrides;
import willatendo.wtfit.api.ResourceEfficiency;
import willatendo.wtfit.api.ToolEfficiency;
import willatendo.wtfit.api.Tools;
import willatendo.wtfit.platform.WTFITModloaderHelper;

public class WhatTheFuckIsThatLayer
implements LayeredDraw.Layer {
    private static final ResourceLocation BAR_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"boss_bar/red_background");
    private static final ResourceLocation BAR_PROGRESS = ResourceLocation.withDefaultNamespace((String)"boss_bar/red_progress");

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        HitResult hitResult;
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.options.hideGui && (hitResult = minecraft.hitResult) != null && hitResult.getType() != HitResult.Type.MISS) {
            Font font = minecraft.font;
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                BlockState blockState = minecraft.level.getBlockState(blockHitResult.getBlockPos());
                ItemStack itemStack = BlockOverrides.overrideIconOrDefault(blockState.getBlock());
                if (!itemStack.isEmpty()) {
                    List<ToolEfficiency> toolEfficiencies = Tools.applyTools(blockState);
                    String namespace = WTFITModloaderHelper.INSTANCE.getModName(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getNamespace());
                    this.renderWTF(guiGraphics, font, itemStack, itemStack.getHoverName(), namespace, toolEfficiencies.size() * 21, 0, (fullWidth, leftPos, drawnLeftPos, topPos, drawnTopPos) -> {
                        ResourceEfficiency resourceEfficiency = Tools.applyResources(blockState);
                        for (int i = 0; i < toolEfficiencies.size(); ++i) {
                            if (!Tools.has((ToolEfficiency)toolEfficiencies.get(i), resourceEfficiency)) continue;
                            Tools.get((ToolEfficiency)toolEfficiencies.get(i), resourceEfficiency).drawTool(guiGraphics, drawnLeftPos + 5 + i * 21, 6);
                        }
                    });
                }
            } else if (hitResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                Entity entity = entityHitResult.getEntity();
                String namespace = WTFITModloaderHelper.INSTANCE.getModName(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).getNamespace());
                ItemStack spawnEggItemStack = entity.getPickResult();
                if (spawnEggItemStack == null) {
                    spawnEggItemStack = new ItemStack((ItemLike)Items.BARRIER);
                }
                this.renderWTF(guiGraphics, font, spawnEggItemStack, entity.getDisplayName(), namespace, 0, 5, (fullWidth, leftPos, drawnLeftPos, topPos, drawnTopPos) -> {
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        this.drawBar(guiGraphics, drawnTopPos + 2, fullWidth, Mth.clamp((float)(livingEntity.getHealth() / livingEntity.getMaxHealth()), (float)0.0f, (float)1.0f));
                    }
                });
            }
        }
    }

    private void renderWTF(GuiGraphics guiGraphics, Font font, ItemStack displayItemStack, Component name, String modName, int extraWidth, int extraHeight, DrawExtra drawExtra) {
        int nameWidth = font.width((FormattedText)name);
        int nameSpaceWidth = font.width(modName);
        int requiredWidth = Math.max(nameWidth, nameSpaceWidth);
        Objects.requireNonNull(font);
        int requiredHeight = 9 * 2;
        int screenCenter = guiGraphics.guiWidth() / 2;
        int fullWidth = requiredWidth + 21 + extraWidth;
        int fullHeight = requiredHeight + extraHeight;
        int leftPos = screenCenter - fullWidth / 2;
        int topPos = 5;
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)leftPos, (int)topPos, (int)fullWidth, (int)fullHeight, (int)0, null);
        guiGraphics.renderItem(displayItemStack, leftPos, topPos + 1);
        guiGraphics.drawCenteredString(font, name, leftPos + requiredWidth / 2 + 21, topPos, 0xFFFFFF);
        guiGraphics.drawCenteredString(font, modName, leftPos + requiredWidth / 2 + 21, topPos + 11, 0x5555FF);
        drawExtra.drawExtra(fullWidth, leftPos, leftPos + requiredWidth + 21, topPos, topPos + requiredHeight);
    }

    private void drawBar(GuiGraphics guiGraphics, int y, int width, float health) {
        int finalWidth = Math.min(width, 182);
        int x = guiGraphics.guiWidth() / 2 - finalWidth / 2;
        guiGraphics.blitSprite(RenderType::guiTextured, BAR_BACKGROUND, 182, 5, 0, 0, x, y, finalWidth - 4, 5);
        guiGraphics.blitSprite(RenderType::guiTextured, BAR_BACKGROUND, 182, 5, 178, 0, x + finalWidth - 4, y, 4, 5);
        int progress = Mth.lerpDiscrete((float)health, (int)0, (int)finalWidth);
        if (progress > 0) {
            this.drawBar(guiGraphics, x, y, progress, finalWidth, BAR_PROGRESS);
        }
    }

    private void drawBar(GuiGraphics guiGraphics, int x, int y, int progress, int finalWidth, ResourceLocation barProgressSprites) {
        boolean finalStretch = progress > finalWidth - 4;
        guiGraphics.blitSprite(RenderType::guiTextured, barProgressSprites, 182, 5, 0, 0, x, y, finalStretch ? finalWidth - 4 : progress, 5);
        if (finalStretch) {
            int finalProgress = progress + 4 - finalWidth;
            guiGraphics.blitSprite(RenderType::guiTextured, barProgressSprites, 182, 5, 178, 0, x + finalWidth - 4, y, finalProgress, 5);
        }
    }

    @FunctionalInterface
    static interface DrawExtra {
        public void drawExtra(int var1, int var2, int var3, int var4, int var5);
    }
}

