/*
 * Decompiled with CFR 0.152.
 */
package willatendo.wtfit.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import willatendo.wtfit.api.ResourceEfficiency;
import willatendo.wtfit.api.ToolEfficiency;
import willatendo.wtfit.server.utils.WTFITUtils;

public final class EfficiencyRegistries {
    private static final Map<class_2960, ResourceEfficiency> RESOURCE_EFFICIENCIES = new HashMap<class_2960, ResourceEfficiency>();
    private static final Map<class_2960, Function<class_2680, Boolean>> RESOURCE_EFFICIENCY_TO_APPLICATION = new HashMap<class_2960, Function<class_2680, Boolean>>();
    private static final Map<class_2960, ToolEfficiency> TOOL_EFFICIENCIES = new HashMap<class_2960, ToolEfficiency>();
    private static final Map<class_2960, Function<class_2680, Boolean>> TOOL_EFFICIENCY_TO_APPLICATION = new HashMap<class_2960, Function<class_2680, Boolean>>();

    public static ResourceEfficiency registerResourceEfficiency(class_2960 resourceLocation, Function<class_2680, Boolean> apply) {
        if (RESOURCE_EFFICIENCIES.containsKey(resourceLocation)) {
            throw new Error("Resource Efficiency ID conflict! " + String.valueOf(resourceLocation));
        }
        ResourceEfficiency resourceEfficiency = new ResourceEfficiency();
        RESOURCE_EFFICIENCIES.put(resourceLocation, resourceEfficiency);
        RESOURCE_EFFICIENCY_TO_APPLICATION.put(resourceLocation, apply);
        return resourceEfficiency;
    }

    public static ToolEfficiency registerToolEfficiency(class_2960 resourceLocation, Function<class_2680, Boolean> apply) {
        if (TOOL_EFFICIENCIES.containsKey(resourceLocation)) {
            throw new Error("Tool Efficiency ID conflict! " + String.valueOf(resourceLocation));
        }
        ToolEfficiency toolEfficiency = new ToolEfficiency();
        TOOL_EFFICIENCIES.put(resourceLocation, toolEfficiency);
        TOOL_EFFICIENCY_TO_APPLICATION.put(resourceLocation, apply);
        return toolEfficiency;
    }

    public static List<class_2960> resourceEfficiencies() {
        return RESOURCE_EFFICIENCIES.keySet().stream().filter(resourceLocation -> !Objects.equals(resourceLocation, WTFITUtils.mc("any"))).toList();
    }

    public static ResourceEfficiency getResourceEfficiency(class_2960 resourceLocation) {
        return RESOURCE_EFFICIENCIES.get(resourceLocation);
    }

    public static Function<class_2680, Boolean> getResourceEfficiencyApplication(class_2960 resourceLocation) {
        return RESOURCE_EFFICIENCY_TO_APPLICATION.get(resourceLocation);
    }

    public static List<class_2960> toolEfficiencies() {
        return TOOL_EFFICIENCIES.keySet().stream().toList();
    }

    public static ToolEfficiency getToolEfficiency(class_2960 resourceLocation) {
        return TOOL_EFFICIENCIES.get(resourceLocation);
    }

    public static Function<class_2680, Boolean> getToolEfficiencyApplication(class_2960 resourceLocation) {
        return TOOL_EFFICIENCY_TO_APPLICATION.get(resourceLocation);
    }
}

