/*
 * Decompiled with CFR 0.152.
 */
package com.movtery.visibleoffhand.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.movtery.visibleoffhand.VisibleOffhand;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;

public class Config {
    private static Options options = null;
    private final File file;
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public Config(File file) {
        this.file = file;
    }

    public Options getOptions() {
        return options;
    }

    public void load() {
        if (this.file.exists()) {
            try {
                options = (Options)this.GSON.fromJson((Reader)Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8), Options.class);
            }
            catch (IOException e) {
                VisibleOffhand.LOGGER.error("Error loading config");
            }
        }
        if (options == null) {
            options = new Options();
            this.save();
        }
    }

    public void save() {
        try {
            Files.write(this.file.toPath(), Collections.singleton(this.GSON.toJson((Object)options)), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            VisibleOffhand.LOGGER.error("Error saving config");
        }
    }

    public static class Options {
        public boolean doubleHands = true;
        public List<String> handheldItems = List.of("minecraft:filled_map");
    }
}

