/*
 * Decompiled with CFR 0.152.
 */
package com.movtery.visibleoffhand;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import com.movtery.visibleoffhand.config.Config;
import com.movtery.visibleoffhand.screen.RegisterModsPage;
import java.io.File;
import java.nio.file.Path;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.DistExecutor;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.jarjar.nio.util.Lazy;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import org.slf4j.Logger;

@Mod(value="visible_offhand")
public class VisibleOffhand {
    public static final String MODID = "visible_offhand";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Lazy<KeyMapping> KEY_DOUBLE_HANDS = Lazy.of(() -> new KeyMapping("button.vo.double_hands", InputConstants.Type.KEYSYM, -1, "mod.vo.name"));
    private static Config config = null;

    public VisibleOffhand(IEventBus modEventBus) {
        modEventBus.addListener(this::commonSetup);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> RegisterModsPage::registerModsPage);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public static Config getConfig() {
        if (config == null) {
            VisibleOffhand.loadConfig();
        }
        return config;
    }

    private static void loadConfig() {
        Path configPath = FMLLoader.getGamePath();
        File configFile = new File(configPath.toFile() + "/config/", "visible_offhand.json");
        config = new Config(configFile);
        config.load();
    }

    public static void reloadConfig() {
        if (config == null) {
            VisibleOffhand.loadConfig();
        }
        config.load();
        LOGGER.info("The configuration file has been reloaded!");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (((KeyMapping)KEY_DOUBLE_HANDS.get()).consumeClick()) {
                VisibleOffhand.getConfig().getOptions().doubleHands = !VisibleOffhand.getConfig().getOptions().doubleHands;
                VisibleOffhand.getConfig().save();
                if (Minecraft.getInstance().player == null) continue;
                MutableComponent component = VisibleOffhand.getConfig().getOptions().doubleHands ? Component.translatable((String)"button.vo.double_hands").append(" : ").append((Component)Component.translatable((String)"button.vo.on")) : Component.translatable((String)"button.vo.double_hands").append(" : ").append((Component)Component.translatable((String)"button.vo.off"));
                Minecraft.getInstance().player.displayClientMessage((Component)component, true);
            }
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"visibleoffhand").then(Commands.literal((String)"reload").executes(context -> {
            VisibleOffhand.reloadConfig();
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)"config.vo.reloaded"));
            return 1;
        })));
    }

    @Mod.EventBusSubscriber(modid="visible_offhand", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            if (config == null) {
                VisibleOffhand.loadConfig();
                LOGGER.info("Config file not found, has been regenerated");
            }
        }

        @SubscribeEvent
        public static void registerBindings(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)KEY_DOUBLE_HANDS.get());
        }
    }
}

