/*
 * Decompiled with CFR 0.152.
 */
package com.movtery.visible_offhand;

import com.mojang.logging.LogUtils;
import com.movtery.visible_offhand.config.Config;
import java.io.File;
import java.nio.file.Path;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@Mod(value="visible_offhand")
public class VisibleOffhand {
    public static final String MODID = "visible_offhand";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final KeyMapping KEY_DOUBLE_HANDS = new KeyMapping("button.vo.double_hands", -1, "mod.vo.name");
    private static Config config = null;

    public VisibleOffhand() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ClientRegistry.registerKeyBinding((KeyMapping)KEY_DOUBLE_HANDS);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static Config getConfig() {
        if (config == null) {
            VisibleOffhand.loadConfig();
        }
        return config;
    }

    private static void loadConfig() {
        Path configPath = FMLLoader.getGamePath();
        File configFile = new File(configPath.toFile() + "/config/", "visible_offhand.json");
        config = new Config(configFile);
        config.load();
    }

    public static void reloadConfig() {
        if (config == null) {
            VisibleOffhand.loadConfig();
        }
        config.load();
        LOGGER.info("The configuration file has been reloaded!");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (KEY_DOUBLE_HANDS.m_90859_()) {
                VisibleOffhand.getConfig().getOptions().doubleHands = !VisibleOffhand.getConfig().getOptions().doubleHands;
                VisibleOffhand.getConfig().save();
                if (Minecraft.m_91087_().f_91074_ == null) continue;
                MutableComponent component = VisibleOffhand.getConfig().getOptions().doubleHands ? new TranslatableComponent("button.vo.double_hands").m_130946_(" : ").m_7220_((Component)new TranslatableComponent("button.vo.on")) : new TranslatableComponent("button.vo.double_hands").m_130946_(" : ").m_7220_((Component)new TranslatableComponent("button.vo.off"));
                Minecraft.m_91087_().f_91074_.m_5661_((Component)component, true);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="visible_offhand", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            if (config == null) {
                VisibleOffhand.loadConfig();
                LOGGER.info("Config file not found, has been regenerated");
            }
        }
    }
}

