/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.input;

import net.minecraft.client.player.Input;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PlayerInputState(float leftImpulse, float forwardImpulse, boolean up, boolean down, boolean left, boolean right, boolean jumping, boolean sneaking) {
    public static PlayerInputState fromVanillaInput(Input input) {
        return new PlayerInputState(input.leftImpulse, input.forwardImpulse, input.up, input.down, input.left, input.right, input.jumping, input.shiftKeyDown);
    }

    public static Input applyToVanillaInput(@NotNull PlayerInputState updated, @NotNull Input input) {
        if (input.leftImpulse != updated.leftImpulse()) {
            input.leftImpulse = updated.leftImpulse();
        }
        if (input.forwardImpulse != updated.forwardImpulse()) {
            input.forwardImpulse = updated.forwardImpulse();
        }
        if (input.up != updated.up()) {
            input.up = updated.up();
        }
        if (input.down != updated.down()) {
            input.down = updated.down();
        }
        if (input.left != updated.left()) {
            input.left = updated.left();
        }
        if (input.right != updated.right()) {
            input.right = updated.right();
        }
        if (input.jumping != updated.jumping()) {
            input.jumping = updated.jumping();
        }
        if (input.shiftKeyDown != updated.sneaking()) {
            input.shiftKeyDown = updated.sneaking();
        }
        return input;
    }

    public Vec2 getMoveVector() {
        return new Vec2(this.leftImpulse, this.forwardImpulse);
    }

    public boolean hasForwardImpulse() {
        return this.forwardImpulse > 1.0E-5f;
    }

    @NotNull
    public PlayerInputState copyWith(@Nullable Float leftImpulse, @Nullable Float forwardImpulse, @Nullable Boolean up, @Nullable Boolean down, @Nullable Boolean left, @Nullable Boolean right, @Nullable Boolean jumping, @Nullable Boolean sneaking) {
        return new PlayerInputState(leftImpulse != null ? leftImpulse.floatValue() : this.leftImpulse, forwardImpulse != null ? forwardImpulse.floatValue() : this.forwardImpulse, up != null ? up : this.up, down != null ? down : this.down, left != null ? left : this.left, right != null ? right : this.right, jumping != null ? jumping : this.jumping, sneaking != null ? sneaking : this.sneaking);
    }

    @NotNull
    public PlayerInputState withLeftImpulse(float leftImpulse) {
        return this.copyWith(Float.valueOf(leftImpulse), null, null, null, null, null, null, null);
    }

    @NotNull
    public PlayerInputState withForwardImpulse(float forwardImpulse) {
        return this.copyWith(null, Float.valueOf(forwardImpulse), null, null, null, null, null, null);
    }

    @NotNull
    public PlayerInputState withUp(boolean up) {
        return this.copyWith(null, null, up, null, null, null, null, null);
    }

    @NotNull
    public PlayerInputState withDown(boolean down) {
        return this.copyWith(null, null, null, down, null, null, null, null);
    }

    @NotNull
    public PlayerInputState withLeft(boolean left) {
        return this.copyWith(null, null, null, null, left, null, null, null);
    }

    @NotNull
    public PlayerInputState withRight(boolean right) {
        return this.copyWith(null, null, null, null, null, right, null, null);
    }

    @NotNull
    public PlayerInputState withJumping(boolean jumping) {
        return this.copyWith(null, null, null, null, null, null, jumping, null);
    }

    @NotNull
    public PlayerInputState withSneaking(boolean sneaking) {
        return this.copyWith(null, null, null, null, null, null, null, sneaking);
    }
}

