/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.event;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class EventContext {
    private List<String> calledBy = new ArrayList<String>();
    private List<String> canceledBy = new ArrayList<String>();
    @Nullable
    private String currentSubscriber;

    public boolean isCanceled() {
        return !this.canceledBy.isEmpty();
    }

    public boolean isCanceledBy(String name) {
        return this.canceledBy.contains(name);
    }

    public boolean hasCalledBy(String name) {
        return this.calledBy.contains(name);
    }

    @ApiStatus.Internal
    public void onCalled() {
        this.calledBy.add(this.currentSubscriber);
    }

    @ApiStatus.Internal
    public void onCanceled() {
        this.canceledBy.add(this.currentSubscriber);
    }

    @ApiStatus.Internal
    public void subscriptionStart(String name) {
        this.currentSubscriber = name;
    }

    @ApiStatus.Internal
    public void subscriptionEnd() {
        this.currentSubscriber = null;
    }
}

