/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.Tags;
import yesman.epicfight.client.gui.EntityUI;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.effect.VisibleMobEffect;

public class HealthBar
extends EntityUI {
    public static final ResourceLocation HEALTHBARS1 = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/healthbars1.png");
    public static final ResourceLocation HEALTHBARS2 = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/healthbars2.png");
    private final Map<LivingEntity, EntityAttributeTracker> trackingEntities = Maps.newConcurrentMap();

    @Override
    public boolean shouldDraw(LivingEntity entity, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch, float partialTicks) {
        ClientConfig.HealthBarVisibility healthBarVisibility = ClientConfig.healthBarVisibility;
        Minecraft mc = Minecraft.getInstance();
        if (healthBarVisibility == ClientConfig.HealthBarVisibility.NONE) {
            return false;
        }
        if (entity.getType().is(Tags.EntityTypes.BOSSES)) {
            return false;
        }
        EntityAttributeTracker healthTracker = this.trackingEntities.computeIfAbsent(entity, key -> new EntityAttributeTracker(this, (LivingEntity)key, entitypatch));
        healthTracker.checkChange(partialTicks);
        healthTracker.setKeepUp(true);
        if (entity.isInvisibleTo((Player)playerpatch.getOriginal()) || entity == ((LocalPlayer)playerpatch.getOriginal()).getVehicle()) {
            return false;
        }
        if (entity.distanceToSqr(mc.getCameraEntity()) >= 400.0) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player == playerpatch.getOriginal() && playerpatch.getMaxStunShield() <= 0.0f) {
                return false;
            }
            if (player.isCreative() || player.isSpectator()) {
                return false;
            }
        }
        boolean showTarget = false;
        if (healthBarVisibility == ClientConfig.HealthBarVisibility.TARGET) {
            return playerpatch.getTarget() == entity;
        }
        if (healthBarVisibility == ClientConfig.HealthBarVisibility.TARGET_AND_HURT) {
            showTarget = playerpatch.getTarget() == entity;
        }
        return (!entity.getActiveEffects().isEmpty() || entity.getHealth() < entity.getMaxHealth() || showTarget) && !entity.isRemoved();
    }

    @Override
    public void draw(LivingEntity entity, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch, PoseStack poseStack, MultiBufferSource buffers, float partialTicks) {
        float healthEnd;
        int damageColor;
        int textureIndex;
        ResourceLocation healthBarTexture;
        poseStack.pushPose();
        HealthBar.setupPoseStack(poseStack, entity, 0.0f, entity.getBbHeight() + 0.25f, 0.0f, true, partialTicks);
        Collection activeEffects = entity.getActiveEffects();
        if (!activeEffects.isEmpty() && !entity.is(playerpatch.getOriginal())) {
            Iterator iter = activeEffects.iterator();
            int acives = activeEffects.size();
            int row = acives > 1 ? 1 : 0;
            int column = (acives - 1) / 2;
            float startX = -0.8f + -0.3f * (float)row;
            float startY = -0.15f + 0.15f * (float)column;
            block0: for (int i = 0; i <= column; ++i) {
                for (int j = 0; j <= row; ++j) {
                    ResourceLocation rl;
                    MobEffectInstance effectInstance = (MobEffectInstance)iter.next();
                    MobEffect effect = (MobEffect)effectInstance.getEffect().value();
                    if (effect instanceof VisibleMobEffect) {
                        VisibleMobEffect visibleMobEffect = (VisibleMobEffect)effect;
                        rl = visibleMobEffect.getIcon(effectInstance);
                    } else {
                        rl = ResourceLocation.fromNamespaceAndPath((String)BuiltInRegistries.MOB_EFFECT.getKey((Object)effect).getNamespace(), (String)("textures/mob_effect/" + BuiltInRegistries.MOB_EFFECT.getKey((Object)effect).getPath() + ".png"));
                    }
                    float x = startX + 0.3f * (float)j;
                    float y = startY + -0.3f * (float)i;
                    HealthBar.drawUIAsLevelModel(poseStack.last(), rl, buffers, x, y, x + 0.3f, y + 0.3f, 0, 0, 256, 256, 256);
                    if (!iter.hasNext()) continue block0;
                }
            }
        }
        EntityAttributeTracker attributeTracker = this.trackingEntities.get(entity);
        if (entitypatch != null) {
            Faction faction = entitypatch.getFaction();
            healthBarTexture = faction.healthBarTexture();
            textureIndex = faction.healthBarIndex();
            damageColor = faction.damageColor();
        } else {
            healthBarTexture = HEALTHBARS2;
            textureIndex = 0;
            damageColor = -65536;
        }
        int texV = textureIndex * 10;
        float healthBarHeight = 0.048828125f;
        float innerHealthBarHeight = 0.029296875f;
        float maxHealth = entity.getMaxHealth();
        float partialHealth = attributeTracker.healthState.getAnimatedValue(entity.tickCount, partialTicks);
        float partialAbsorption = attributeTracker.absorptionState.getAnimatedValue(entity.tickCount, partialTicks);
        HealthBar.drawUIAsLevelModel(poseStack.last(), healthBarTexture, buffers, -0.5f, -0.048828125f, 0.5f, 0.048828125f, 0.0f, (float)texV / 64.0f, 1.0f, (float)(texV + 5) / 64.0f);
        if (partialAbsorption > 0.0f || attributeTracker.absorptionState.hasAnimation()) {
            boolean isTotalOverMaxHealth = partialHealth + partialAbsorption > maxHealth;
            float absorptionStart = isTotalOverMaxHealth ? Mth.clamp((float)(partialHealth / (partialHealth + partialAbsorption)), (float)0.0f, (float)1.0f) : partialHealth / maxHealth;
            float absorptionEnd = isTotalOverMaxHealth ? Mth.clamp((float)((partialHealth + partialAbsorption) / maxHealth), (float)0.0f, (float)1.0f) : (partialHealth + partialAbsorption) / maxHealth;
            HealthBar.drawUIAsLevelModel(poseStack.last(), HEALTHBARS2, buffers, absorptionStart - 0.5f, -0.048828125f, absorptionEnd - 0.5f, 0.048828125f, absorptionStart, 0.921875f, absorptionEnd, 1.0f);
            if (attributeTracker.absorptionState.hasAnimation()) {
                float lostAbsorptionStart = Mth.clamp((float)(entity.getAbsorptionAmount() / partialAbsorption), (float)0.0f, (float)1.0f);
                lostAbsorptionStart = absorptionStart + (absorptionEnd - absorptionStart) * lostAbsorptionStart;
                HealthBar.drawColoredQuadAsLevelModel(poseStack.last(), buffers, lostAbsorptionStart - 0.5f, -0.029296875f, absorptionEnd - 0.5f, 0.029296875f, 1694437888);
            }
            healthEnd = isTotalOverMaxHealth ? absorptionStart : 1.0f;
        } else {
            healthEnd = 1.0f;
        }
        float ratio = Mth.clamp((float)(entity.getHealth() / maxHealth), (float)0.0f, (float)1.0f);
        float filledHealthEnd = Math.max(-0.5f + ratio * healthEnd, -0.46875f);
        HealthBar.drawUIAsLevelModel(poseStack.last(), healthBarTexture, buffers, -0.5f, -0.048828125f, filledHealthEnd, 0.048828125f, 0.0f, (float)(texV + 5) / 64.0f, ratio * healthEnd, (float)(texV + 10) / 64.0f);
        if (attributeTracker.healthState.hasAnimation()) {
            float animatedHealthRatio = Mth.clamp((float)(partialHealth / maxHealth), (float)0.0f, (float)1.0f);
            float animatedHealthModelX = Math.min(-0.5f + animatedHealthRatio, 0.46875f);
            HealthBar.drawColoredQuadAsLevelModel(poseStack.last(), buffers, filledHealthEnd, -0.029296875f, animatedHealthModelX, 0.029296875f, damageColor);
        }
        if (attributeTracker.stunShieldState != null && Float.compare(entitypatch.getStunShield(), 0.0f) != 0) {
            HealthBar.drawUIAsLevelModel(poseStack.last(), BATTLE_ICON, buffers, -0.5f, -0.08f, 0.5f, -0.048828125f, 1, 0, 63, 5, 256);
            float stunShieldRatio = Mth.clamp((float)(entitypatch.getStunShield() / entitypatch.getMaxStunShield()), (float)0.0f, (float)1.0f);
            float shieldRatio = -0.5f + stunShieldRatio;
            int stunShieldTextureRatio = (int)(62.0f * stunShieldRatio);
            HealthBar.drawUIAsLevelModel(poseStack.last(), BATTLE_ICON, buffers, -0.5f, -0.08f, shieldRatio, -0.048828125f, 1, 5, stunShieldTextureRatio, 10, 256);
            float animatedStunShieldPosition = Mth.clamp((float)(attributeTracker.stunShieldState.getAnimatedValue(entity.tickCount, partialTicks) / entitypatch.getMaxStunShield()), (float)0.0f, (float)1.0f);
            HealthBar.drawColoredQuadAsLevelModel(poseStack.last(), buffers, shieldRatio, -0.08f, animatedStunShieldPosition - 0.5f, -0.048828125f, -1996549632);
        }
        poseStack.popPose();
    }

    public void reset() {
        this.trackingEntities.values().forEach(tracker -> tracker.setKeepUp(false));
    }

    public void remove() {
        this.trackingEntities.entrySet().removeIf(entry -> !((EntityAttributeTracker)entry.getValue()).canKeepUp());
    }

    public void tick() {
        this.trackingEntities.values().forEach(EntityAttributeTracker::tick);
    }

    public class EntityAttributeTracker {
        private final LivingEntity entity;
        private final AttributeState healthState;
        private final AttributeState absorptionState;
        @Nullable
        private final AttributeState stunShieldState;
        private boolean canKeepUp;

        public EntityAttributeTracker(HealthBar this$0, @Nullable LivingEntity entity, LivingEntityPatch<?> entitypatch) {
            this.entity = entity;
            this.healthState = new AttributeState(this, () -> Float.valueOf(entity.getMaxHealth()), () -> Float.valueOf(entity.getHealth()));
            this.absorptionState = new AttributeState(this, () -> Float.valueOf(entity.getMaxHealth()), () -> Float.valueOf(entity.getAbsorptionAmount()));
            this.stunShieldState = entitypatch != null ? new AttributeState(this, () -> Float.valueOf(entitypatch.getMaxStunShield()), () -> Float.valueOf(entitypatch.getStunShield())) : null;
        }

        public void setKeepUp(boolean canKeepUp) {
            this.canKeepUp = canKeepUp;
        }

        public boolean canKeepUp() {
            return this.canKeepUp;
        }

        public void checkChange(float partialTick) {
            this.healthState.checkState(this.entity.tickCount, partialTick);
            this.absorptionState.checkState(this.entity.tickCount, partialTick);
            if (this.stunShieldState != null) {
                this.stunShieldState.checkState(this.entity.tickCount, partialTick);
            }
        }

        public void tick() {
            this.healthState.tick(this.entity.tickCount);
            this.absorptionState.tick(this.entity.tickCount);
            if (this.stunShieldState != null) {
                this.stunShieldState.tick(this.entity.tickCount);
            }
        }

        class AttributeState {
            final Supplier<Float> maxValueGetter;
            final Supplier<Float> currentValueGetter;
            float value;
            float valueO;
            int lastChangeTick;
            int animationFrames;

            AttributeState(EntityAttributeTracker this$1, Supplier<Float> maxValueGetter, Supplier<Float> currentValueGetter) {
                float initValue;
                this.maxValueGetter = maxValueGetter;
                this.currentValueGetter = currentValueGetter;
                this.value = initValue = currentValueGetter.get().floatValue();
                this.valueO = initValue;
                this.lastChangeTick = 0;
                this.animationFrames = 0;
            }

            void checkState(int tickCount, float partialTick) {
                float currentValue = this.currentValueGetter.get().floatValue();
                if (this.value != currentValue) {
                    if (this.animationFrames > 0) {
                        this.valueO = this.getAnimatedValue(tickCount, partialTick);
                    }
                    this.lastChangeTick = tickCount + 3;
                    this.animationFrames = currentValue == 0.0f ? 4 : Math.max(4, (int)(Math.abs(this.valueO - currentValue) / this.maxValueGetter.get().floatValue() * 10.0f));
                    this.value = currentValue;
                }
            }

            boolean hasAnimation() {
                return this.animationFrames > 0;
            }

            void tick(int tickCount) {
                if (tickCount - this.lastChangeTick >= this.animationFrames) {
                    this.animationFrames = 0;
                    this.valueO = this.value;
                }
            }

            float getAnimatedValue(int tickCount, float partialTick) {
                if (this.animationFrames == 0) {
                    return this.value;
                }
                if (tickCount < this.lastChangeTick) {
                    return this.valueO;
                }
                float divide = (float)(tickCount - this.lastChangeTick) / (float)this.animationFrames;
                float partial = divide + partialTick / (float)this.animationFrames;
                return this.valueO + (this.value - this.valueO) * partial;
            }
        }
    }
}

