/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import yesman.epicfight.client.gui.ScreenCalculations;
import yesman.epicfight.client.gui.widgets.UIComponent;
import yesman.epicfight.config.OptionHandler;

public class UIComponentPop<T extends UIComponent>
extends Screen
implements ContainerEventHandler {
    protected final T parentWidget;
    protected int width;
    protected int height;
    public int x;
    public int y;
    private boolean enable;

    public UIComponentPop(int width, int height, T parentWidget) {
        super((Component)Component.literal((String)""));
        this.width = width;
        this.height = height;
        this.parentWidget = parentWidget;
        this.init();
    }

    public void init() {
        this.clearWidgets();
        this.addRenderableWidget((GuiEventListener)UIComponentPop.createButton(this.x + 10, this.y - 2, 11, 8, button -> {
            ((UIComponent)((Object)((Object)this.parentWidget))).verticalBasis.setValue(ScreenCalculations.VerticalBasis.TOP);
            ((UIComponent)((Object)((Object)this.parentWidget))).yCoord.setValue(ScreenCalculations.VerticalBasis.TOP.saveCoordGetter.apply(((UIComponent)((Object)((Object)this.parentWidget))).parentScreen.height, this.y));
        }));
        this.addRenderableWidget((GuiEventListener)UIComponentPop.createButton(this.x - 2, this.y + 11, 11, 7, button -> {
            ((UIComponent)((Object)((Object)this.parentWidget))).horizontalBasis.setValue(ScreenCalculations.HorizontalBasis.LEFT);
            ((UIComponent)((Object)((Object)this.parentWidget))).xCoord.setValue(ScreenCalculations.HorizontalBasis.LEFT.saveCoordGetter.apply(((UIComponent)((Object)((Object)this.parentWidget))).parentScreen.width, this.x));
        }));
        this.addRenderableWidget((GuiEventListener)UIComponentPop.createButton(this.x + 22, this.y + 11, 11, 7, button -> {
            ((UIComponent)((Object)((Object)this.parentWidget))).horizontalBasis.setValue(ScreenCalculations.HorizontalBasis.RIGHT);
            ((UIComponent)((Object)((Object)this.parentWidget))).xCoord.setValue(ScreenCalculations.HorizontalBasis.RIGHT.saveCoordGetter.apply(((UIComponent)((Object)((Object)this.parentWidget))).parentScreen.width, this.x));
        }));
        this.addRenderableWidget((GuiEventListener)UIComponentPop.createButton(this.x + 10, this.y + 24, 11, 8, button -> {
            ((UIComponent)((Object)((Object)this.parentWidget))).verticalBasis.setValue(ScreenCalculations.VerticalBasis.BOTTOM);
            ((UIComponent)((Object)((Object)this.parentWidget))).yCoord.setValue(ScreenCalculations.VerticalBasis.BOTTOM.saveCoordGetter.apply(((UIComponent)((Object)((Object)this.parentWidget))).parentScreen.height, this.y));
        }));
        this.addRenderableWidget((GuiEventListener)UIComponentPop.createButton(this.x + 10, this.y + 11, 11, 7, button -> {
            ((UIComponent)((Object)((Object)this.parentWidget))).verticalBasis.setValue(ScreenCalculations.VerticalBasis.CENTER);
            ((UIComponent)((Object)((Object)this.parentWidget))).horizontalBasis.setValue(ScreenCalculations.HorizontalBasis.CENTER);
            ((UIComponent)((Object)((Object)this.parentWidget))).xCoord.setValue(ScreenCalculations.HorizontalBasis.CENTER.saveCoordGetter.apply(((UIComponent)((Object)((Object)this.parentWidget))).parentScreen.width, this.x));
            ((UIComponent)((Object)((Object)this.parentWidget))).yCoord.setValue(ScreenCalculations.VerticalBasis.CENTER.saveCoordGetter.apply(((UIComponent)((Object)((Object)this.parentWidget))).parentScreen.height, this.y));
        }));
    }

    public static Button createButton(int x, int y, int width, int height, Button.OnPress onpress) {
        return Button.builder((Component)Component.literal((String)""), (Button.OnPress)onpress).bounds(x, y, width, height).build();
    }

    public void openPop() {
        this.enable = true;
        this.init();
    }

    public void closePop() {
        this.enable = false;
    }

    protected boolean isHoverd(double x, double y) {
        return this.enable && x >= (double)this.x && y >= (double)this.y && x < (double)(this.x + this.width) && y < (double)(this.y + this.height);
    }

    public boolean isOpen() {
        return this.enable;
    }

    public boolean mouseClicked(double x, double y, int pressType) {
        if (this.enable) {
            boolean clicked = false;
            for (GuiEventListener listener : this.children()) {
                clicked |= listener.mouseClicked(x, y, pressType);
            }
            return clicked;
        }
        return false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.enable) {
            boolean parentOut;
            boolean popupOut = mouseX < this.x - 3 || mouseY < this.y - 3 || mouseX >= this.x + this.width + 3 || mouseY >= this.y + this.height + 3;
            boolean bl = parentOut = mouseX < this.parentWidget.getX() - 3 || mouseY < this.parentWidget.getY() - 3 || mouseX >= this.parentWidget.getX() + this.parentWidget.getWidth() + 3 || mouseY >= this.parentWidget.getY() + this.parentWidget.getHeight() + 3;
            if (popupOut && parentOut) {
                this.enable = false;
            }
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 200.0f);
            this.renderPopup(guiGraphics, this.x, this.y, this.width, this.height);
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            poseStack.popPose();
        }
    }

    protected void renderPopup(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int i = width;
        int j = height;
        int j2 = x;
        int k2 = y;
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        int backgroundStart = -267386864;
        int backgroundEnd = -267386864;
        int boarderStart = 0x505000FF;
        int boarderEnd = 1344798847;
        guiGraphics.fillGradient(j2 - 3, k2 - 4, j2 + i + 3, k2 - 3, 0, backgroundStart, backgroundStart);
        guiGraphics.fillGradient(j2 - 3, k2 + j + 3, j2 + i + 3, k2 + j + 4, 0, backgroundEnd, backgroundEnd);
        guiGraphics.fillGradient(j2 - 3, k2 - 3, j2 + i + 3, k2 + j + 3, 0, backgroundStart, backgroundEnd);
        guiGraphics.fillGradient(j2 - 4, k2 - 3, j2 - 3, k2 + j + 3, 0, backgroundStart, backgroundEnd);
        guiGraphics.fillGradient(j2 + i + 3, k2 - 3, j2 + i + 4, k2 + j + 3, 0, backgroundStart, backgroundEnd);
        guiGraphics.fillGradient(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + j + 3 - 1, 0, boarderStart, boarderEnd);
        guiGraphics.fillGradient(j2 + i + 2, k2 - 3 + 1, j2 + i + 3, k2 + j + 3 - 1, 0, boarderStart, boarderEnd);
        guiGraphics.fillGradient(j2 - 3, k2 - 3, j2 + i + 3, k2 - 3 + 1, 0, boarderStart, boarderStart);
        guiGraphics.fillGradient(j2 - 3, k2 + j + 2, j2 + i + 3, k2 + j + 3, 0, boarderEnd, boarderEnd);
    }

    public static class PassivesUIComponentPop
    extends UIComponentPop<UIComponent.PassiveUIComponent> {
        public PassivesUIComponentPop(int width, int height, UIComponent.PassiveUIComponent parentWidget) {
            super(width, height, parentWidget);
        }

        @Override
        protected void renderPopup(GuiGraphics guiGraphics, int x, int y, int width, int height) {
            super.renderPopup(guiGraphics, x, y + 14, width, height - 14);
        }

        @Override
        public void init() {
            super.init();
            for (GuiEventListener gui : this.children()) {
                if (!(gui instanceof AbstractWidget)) continue;
                AbstractWidget widget = (AbstractWidget)gui;
                widget.setY(widget.getY() + 14);
            }
            this.addRenderableWidget((GuiEventListener)new AlignButton(this.x - 3, this.y, 12, 10, ((UIComponent.PassiveUIComponent)this.parentWidget).horizontalBasis, ((UIComponent.PassiveUIComponent)this.parentWidget).verticalBasis, ((UIComponent.PassiveUIComponent)this.parentWidget).alignDirection, button -> {
                ScreenCalculations.AlignDirection newAlignDirection = ScreenCalculations.AlignDirection.values()[(((UIComponent.PassiveUIComponent)this.parentWidget).alignDirection.getValue().ordinal() + 1) % ScreenCalculations.AlignDirection.values().length];
                ((UIComponent.PassiveUIComponent)this.parentWidget).alignDirection.setValue(newAlignDirection);
            }));
        }

        public static class AlignButton
        extends Button {
            private static final ResourceLocation BATTLE_ICONS = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/battle_icons.png");
            private final OptionHandler<ScreenCalculations.HorizontalBasis> horBasis;
            private final OptionHandler<ScreenCalculations.VerticalBasis> verBasis;
            private final OptionHandler<ScreenCalculations.AlignDirection> alignDirection;

            public AlignButton(int x, int y, int width, int height, OptionHandler<ScreenCalculations.HorizontalBasis> horBasis, OptionHandler<ScreenCalculations.VerticalBasis> verBasis, OptionHandler<ScreenCalculations.AlignDirection> alignDirection, Button.OnPress onpress) {
                super(x, y, width, height, (Component)Component.literal((String)""), onpress, Button.DEFAULT_NARRATION);
                this.horBasis = horBasis;
                this.verBasis = verBasis;
                this.alignDirection = alignDirection;
            }

            protected void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                float height;
                float width;
                float startY;
                float startX;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BATTLE_ICONS);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                Vec2[] texCoords = new Vec2[4];
                if (this.isHovered) {
                    startX = 0.5176471f;
                    startY = 0.0f;
                    width = 0.14117648f;
                    height = 0.14117648f;
                } else {
                    startX = 0.38039216f;
                    startY = 0.007843138f;
                    width = 0.12156863f;
                    height = 0.12156863f;
                }
                Vec2 uv0 = new Vec2(startX, startY);
                Vec2 uv1 = new Vec2(startX + width, startY);
                Vec2 uv2 = new Vec2(startX + width, startY + height);
                Vec2 uv3 = new Vec2(startX, startY + height);
                texCoords[0] = uv0;
                texCoords[1] = uv1;
                texCoords[2] = uv2;
                texCoords[3] = uv3;
                if (this.alignDirection.getValue() == ScreenCalculations.AlignDirection.HORIZONTAL) {
                    if (this.horBasis.getValue() == ScreenCalculations.HorizontalBasis.LEFT) {
                        texCoords[0] = uv1;
                        texCoords[1] = uv2;
                        texCoords[2] = uv3;
                        texCoords[3] = uv0;
                    } else {
                        texCoords[0] = uv3;
                        texCoords[1] = uv0;
                        texCoords[2] = uv1;
                        texCoords[3] = uv2;
                    }
                } else if (this.verBasis.getValue() == ScreenCalculations.VerticalBasis.BOTTOM) {
                    texCoords[0] = uv2;
                    texCoords[1] = uv3;
                    texCoords[2] = uv0;
                    texCoords[3] = uv1;
                }
                this.blitRotate(guiGraphics, texCoords);
            }

            public void blitRotate(GuiGraphics guiGraphics, Vec2[] texCoords) {
                PoseStack poseStack = guiGraphics.pose();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(poseStack.last().pose(), (float)this.getX(), (float)this.getY(), (float)this.getBlitOffset()).setUv(texCoords[0].x, texCoords[0].y);
                bufferbuilder.addVertex(poseStack.last().pose(), (float)(this.getX() + this.width), (float)this.getY(), (float)this.getBlitOffset()).setUv(texCoords[1].x, texCoords[1].y);
                bufferbuilder.addVertex(poseStack.last().pose(), (float)(this.getX() + this.width), (float)(this.getY() + this.height), (float)this.getBlitOffset()).setUv(texCoords[2].x, texCoords[2].y);
                bufferbuilder.addVertex(poseStack.last().pose(), (float)this.getX(), (float)(this.getY() + this.height), (float)this.getBlitOffset()).setUv(texCoords[3].x, texCoords[3].y);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            }

            public int getBlitOffset() {
                return 0;
            }
        }
    }
}

