/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;

public abstract class AbstractTrailParticle<T extends EntityPatch<?>>
extends TextureSheetParticle {
    protected final TrailInfo trailInfo;
    protected final T owner;
    protected final List<TrailEdge> trailEdges;
    protected float startEdgeCorrection = 0.0f;
    protected boolean shouldRemove;

    protected AbstractTrailParticle(ClientLevel level, T entitypatch, TrailInfo trailInfo) {
        super(level, 0.0, 0.0, 0.0);
        this.hasPhysics = false;
        this.owner = entitypatch;
        this.trailEdges = Lists.newLinkedList();
        this.trailInfo = trailInfo;
        Vec3 entityPos = ((EntityPatch)entitypatch).getOriginal().position();
        this.move(entityPos.x, entityPos.y + (double)((EntityPatch)entitypatch).getOriginal().getEyeHeight(), entityPos.z);
        float size = (float)Math.max(this.trailInfo.start().length(), this.trailInfo.end().length()) * 2.0f;
        this.setSize(size, size);
        this.rCol = Math.max(this.trailInfo.rCol(), 0.0f);
        this.gCol = Math.max(this.trailInfo.gCol(), 0.0f);
        this.bCol = Math.max(this.trailInfo.bCol(), 0.0f);
    }

    @Deprecated
    protected AbstractTrailParticle(T entitypatch, TrailInfo trailInfo) {
        super(null, 0.0, 0.0, 0.0);
        this.owner = entitypatch;
        this.trailEdges = Lists.newLinkedList();
        this.trailInfo = trailInfo;
        this.rCol = Math.max(this.trailInfo.rCol(), 0.0f);
        this.gCol = Math.max(this.trailInfo.gCol(), 0.0f);
        this.bCol = Math.max(this.trailInfo.bCol(), 0.0f);
    }

    protected abstract boolean canContinue();

    protected boolean canCreateNextCurve() {
        return this.age % this.trailInfo.updateInterval() == 0 && !this.removed;
    }

    protected abstract void createNextCurve();

    public void tick() {
        if (this.shouldRemove) {
            if (this.age >= this.lifetime) {
                this.remove();
            }
        } else if (!this.canContinue()) {
            this.shouldRemove = true;
            this.lifetime = this.age + this.trailInfo.trailLifetime();
        }
        ++this.age;
        this.trailEdges.removeIf(v -> !v.isAlive());
        if (!this.canCreateNextCurve()) {
            return;
        }
        Vec3 lastPos = ((EntityPatch)this.owner).getOriginal().getPosition(0.0f);
        double xd = Math.pow(((EntityPatch)this.owner).getOriginal().getX() - lastPos.x, 2.0);
        double yd = Math.pow(((EntityPatch)this.owner).getOriginal().getY() - lastPos.y, 2.0);
        double zd = Math.pow(((EntityPatch)this.owner).getOriginal().getZ() - lastPos.z, 2.0);
        float move = (float)Math.sqrt(xd + yd + zd) * 2.0f;
        this.setSize(this.bbWidth + move, this.bbHeight + move);
        this.createNextCurve();
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        if (this.trailEdges.isEmpty()) {
            return;
        }
        PoseStack poseStack = new PoseStack();
        int light = this.getLightColor(partialTick);
        this.setupPoseStack(poseStack, camera, partialTick);
        Matrix4f matrix4f = poseStack.last().pose();
        int edges = this.trailEdges.size() - 1;
        boolean startFade = this.trailEdges.get((int)0).lifetime == 1;
        boolean endFade = this.trailEdges.get((int)edges).lifetime == this.trailInfo.trailLifetime();
        float startEdge = (startFade ? (float)(this.trailInfo.interpolateCount() * 2) * partialTick : 0.0f) + this.startEdgeCorrection;
        float endEdge = endFade ? Math.min((float)edges - (float)(this.trailInfo.interpolateCount() * 2) * (1.0f - partialTick), (float)(edges - 1)) : (float)(edges - 1);
        float interval = 1.0f / (endEdge - startEdge);
        float fading = 1.0f;
        if (this.shouldRemove) {
            fading = TrailInfo.isValidTime(this.trailInfo.fadeTime()) ? (float)(this.lifetime - this.age) / (float)this.trailInfo.trailLifetime() : Mth.clamp((float)(((float)(this.lifetime - this.age) + (1.0f - partialTick)) / (float)this.trailInfo.trailLifetime()), (float)0.0f, (float)1.0f);
        }
        float partialStartEdge = interval * (startEdge % 1.0f);
        float from = -partialStartEdge;
        float to = -partialStartEdge + interval;
        for (int i = (int)startEdge; i < (int)endEdge + 1; ++i) {
            TrailEdge e1 = this.trailEdges.get(i);
            TrailEdge e2 = this.trailEdges.get(i + 1);
            Vector4f pos1 = new Vector4f((float)e1.start.x, (float)e1.start.y, (float)e1.start.z, 1.0f);
            Vector4f pos2 = new Vector4f((float)e1.end.x, (float)e1.end.y, (float)e1.end.z, 1.0f);
            Vector4f pos3 = new Vector4f((float)e2.end.x, (float)e2.end.y, (float)e2.end.z, 1.0f);
            Vector4f pos4 = new Vector4f((float)e2.start.x, (float)e2.start.y, (float)e2.start.z, 1.0f);
            pos1.mul((Matrix4fc)matrix4f);
            pos2.mul((Matrix4fc)matrix4f);
            pos3.mul((Matrix4fc)matrix4f);
            pos4.mul((Matrix4fc)matrix4f);
            float alphaFrom = Mth.clamp((float)from, (float)0.0f, (float)1.0f);
            float alphaTo = Mth.clamp((float)to, (float)0.0f, (float)1.0f);
            vertexConsumer.addVertex(pos1.x(), pos1.y(), pos1.z()).setUv(from, 1.0f).setColor(this.rCol, this.gCol, this.bCol, this.alpha * alphaFrom * fading).setLight(light);
            vertexConsumer.addVertex(pos2.x(), pos2.y(), pos2.z()).setUv(from, 0.0f).setColor(this.rCol, this.gCol, this.bCol, this.alpha * alphaFrom * fading).setLight(light);
            vertexConsumer.addVertex(pos3.x(), pos3.y(), pos3.z()).setUv(to, 0.0f).setColor(this.rCol, this.gCol, this.bCol, this.alpha * alphaTo * fading).setLight(light);
            vertexConsumer.addVertex(pos4.x(), pos4.y(), pos4.z()).setUv(to, 1.0f).setColor(this.rCol, this.gCol, this.bCol, this.alpha * alphaTo * fading).setLight(light);
            from += interval;
            to += interval;
        }
    }

    public AABB getRenderBoundingBox(float partialTicks) {
        return AABB.INFINITE;
    }

    public ParticleRenderType getRenderType() {
        return EpicFightParticleRenderTypes.TRAIL_EFFECT.apply(this.trailInfo.texturePath());
    }

    protected void setupPoseStack(PoseStack poseStack, Camera camera, float partialTicks) {
        Vec3 vec3 = camera.getPosition();
        float x = (float)(-vec3.x());
        float y = (float)(-vec3.y());
        float z = (float)(-vec3.z());
        poseStack.translate(x, y, z);
    }

    protected void makeTrailEdges(List<Vec3> startPositions, List<Vec3> endPositions, List<TrailEdge> dest) {
        for (int i = 0; i < startPositions.size(); ++i) {
            dest.add(new TrailEdge(startPositions.get(i), endPositions.get(i), this.trailInfo.trailLifetime()));
        }
    }

    protected int getLightColor(float pPartialTick) {
        BlockPos blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        return this.level.hasChunkAt(blockpos) ? this.getLightColor((BlockAndTintGetter)this.level, this.level.getBlockState(blockpos), blockpos) : 0;
    }

    private int getLightColor(BlockAndTintGetter level, BlockState state, BlockPos pos) {
        int k;
        if (state.emissiveRendering((BlockGetter)level, pos)) {
            return 0xF000F0;
        }
        int i = Mth.clamp((int)Math.max(this.trailInfo.skyLight(), level.getBrightness(LightLayer.SKY, pos)), (int)0, (int)15);
        int j = Mth.clamp((int)Math.max(this.trailInfo.blockLight(), level.getBrightness(LightLayer.BLOCK, pos)), (int)0, (int)15);
        if (j < (k = state.getLightEmission((BlockGetter)level, pos))) {
            j = k;
        }
        return i << 20 | j << 4;
    }

    public static class TrailEdge {
        public final Vec3 start;
        public final Vec3 end;
        public int lifetime;

        public TrailEdge(Vec3 start, Vec3 end, int lifetime) {
            this.start = start;
            this.end = end;
            this.lifetime = lifetime;
        }

        public boolean isAlive() {
            return --this.lifetime > 0;
        }
    }
}

