/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class EpicFightParticleRenderTypes {
    public static final ParticleRenderType PARTICLE_MODEL_NO_NORMAL = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::getParticleShader);
            return tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "epicfight:PARTICLE_MODEL_NO_NORMAL";
        }
    };
    public static final ParticleRenderType LIGHTNING = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::getRendertypeLightningShader);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        }

        public String toString() {
            return "epicfight:LIGHTING";
        }
    };
    public static final Function<ResourceLocation, ParticleRenderType> TRAIL_EFFECT = Util.memoize(textureLocation -> {
        TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
        AbstractTexture abstracttexture = texturemanager.getTexture(textureLocation);
        RenderSystem.bindTexture((int)abstracttexture.getId());
        RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
        RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
        return new ParticleRenderType((ResourceLocation)textureLocation){
            final /* synthetic */ ResourceLocation val$textureLocation;
            {
                this.val$textureLocation = resourceLocation;
            }

            public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
                RenderSystem.disableCull();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.val$textureLocation);
                return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            }

            public String toString() {
                return "epicfight:TRAIL_EFFECT";
            }
        };
    });
    public static final ParticleRenderType TRANSLUCENT_GLOWING = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            return tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        }

        public String toString() {
            return "epicfight:TRANSLUCENT_GLOWING";
        }
    };
    public static final ParticleRenderType ENTITY_PARTICLE = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager texManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::getParticleShader);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "epicfight:ENTITY_PARTICLE";
        }
    };
}

