/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import yesman.epicfight.api.utils.math.QuaternionUtils;

public class LightningRenderHelper {
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    private static void vertex01(VertexConsumer vertexConsumer, Matrix4f matrix4f, int alpha) {
        vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, alpha);
    }

    private static void vertex2(VertexConsumer vertexConsumer, Matrix4f matrix4f, float height, float width, int rCol, int gCol, int bCol) {
        vertexConsumer.addVertex(matrix4f, -HALF_SQRT_3 * width, height, -0.5f * width).setColor(rCol, gCol, bCol, 0);
    }

    private static void vertex3(VertexConsumer vertexConsumer, Matrix4f matrix4f, float height, float width, int rCol, int gCol, int bCol) {
        vertexConsumer.addVertex(matrix4f, HALF_SQRT_3 * width, height, -0.5f * width).setColor(rCol, gCol, bCol, 0);
    }

    private static void vertex4(VertexConsumer vertexConsumer, Matrix4f matrix4f, float width, float height, int rCol, int gCol, int bCol) {
        vertexConsumer.addVertex(matrix4f, 0.0f, width, height).setColor(rCol, gCol, bCol, 0);
    }

    public static void renderCirclingLight(VertexConsumer vertexConsumer, PoseStack poseStack, int rCol, int gCol, int bCol, int density, float size, float progression, float repeater) {
        Matrix4f matrix4f = poseStack.last().pose();
        Random random = new Random(123L);
        int i = 0;
        while ((float)i < (float)density) {
            poseStack.mulPose(QuaternionUtils.XP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(QuaternionUtils.YP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(QuaternionUtils.ZP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(QuaternionUtils.XP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(QuaternionUtils.YP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(QuaternionUtils.ZP.rotationDegrees(random.nextFloat() * 360.0f + progression * 90.0f));
            float height = (random.nextFloat() * 20.0f + 5.0f + repeater * 10.0f) * size;
            float width = (random.nextFloat() * 2.0f + 1.0f + repeater * 2.0f) * size;
            float randomf = random.nextFloat();
            float alpha = ((float)Math.sin((double)(randomf + progression) * Math.PI) + 1.0f) * 0.5f;
            int j = (int)(255.0f * alpha);
            LightningRenderHelper.vertex01(vertexConsumer, matrix4f, j);
            LightningRenderHelper.vertex2(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex3(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex01(vertexConsumer, matrix4f, j);
            LightningRenderHelper.vertex3(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex4(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex01(vertexConsumer, matrix4f, j);
            LightningRenderHelper.vertex4(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex2(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            ++i;
        }
    }

    public static void renderFlashingLight(VertexConsumer vertexConsumer, PoseStack poseStack, int rCol, int gCol, int bCol, int density, float size, float progression) {
        double d1 = (double)(progression * 3.0f) * Math.PI / 2.0;
        float sinDelta = Math.max((float)(d1 < 1.5707963267948966 ? Math.sin(d1) : Math.sin((d1 + 1.5707963267948966) / 2.0)), 0.0f);
        float linearDelta = progression < 0.3f ? progression + 0.7f : 1.0f;
        Random random = new Random(432L);
        for (int i = 0; i < density; ++i) {
            poseStack.pushPose();
            Vector3f randomAxis = new Vector3f(-0.5f + random.nextFloat(), 0.0f, -0.5f + random.nextFloat());
            randomAxis.normalize();
            float randomDegree = -120.0f + random.nextFloat() * 240.0f;
            Quaternionf randomRotation = QuaternionUtils.rotationDegrees(randomAxis, randomDegree);
            poseStack.mulPose(randomRotation);
            poseStack.mulPose(QuaternionUtils.YP.rotationDegrees(random.nextFloat() * 360.0f));
            float height = 14.0f * linearDelta * size;
            float width = (0.3f + random.nextFloat()) * size;
            Matrix4f matrix4f = poseStack.last().pose();
            int alpha = (int)(255.0f * sinDelta);
            LightningRenderHelper.vertex01(vertexConsumer, matrix4f, alpha);
            LightningRenderHelper.vertex2(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex3(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex01(vertexConsumer, matrix4f, alpha);
            LightningRenderHelper.vertex3(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex4(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex01(vertexConsumer, matrix4f, alpha);
            LightningRenderHelper.vertex4(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            LightningRenderHelper.vertex2(vertexConsumer, matrix4f, height, width, rCol, gCol, bCol);
            poseStack.popPose();
        }
    }
}

