/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.neoevent.PrepareModelEvent;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.LayerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.LayerUtil;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.mixin.client.MixinLivingEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class PresetRenderer
extends PatchedEntityRenderer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityRenderer<LivingEntity>, SkinnedMesh>
implements LayerRenderer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityModel<LivingEntity>> {
    private final LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> presetRenderer;
    protected final Map<Class<?>, PatchedLayer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityModel<LivingEntity>, ? extends RenderLayer<LivingEntity, EntityModel<LivingEntity>>>> patchedLayers = Maps.newHashMap();
    protected final List<PatchedLayer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityModel<LivingEntity>, ? extends RenderLayer<LivingEntity, EntityModel<LivingEntity>>>> customLayers = Lists.newArrayList();
    protected final AssetAccessor<SkinnedMesh> mesh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PresetRenderer(EntityRendererProvider.Context context, EntityType<?> entityType, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer, AssetAccessor<SkinnedMesh> mesh) {
        this.presetRenderer = renderer;
        this.mesh = mesh;
        ResourceLocation type = EntityType.getKey(entityType);
        FileToIdConverter filetoidconverter = FileToIdConverter.json((String)("animated_layers/" + type.getPath()));
        ArrayList layers = Lists.newArrayList();
        for (Map.Entry entry : filetoidconverter.listMatchingResources(context.getResourceManager()).entrySet()) {
            BufferedReader reader = null;
            try {
                reader = ((Resource)entry.getValue()).openAsReader();
                JsonElement jsonelement = (JsonElement)GsonHelper.fromJson((Gson)new GsonBuilder().create(), (Reader)reader, JsonElement.class);
                layers.add(Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)jsonelement));
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                EpicFightMod.LOGGER.error("Failed to parse layer file {} for {}", entry.getKey(), (Object)type);
                jsonparseexception.printStackTrace();
            }
            finally {
                try {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
        LayerUtil.addLayer(this, entityType, layers);
    }

    @Override
    public void render(LivingEntity entity, LivingEntityPatch<LivingEntity> entitypatch, EntityRenderer<LivingEntity> renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        super.render(entity, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks);
        Minecraft mc = Minecraft.getInstance();
        MixinLivingEntityRenderer livingEntityRendererAccessor = (MixinLivingEntityRenderer)this.presetRenderer;
        boolean isVisible = livingEntityRendererAccessor.invokeIsBodyVisible(entity);
        boolean isVisibleToPlayer = !isVisible && !entity.isInvisibleTo((Player)mc.player);
        boolean isGlowing = mc.shouldEntityAppearGlowing((Entity)entity);
        RenderType renderType = livingEntityRendererAccessor.invokeGetRenderType(entity, isVisible, isVisibleToPlayer, isGlowing);
        Armature armature = entitypatch.getArmature();
        poseStack.pushPose();
        this.mulPoseStack(poseStack, armature, entity, entitypatch, partialTicks);
        this.setArmaturePose(entitypatch, armature, partialTicks);
        if (renderType != null) {
            this.prepareVanillaModel(entity, (EntityModel<LivingEntity>)this.presetRenderer.getModel(), this.presetRenderer, partialTicks);
            SkinnedMesh mesh = (SkinnedMesh)this.getMeshProvider(entitypatch).get();
            this.prepareModel(mesh, entity, entitypatch, this.presetRenderer);
            PrepareModelEvent prepareModelEvent = new PrepareModelEvent(this, mesh, entitypatch, buffer, poseStack, packedLight, partialTicks);
            if (!((PrepareModelEvent)NeoForge.EVENT_BUS.post((Event)prepareModelEvent)).isCanceled()) {
                mesh.draw(poseStack, buffer, renderType, packedLight, 1.0f, 1.0f, 1.0f, isVisibleToPlayer ? 0.15f : 1.0f, this.getOverlayCoord(entity, entitypatch, partialTicks), armature, armature.getPoseMatrices());
            }
        }
        if (!entity.isSpectator()) {
            this.renderLayer(this.presetRenderer, entitypatch, entity, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
        }
        if (renderType != null && Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes()) {
            entitypatch.getClientAnimator().renderDebuggingInfoForAllLayers(poseStack, buffer, partialTicks);
        }
        poseStack.popPose();
    }

    public float getVanillaRendererBob(LivingEntity entity, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer, float partialTicks) {
        return (float)entity.tickCount + partialTicks;
    }

    protected void prepareVanillaModel(LivingEntity entityIn, EntityModel<LivingEntity> model, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer, float partialTicks) {
        Entity entity;
        boolean shouldSit;
        model.riding = shouldSit = entityIn.isPassenger() && entityIn.getVehicle() != null && entityIn.getVehicle().shouldRiderSit();
        model.young = entityIn.isBaby();
        float f = Mth.rotLerp((float)partialTicks, (float)entityIn.yBodyRotO, (float)entityIn.yBodyRot);
        float f1 = Mth.rotLerp((float)partialTicks, (float)entityIn.yHeadRotO, (float)entityIn.yHeadRot);
        float f2 = f1 - f;
        if (shouldSit && (entity = entityIn.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)entityIn)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        float f7 = this.getVanillaRendererBob(entityIn, renderer, partialTicks);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.isAlive()) {
            f8 = entityIn.walkAnimation.speed(partialTicks);
            f5 = entityIn.walkAnimation.position() - entityIn.walkAnimation.speed() * (1.0f - partialTicks);
            if (entityIn.isBaby()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        model.prepareMobModel((Entity)entityIn, f5, f8, partialTicks);
        model.setupAnim((Entity)entityIn, f5, f8, f7, f2, f6);
    }

    protected void prepareModel(SkinnedMesh mesh, LivingEntity entity, LivingEntityPatch<LivingEntity> entitypatch, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer) {
        mesh.initialize();
    }

    protected void renderLayer(LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer, LivingEntityPatch<LivingEntity> entitypatch, LivingEntity entity, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        float f = MathUtils.lerpBetween(entity.yBodyRotO, entity.yBodyRot, partialTicks);
        float f1 = MathUtils.lerpBetween(entity.yHeadRotO, entity.yHeadRot, partialTicks);
        float f2 = f1 - f;
        float f7 = entity.getViewXRot(partialTicks);
        float bob = this.getVanillaRendererBob(entity, renderer, partialTicks);
        for (RenderLayer renderLayer : renderer.layers) {
            Class<?> layerClass = renderLayer.getClass();
            if (layerClass.isAnonymousClass()) {
                layerClass = layerClass.getSuperclass();
            }
            if (!this.patchedLayers.containsKey(layerClass)) continue;
            this.patchedLayers.get(layerClass).renderLayer((LivingEntityPatch<LivingEntity>)entity, (LivingEntity)entitypatch, (RenderLayer<LivingEntity, EntityModel<LivingEntity>>)renderLayer, poseStack, buffer, packedLight, poses, bob, f2, f7, partialTicks);
        }
        for (PatchedLayer patchedLayer : this.customLayers) {
            patchedLayer.renderLayer(entity, entitypatch, null, poseStack, buffer, packedLight, poses, bob, f2, f7, partialTicks);
        }
    }

    protected int getOverlayCoord(LivingEntity entity, LivingEntityPatch<LivingEntity> entitypatch, float partialTicks) {
        return OverlayTexture.pack((int)0, (int)OverlayTexture.v((entity.hurtTime > 5 ? 1 : 0) != 0));
    }

    @Override
    public void addPatchedLayer(Class<?> originalLayerClass, PatchedLayer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityModel<LivingEntity>, ? extends RenderLayer<LivingEntity, EntityModel<LivingEntity>>> patchedLayer) {
        this.patchedLayers.putIfAbsent(originalLayerClass, patchedLayer);
    }

    @Override
    public void addCustomLayer(PatchedLayer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityModel<LivingEntity>, ? extends RenderLayer<LivingEntity, EntityModel<LivingEntity>>> patchedLayer) {
        this.customLayers.add(patchedLayer);
    }

    @Override
    public AssetAccessor<SkinnedMesh> getDefaultMesh() {
        return this.mesh;
    }
}

