/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat.shouldersurfing;

import com.github.exopandora.shouldersurfing.api.callback.ICameraCouplingCallback;
import com.github.exopandora.shouldersurfing.api.client.IShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingPlugin;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingRegistrar;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.client.event.EpicFightClientHooks;
import yesman.epicfight.api.client.event.types.BuildCameraTransform;
import yesman.epicfight.api.client.event.types.LockOnEvent;
import yesman.epicfight.api.client.input.InputManager;
import yesman.epicfight.api.client.input.action.EpicFightInputAction;
import yesman.epicfight.api.client.input.action.MinecraftInputAction;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.camera.EpicFightTpsCameraDisableState;
import yesman.epicfight.client.camera.EpicFightTpsCameraDisabledReason;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

public class ShoulderSurfingCompat
implements IShoulderSurfingPlugin {
    public void register(IShoulderSurfingRegistrar registrar) {
        this.disableEpicFightCamera();
        this.registerShoulderSurfingEvents(registrar);
        this.registerEpicFightEvents();
    }

    private void disableEpicFightCamera() {
        EpicFightTpsCameraDisableState.disable(EpicFightTpsCameraDisabledReason.ShoulderSurfing);
    }

    private void registerShoulderSurfingEvents(IShoulderSurfingRegistrar registrar) {
        registrar.registerCameraCouplingCallback((ICameraCouplingCallback)new CameraCouplingOnAttack());
        registrar.registerCameraCouplingCallback((ICameraCouplingCallback)new CameraCouplingOnChargingSkill());
    }

    private void registerEpicFightEvents() {
        EpicFightClientHooks.Camera.BUILD_TRANSFORM_PRE.registerEvent(ShoulderSurfingCompat::buildCameraTransform);
        EpicFightClientHooks.Camera.LOCK_ON_TICK.registerEvent(ShoulderSurfingCompat::lockOnTick);
    }

    private static void buildCameraTransform(BuildCameraTransform.Pre event) {
        IShoulderSurfing shoulderSurfing = ShoulderSurfing.getInstance();
        if (shoulderSurfing.isShoulderSurfing()) {
            if (event.getCameraApi().isLockingOnTarget()) {
                ShoulderSurfingCompat.syncLockOnRotations(event, shoulderSurfing);
            }
            event.cancel();
        }
    }

    private static void syncLockOnRotations(BuildCameraTransform.Pre event, IShoulderSurfing shoulderSurfing) {
        float camXRot = Mth.rotLerp((float)event.getPartialTick(), (float)event.getCameraApi().getCameraXRotO(), (float)event.getCameraApi().getCameraXRot());
        float camYRot = Mth.rotLerp((float)event.getPartialTick(), (float)event.getCameraApi().getCameraYRotO(), (float)event.getCameraApi().getCameraYRot());
        shoulderSurfing.getCamera().setXRot(camXRot);
        shoulderSurfing.getCamera().setYRot(camYRot);
    }

    private static void lockOnTick(LockOnEvent.Tick event) {
        IShoulderSurfing instance = ShoulderSurfing.getInstance();
        if (!instance.isShoulderSurfing()) {
            return;
        }
        LocalPlayer localPlayer = event.getCameraApi().getMinecraft().player;
        assert (localPlayer != null);
        double toTargetDistanceSqr = localPlayer.position().distanceToSqr(event.getLockOnTarget().position());
        Vec3 lockStart = MathUtils.lerpVector(localPlayer.getEyePosition(), event.getCameraApi().getMinecraft().gameRenderer.getMainCamera().getPosition(), (float)Mth.clampedMap((double)toTargetDistanceSqr, (double)1.0, (double)18.0, (double)0.2f, (double)1.0));
        Vec3 lockEnd = MathUtils.lerpVector(event.getLockOnTarget().getEyePosition(), event.getLockOnTarget().getBoundingBox().getCenter(), (float)Mth.clampedMap((double)toTargetDistanceSqr, (double)0.0, (double)18.0, (double)0.5, (double)1.0));
        float clamp = 30.0f;
        Vec3 toTarget = lockEnd.subtract(lockStart);
        float xRot = (float)MathUtils.getXRotOfVector(toTarget);
        float yRot = (float)MathUtils.getYRotOfVector(toTarget);
        CameraType cameraType = event.getCameraApi().getMinecraft().options.getCameraType();
        if (!cameraType.isFirstPerson()) {
            xRot = Mth.clamp((float)xRot, (float)-30.0f, (float)30.0f);
        }
        float xLerp = Mth.clamp((float)(Mth.wrapDegrees((float)(xRot - instance.getCamera().getXRot())) * 0.4f), (float)-30.0f, (float)30.0f);
        float yLerp = Mth.clamp((float)(Mth.wrapDegrees((float)(yRot - instance.getCamera().getYRot())) * 0.4f), (float)-30.0f, (float)30.0f);
        Vec3 playerToTarget = lockEnd.subtract(localPlayer.getEyePosition());
        event.getCameraApi().setCameraRotations(instance.getCamera().getXRot() + xLerp, instance.getCamera().getYRot() + yLerp, false);
        event.setXRot((float)MathUtils.getXRotOfVector(playerToTarget));
        event.setYRot((float)MathUtils.getYRotOfVector(playerToTarget));
    }

    private static class CameraCouplingOnAttack
    implements ICameraCouplingCallback {
        private CameraCouplingOnAttack() {
        }

        public boolean isForcingCameraCoupling(Minecraft minecraft) {
            return InputManager.isActionActive(EpicFightInputAction.ATTACK) || InputManager.isActionActive(MinecraftInputAction.ATTACK_DESTROY);
        }
    }

    private static class CameraCouplingOnChargingSkill
    implements ICameraCouplingCallback {
        private CameraCouplingOnChargingSkill() {
        }

        public boolean isForcingCameraCoupling(Minecraft minecraft) {
            LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
            if (localPlayerPatch == null) {
                return false;
            }
            return localPlayerPatch.isHoldingAny();
        }
    }
}

