/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.loot;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import yesman.epicfight.api.neoevent.SkillLootTableRegistryEvent;
import yesman.epicfight.config.CommonConfig;
import yesman.epicfight.data.loot.OnSkillBookDroppedByEntity;
import yesman.epicfight.data.loot.function.SetSkillFunction;
import yesman.epicfight.registry.entries.EpicFightItems;
import yesman.epicfight.registry.entries.EpicFightSkills;

@EventBusSubscriber(modid="epicfight")
public class EpicFightLootTables {
    @SubscribeEvent
    public static void onLootTableRegistry(LootTableLoadEvent event) {
        int modifier = CommonConfig.skillBookChestLootModifier;
        int dropChance = 100 + modifier;
        int antiDropChance = 100 - modifier;
        float dropChanceModifier = (float)dropChance / (float)(antiDropChance + dropChance);
        if (event.getName().equals((Object)BuiltInLootTables.DESERT_PYRAMID.location())) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.BERSERKER, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.TECHNICIAN, EpicFightSkills.SWORD_MASTER, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL, EpicFightSkills.PHANTOM_ASCENT})).when(LootItemRandomChanceCondition.randomChance((float)dropChanceModifier))).build());
            event.getTable().addPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.25f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.UCHIGATANA.get()))).build());
        }
        if (event.getName().equals((Object)BuiltInLootTables.JUNGLE_TEMPLE.location())) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.BERSERKER, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.TECHNICIAN, EpicFightSkills.SWORD_MASTER, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL, EpicFightSkills.PHANTOM_ASCENT}))).when(LootItemRandomChanceCondition.randomChance((float)dropChanceModifier)).build());
            event.getTable().addPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.25f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.UCHIGATANA.get()))).build());
        }
        if (event.getName().equals((Object)BuiltInLootTables.SIMPLE_DUNGEON.location())) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.BERSERKER, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.TECHNICIAN, EpicFightSkills.SWORD_MASTER, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL}))).when(LootItemRandomChanceCondition.randomChance((float)(dropChanceModifier * 0.3f))).build());
        }
        if (event.getName().equals((Object)BuiltInLootTables.ABANDONED_MINESHAFT.location())) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.BERSERKER, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.TECHNICIAN, EpicFightSkills.SWORD_MASTER, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL}))).when(LootItemRandomChanceCondition.randomChance((float)(dropChanceModifier * 0.3f))).build());
        }
        if (event.getName().equals((Object)BuiltInLootTables.PILLAGER_OUTPOST.location())) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.BERSERKER, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.TECHNICIAN, EpicFightSkills.SWORD_MASTER, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL}))).when(LootItemRandomChanceCondition.randomChance((float)(dropChanceModifier * 0.3f))).build());
        }
        if (event.getName().equals((Object)BuiltInLootTables.UNDERWATER_RUIN_BIG.location())) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.BERSERKER, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.TECHNICIAN, EpicFightSkills.SWORD_MASTER, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL, EpicFightSkills.PHANTOM_ASCENT}))).when(LootItemRandomChanceCondition.randomChance((float)(dropChanceModifier * 0.3f))).build());
        }
        if (event.getName().equals((Object)BuiltInLootTables.SHIPWRECK_MAP.location())) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.BERSERKER, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.TECHNICIAN, EpicFightSkills.SWORD_MASTER, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL}))).when(LootItemRandomChanceCondition.randomChance((float)(dropChanceModifier * 0.3f))).build());
        }
        if (event.getName().equals((Object)BuiltInLootTables.STRONGHOLD_LIBRARY.location())) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.BERSERKER, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.TECHNICIAN, EpicFightSkills.SWORD_MASTER, EpicFightSkills.HYPERVITALITY, EpicFightSkills.FORBIDDEN_STRENGTH, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL, EpicFightSkills.PHANTOM_ASCENT}))).when(LootItemRandomChanceCondition.randomChance((float)(dropChanceModifier * 0.3f))).build());
        }
        if (event.getName().equals((Object)BuiltInLootTables.WOODLAND_MANSION.location())) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.BERSERKER, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.TECHNICIAN, EpicFightSkills.SWORD_MASTER, EpicFightSkills.HYPERVITALITY, EpicFightSkills.FORBIDDEN_STRENGTH, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL, EpicFightSkills.PHANTOM_ASCENT}))).when(LootItemRandomChanceCondition.randomChance((float)(dropChanceModifier * 0.3f))).build());
        }
        if (event.getName().equals((Object)BuiltInLootTables.BASTION_OTHER.location())) {
            event.getTable().addPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.BERSERKER, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.TECHNICIAN, EpicFightSkills.SWORD_MASTER, EpicFightSkills.HYPERVITALITY, EpicFightSkills.FORBIDDEN_STRENGTH, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL, EpicFightSkills.PHANTOM_ASCENT}))).when(LootItemRandomChanceCondition.randomChance((float)(dropChanceModifier * 0.3f))).build());
        }
        OnSkillBookDroppedByEntity.registerEntitySkillLootTable();
    }

    @SubscribeEvent
    public static void createSkillLootTable(SkillLootTableRegistryEvent skillLootTableRegistryEvent) {
        int modifier = CommonConfig.skillBookMobDropChanceModifier;
        int dropChance = 100 + modifier;
        int antiDropChance = 100 - modifier;
        float dropChanceModifier = antiDropChance == 0 ? Float.MAX_VALUE : (float)dropChance / (float)antiDropChance;
        skillLootTableRegistryEvent.put(EntityType.ZOMBIE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(Float.valueOf(1.0f), EpicFightSkills.BERSERKER, Float.valueOf(1.0f), EpicFightSkills.STAMINA_PILLAGER, Float.valueOf(1.0f), EpicFightSkills.ROLL, Float.valueOf(1.0f), EpicFightSkills.STEP, Float.valueOf(1.0f), EpicFightSkills.GUARD, Float.valueOf(0.5f), EpicFightSkills.ENDURANCE)))));
        skillLootTableRegistryEvent.put(EntityType.HUSK, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(Float.valueOf(1.0f), EpicFightSkills.BERSERKER, Float.valueOf(1.0f), EpicFightSkills.STAMINA_PILLAGER, Float.valueOf(1.0f), EpicFightSkills.ROLL, Float.valueOf(1.0f), EpicFightSkills.STEP, Float.valueOf(1.0f), EpicFightSkills.GUARD, Float.valueOf(0.5f), EpicFightSkills.ENDURANCE)))));
        skillLootTableRegistryEvent.put(EntityType.DROWNED, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(Float.valueOf(1.0f), EpicFightSkills.BERSERKER, Float.valueOf(1.0f), EpicFightSkills.STAMINA_PILLAGER, Float.valueOf(1.0f), EpicFightSkills.ROLL, Float.valueOf(1.0f), EpicFightSkills.STEP, Float.valueOf(1.0f), EpicFightSkills.GUARD, Float.valueOf(0.5f), EpicFightSkills.ENDURANCE)))));
        skillLootTableRegistryEvent.put(EntityType.SKELETON, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(Float.valueOf(1.0f), EpicFightSkills.SWORD_MASTER, Float.valueOf(1.0f), EpicFightSkills.TECHNICIAN, Float.valueOf(1.0f), EpicFightSkills.ROLL, Float.valueOf(1.0f), EpicFightSkills.STEP, Float.valueOf(1.0f), EpicFightSkills.GUARD, Float.valueOf(0.5f), EpicFightSkills.EMERGENCY_ESCAPE)))));
        skillLootTableRegistryEvent.put(EntityType.STRAY, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(Float.valueOf(1.0f), EpicFightSkills.SWORD_MASTER, Float.valueOf(1.0f), EpicFightSkills.TECHNICIAN, Float.valueOf(1.0f), EpicFightSkills.ROLL, Float.valueOf(1.0f), EpicFightSkills.STEP, Float.valueOf(1.0f), EpicFightSkills.GUARD, Float.valueOf(0.5f), EpicFightSkills.EMERGENCY_ESCAPE)))));
        skillLootTableRegistryEvent.put(EntityType.SPIDER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.ROLL, EpicFightSkills.STEP, EpicFightSkills.GUARD})))));
        skillLootTableRegistryEvent.put(EntityType.CAVE_SPIDER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.ROLL, EpicFightSkills.STEP, EpicFightSkills.GUARD})))));
        skillLootTableRegistryEvent.put(EntityType.CREEPER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.HYPERVITALITY, EpicFightSkills.IMPACT_GUARD})))));
        skillLootTableRegistryEvent.put(EntityType.ENDERMAN, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.HYPERVITALITY, EpicFightSkills.FORBIDDEN_STRENGTH, EpicFightSkills.ENDURANCE, EpicFightSkills.EMERGENCY_ESCAPE, EpicFightSkills.PARRYING, EpicFightSkills.IMPACT_GUARD})))));
        skillLootTableRegistryEvent.put(EntityType.VINDICATOR, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.HYPERVITALITY, EpicFightSkills.BERSERKER, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL})))));
        skillLootTableRegistryEvent.put(EntityType.PILLAGER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.HYPERVITALITY, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL})))));
        skillLootTableRegistryEvent.put(EntityType.WITCH, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.FORBIDDEN_STRENGTH, EpicFightSkills.BERSERKER})))));
        skillLootTableRegistryEvent.put(EntityType.EVOKER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.PARRYING, EpicFightSkills.IMPACT_GUARD})))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.1f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.DEATH_HARVEST, EpicFightSkills.EMERGENCY_ESCAPE})))));
        skillLootTableRegistryEvent.put(EntityType.PIGLIN, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.SWORD_MASTER, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL})))));
        skillLootTableRegistryEvent.put(EntityType.PIGLIN_BRUTE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.HYPERVITALITY, EpicFightSkills.PARRYING, EpicFightSkills.ENDURANCE, EpicFightSkills.IMPACT_GUARD})))));
        skillLootTableRegistryEvent.put(EntityType.ZOMBIFIED_PIGLIN, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.BERSERKER, EpicFightSkills.STAMINA_PILLAGER, EpicFightSkills.GUARD, EpicFightSkills.STEP, EpicFightSkills.ROLL})))));
        skillLootTableRegistryEvent.put(EntityType.WITHER_SKELETON, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(0.025f * dropChanceModifier))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(Float.valueOf(1.0f), EpicFightSkills.SWORD_MASTER, Float.valueOf(1.0f), EpicFightSkills.STAMINA_PILLAGER, Float.valueOf(1.0f), EpicFightSkills.GUARD, Float.valueOf(1.0f), EpicFightSkills.STEP, Float.valueOf(1.0f), EpicFightSkills.ROLL, Float.valueOf(0.75f), EpicFightSkills.DEATH_HARVEST)))));
        skillLootTableRegistryEvent.put(EntityType.WITHER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EpicFightItems.SKILLBOOK.get())).apply(SetSkillFunction.builder(new Holder[]{EpicFightSkills.DEATH_HARVEST})))));
    }
}

