/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.main;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.client.animation.property.JointMaskReloadListener;
import yesman.epicfight.api.client.input.action.EpicFightInputAction;
import yesman.epicfight.api.client.input.action.InputAction;
import yesman.epicfight.api.client.input.action.MinecraftInputAction;
import yesman.epicfight.api.client.model.ItemSkinsReloadListener;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.data.reloader.ItemCapabilityReloadListener;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.data.reloader.SkillReloadListener;
import yesman.epicfight.client.events.engine.IEventBasedEngine;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.gui.screen.config.IngameConfigurationScreen;
import yesman.epicfight.client.gui.screen.config.ItemsPreferenceScreen;
import yesman.epicfight.client.renderer.patched.item.EpicFightItemProperties;
import yesman.epicfight.client.renderer.shader.compute.loader.ComputeShaderProvider;
import yesman.epicfight.compat.ICompatModule;
import yesman.epicfight.compat.MinecraftMod;
import yesman.epicfight.compat.mcreator.MCreatorPlayerAnimationsCompat;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.config.CommonConfig;
import yesman.epicfight.config.ServerConfig;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.main.EpicFightExtensibleEnums;
import yesman.epicfight.main.EpicFightExtensions;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.network.EntityPairingPacketType;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.registry.EpicFightRegistries;
import yesman.epicfight.registry.entries.EpicFightCommandArgumentTypes;
import yesman.epicfight.registry.entries.EpicFightCreativeTabs;
import yesman.epicfight.registry.entries.EpicFightItems;
import yesman.epicfight.registry.entries.EpicFightMobEffects;
import yesman.epicfight.registry.entries.EpicFightPotions;
import yesman.epicfight.server.commands.AnimatorCommand;
import yesman.epicfight.server.commands.PlayerModeCommand;
import yesman.epicfight.server.commands.PlayerSkillCommand;
import yesman.epicfight.server.commands.PlayerStaminaCommand;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.ItemKeywordReloadListener;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.capabilities.item.WeaponTypeReloadListener;
import yesman.epicfight.world.gamerule.EpicFightGameRules;
import yesman.epicfight.world.item.SkillBookItem;

@Mod(value="epicfight")
public class EpicFightMod {
    public static final String MODID = "epicfight";
    public static final String EPICSKINS_MODID = "epicskins";
    public static final Logger LOGGER = LogManager.getLogger((String)"epicfight");

    public static String prefix(String s) {
        return String.format("%s:%s", MODID, s);
    }

    @Deprecated(forRemoval=true)
    public static String format(String s) {
        return String.format(s, MODID);
    }

    public static void logAndStacktraceIfDevSide(BiConsumer<Logger, String> logFunction, String message, Function<String, Throwable> exceptionProvider) {
        EpicFightMod.logAndStacktraceIfDevSide(logFunction, message, exceptionProvider, message);
    }

    public static void logAndStacktraceIfDevSide(BiConsumer<Logger, String> logFunction, String message, Function<String, Throwable> exceptionProvider, String stackTraceMessage) {
        logFunction.accept(LOGGER, message);
        EpicFightMod.stacktraceIfDevSide(message, exceptionProvider, stackTraceMessage);
    }

    public static void stacktraceIfDevSide(String message, Function<String, Throwable> exceptionProvider) {
        EpicFightMod.stacktraceIfDevSide(message, exceptionProvider, message);
    }

    public static void stacktraceIfDevSide(String message, Function<String, Throwable> exceptionProvider, String stackTraceMessage) {
        if (exceptionProvider != null && EpicFightSharedConstants.IS_DEV_ENV) {
            exceptionProvider.apply(stackTraceMessage).printStackTrace();
        }
    }

    public EpicFightMod(IEventBus modEventBus, ModContainer modContainer) {
        if (EpicFightSharedConstants.isPhysicalClient()) {
            modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)IngameConfigurationScreen::new));
            IEventBasedEngine.init(NeoForge.EVENT_BUS, modEventBus);
        } else {
            modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
        }
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC);
        modContainer.registerExtensionPoint(EpicFightExtensions.class, () -> new EpicFightExtensions(EpicFightCreativeTabs.ITEMS));
        modEventBus.addListener(this::constructMod);
        modEventBus.addListener(this::doCommonStuff);
        modEventBus.addListener(this::addPackFindersEvent);
        modEventBus.addListener(this::buildCreativeTabWithSkillBooks);
        modEventBus.addListener(EpicFightCapabilities::registerCapabilities);
        NeoForge.EVENT_BUS.addListener(this::command);
        NeoForge.EVENT_BUS.addListener(this::addReloadListnerEvent);
        LivingMotion.ENUM_MANAGER.registerEnumCls(MODID, LivingMotions.class);
        SkillCategory.ENUM_MANAGER.registerEnumCls(MODID, SkillCategories.class);
        SkillSlot.ENUM_MANAGER.registerEnumCls(MODID, SkillSlots.class);
        Style.ENUM_MANAGER.registerEnumCls(MODID, CapabilityItem.Styles.class);
        WeaponCategory.ENUM_MANAGER.registerEnumCls(MODID, CapabilityItem.WeaponCategories.class);
        Faction.ENUM_MANAGER.registerEnumCls(MODID, Factions.class);
        EntityPairingPacketType.ENUM_MANAGER.registerEnumCls(MODID, EntityPairingPacketTypes.class);
        if (EpicFightSharedConstants.isPhysicalClient()) {
            InputAction.ENUM_MANAGER.registerEnumCls(MODID, EpicFightInputAction.class);
            InputAction.ENUM_MANAGER.registerEnumCls("minecraft", MinecraftInputAction.class);
        }
        EpicFightRegistries.DEFERRED_REGISTRIES.forEach(deferredRegistry -> deferredRegistry.register(modEventBus));
        if (EpicFightSharedConstants.isPhysicalClient()) {
            modEventBus.addListener(ComputeShaderProvider::epicfight$registerComputeShaders);
        }
        this.loadModCompatibilityModules(modEventBus);
    }

    private List<? extends Class<? extends ICompatModule>> getCompatibilityModules(boolean isClientSide) {
        return Arrays.stream(MinecraftMod.values()).filter(mod -> ModList.get().isLoaded(mod.getModId())).filter(mod -> isClientSide || !mod.isClientOnly()).filter(mod -> {
            if (mod == MinecraftMod.AZURE_LIB || mod == MinecraftMod.AZURE_LIB_ARMOR) {
                Integer major = mod.getVersionComponent(MinecraftMod.VersionComponent.MAJOR);
                if (major == null) {
                    LOGGER.error("{} support provided by Epic Fight has been disabled as the AzureLib mod version could not be parsed.", (Object)mod.name());
                    return false;
                }
                if (major >= 3) {
                    LOGGER.info("'{}' support provided by Epic Fight has been disabled to prevent game load crash due to breaking changes in '3.0.0'. For more details: https://github.com/Epic-Fight/epicfight/issues/2279", (Object)mod.name());
                    return false;
                }
            }
            return true;
        }).map(MinecraftMod::getCompatibilityModule).toList();
    }

    private void loadModCompatibilityModules(@NotNull IEventBus modEventBus) {
        boolean isClientSide = EpicFightSharedConstants.isPhysicalClient();
        for (Class<? extends ICompatModule> clazz : this.getCompatibilityModules(isClientSide)) {
            ICompatModule.loadCompatModule(modEventBus, clazz);
        }
        if (isClientSide && ModList.get().getModFiles().stream().anyMatch(modFile -> {
            try {
                Path dataPath = modFile.getFile().findResource(new String[]{"data"});
                return Files.exists(dataPath, new LinkOption[0]) && Files.list(dataPath).anyMatch(namespace -> Files.exists(namespace.resolve("bedrock_animations"), new LinkOption[0]));
            }
            catch (Exception e) {
                return false;
            }
        })) {
            ICompatModule.loadCompatModule(modEventBus, MCreatorPlayerAnimationsCompat.class);
        }
    }

    private void constructMod(FMLConstructModEvent event) {
        event.enqueueWork(LivingMotion.ENUM_MANAGER::loadEnum);
        event.enqueueWork(SkillCategory.ENUM_MANAGER::loadEnum);
        event.enqueueWork(SkillSlot.ENUM_MANAGER::loadEnum);
        event.enqueueWork(Style.ENUM_MANAGER::loadEnum);
        event.enqueueWork(WeaponCategory.ENUM_MANAGER::loadEnum);
        event.enqueueWork(Faction.ENUM_MANAGER::loadEnum);
        event.enqueueWork(EntityPairingPacketType.ENUM_MANAGER::loadEnum);
        if (EpicFightSharedConstants.isPhysicalClient()) {
            event.enqueueWork(InputAction.ENUM_MANAGER::loadEnum);
        }
        event.enqueueWork(() -> {
            AnimationManager.addNoWarningModId(EPICSKINS_MODID);
            AnimationManager.AnimationRegistryEvent animationregistryevent = new AnimationManager.AnimationRegistryEvent();
            ModLoader.postEvent((Event)animationregistryevent);
            animationregistryevent.getBuilders().stream().sorted(Comparator.comparing(AnimationManager.AnimationBuilder::namespace)).forEach(builder -> builder.task().accept((AnimationManager.AnimationBuilder)builder));
        });
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        event.enqueueWork(Armatures::registerEntityTypes);
        event.enqueueWork(EpicFightCommandArgumentTypes::registerArgumentTypes);
        event.enqueueWork(EpicFightPotions::addRecipes);
        event.enqueueWork(EpicFightCapabilities.ITEM_CAPABILITY_PROVIDER::registerWeaponTypesByClass);
        event.enqueueWork(EpicFightCapabilities.ENTITY_PATCH_PROVIDER::registerVanillaEntityPatches);
        event.enqueueWork(EpicFightGameRules::registerGameRules);
        event.enqueueWork(WeaponTypeReloadListener::registerDefaultWeaponTypes);
        event.enqueueWork(EpicFightMobEffects::addOffhandModifier);
        event.enqueueWork(EpicFightExtensibleEnums::initExtensibleEnums);
    }

    private void command(RegisterCommandsEvent event) {
        PlayerModeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PlayerSkillCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PlayerStaminaCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        AnimatorCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void addPackFindersEvent(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            PathPackResources.PathResourcesSupplier resourcesSupplier;
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/epicfight_legacy"});
            PackLocationInfo packLocation = new PackLocationInfo("epicfight_legacy", (Component)Component.translatable((String)"pack.epicfight_legacy.title"), PackSource.BUILT_IN, Optional.empty());
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)packLocation, (Pack.ResourcesSupplier)(resourcesSupplier = new PathPackResources.PathResourcesSupplier(resourcePath)), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, false));
            if (pack != null) {
                event.addRepositorySource(source -> source.accept(pack));
            }
        }
    }

    private void addReloadListnerEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ColliderPreset());
        event.addListener((PreparableReloadListener)new SkillReloadListener());
        event.addListener((PreparableReloadListener)new WeaponTypeReloadListener());
        event.addListener((PreparableReloadListener)new ItemKeywordReloadListener());
        event.addListener((PreparableReloadListener)new ItemCapabilityReloadListener());
        event.addListener((PreparableReloadListener)new MobPatchReloadListener());
    }

    private void buildCreativeTabWithSkillBooks(BuildCreativeModeTabContentsEvent event) {
        EpicFightRegistries.SKILL.keySet().stream().map(id -> id.getNamespace()).distinct().forEach(modid -> ModList.get().getModContainerById(modid).flatMap(modcontainer -> modcontainer.getCustomExtension(EpicFightExtensions.class)).ifPresentOrElse(extension -> {
            if (extension.skillBookCreativeTab().get() == event.getTab()) {
                EpicFightRegistries.SKILL.holders().filter(skill -> ((Skill)skill.value()).getCategory().learnable() && ((Skill)skill.value()).getCreativeTab() == null && ((Skill)skill.value()).getRegistryName().getNamespace() == modid).forEach(holder -> {
                    ItemStack stack = new ItemStack((ItemLike)EpicFightItems.SKILLBOOK.get());
                    SkillBookItem.setContainingSkill((Holder<Skill>)holder, stack);
                    event.accept(stack);
                });
            }
        }, () -> {
            if (event.getTab() == EpicFightCreativeTabs.ITEMS.get()) {
                EpicFightRegistries.SKILL.holders().filter(skill -> ((Skill)skill.value()).getCategory().learnable() && ((Skill)skill.value()).getCreativeTab() == null && ((Skill)skill.value()).getRegistryName().getNamespace() == modid).forEach(holder -> {
                    ItemStack stack = new ItemStack((ItemLike)EpicFightItems.SKILLBOOK.get());
                    SkillBookItem.setContainingSkill((Holder<Skill>)holder, stack);
                    event.accept(stack);
                });
            }
        }));
        EpicFightRegistries.SKILL.holders().filter(skill -> ((Skill)skill.value()).getCategory().learnable() && ((Skill)skill.value()).getCreativeTab() == event.getTab()).forEach(holder -> {
            ItemStack stack = new ItemStack((ItemLike)EpicFightItems.SKILLBOOK.get());
            SkillBookItem.setContainingSkill((Holder<Skill>)holder, stack);
            event.accept(stack);
        });
    }

    @NotNull
    public static ResourceLocation rl(@NotNull String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @EventBusSubscriber(modid="epicfight", value={Dist.DEDICATED_SERVER})
    public static class ServerForgeEvents {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void addReloadListnerEvent(AddReloadListenerEvent event) {
            event.addListener((PreparableReloadListener)AnimationManager.getInstance());
        }
    }

    @EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(ComputeShaderProvider::checkIfSupports);
            event.enqueueWork(EpicFightCapabilities.ENTITY_PATCH_PROVIDER::registerClientPlayerPatches);
            event.enqueueWork(SkillBookScreen::registerIconItems);
            event.enqueueWork(EpicFightItemProperties::registerItemProperties);
            event.enqueueWork(() -> {
                if (ClientConfig.combatPreferredItems.isEmpty() && ClientConfig.miningPreferredItems.isEmpty()) {
                    ItemsPreferenceScreen.resetItems();
                }
            });
            event.enqueueWork(RenderEngine.getInstance()::initialize);
        }

        @SubscribeEvent
        public static void registerResourcepackReloadListnerEvent(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)new JointMaskReloadListener());
            event.registerReloadListener((PreparableReloadListener)Meshes.INSTANCE);
            event.registerReloadListener((PreparableReloadListener)AnimationManager.getInstance());
            event.registerReloadListener((PreparableReloadListener)ItemSkinsReloadListener.INSTANCE);
        }
    }
}

