/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.ApiStatus;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPHandleSkillData;
import yesman.epicfight.network.server.SPHandleSkillData;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;

public class SkillDataManager {
    private final Map<Holder<SkillDataKey<?>>, Object> data = new HashMap();
    private final SkillContainer container;

    public SkillDataManager(SkillContainer container) {
        this.container = container;
    }

    public void registerData(Holder<SkillDataKey<?>> key) {
        if (this.hasData(key)) {
            throw new IllegalStateException(String.valueOf(key) + " is already registered!");
        }
        this.data.put(key, ((SkillDataKey)key.value()).defaultValue());
    }

    public void transferDataTo(SkillDataManager dest) {
        dest.data.putAll(this.data);
    }

    public void removeData(Holder<SkillDataKey<?>> key) {
        this.data.remove(key);
    }

    public Set<Holder<SkillDataKey<?>>> keySet() {
        return this.data.keySet();
    }

    @ApiStatus.Internal
    public void setDataRawtype(Holder<SkillDataKey<?>> key, Object data) {
        if (!this.data.containsKey(key)) {
            throw new IllegalStateException(String.valueOf(key) + " is unregistered.");
        }
        this.data.put(key, data);
    }

    public <T> void setData(DeferredHolder<SkillDataKey<?>, ? extends SkillDataKey<T>> key, T data) {
        this.setDataRawtype((Holder<SkillDataKey<?>>)key, data);
    }

    public <T> void setDataF(DeferredHolder<SkillDataKey<?>, ? extends SkillDataKey<T>> key, Function<T, T> dataMapper) {
        this.setDataRawtype((Holder<SkillDataKey<?>>)key, dataMapper.apply(this.getDataValue(key)));
    }

    public <T> void setDataSync(DeferredHolder<SkillDataKey<?>, ? extends SkillDataKey<T>> key, T data) {
        this.setData(key, data);
        if (!this.container.getExecutor().isLogicalClient()) {
            this.syncServerPlayerData(key, (ServerPlayer)this.container.getServerExecutor().getOriginal());
        } else {
            this.syncLocalPlayerData(key, (LocalPlayer)this.container.getClientExecutor().getOriginal());
        }
    }

    public <T> void setDataSyncF(DeferredHolder<SkillDataKey<?>, ? extends SkillDataKey<T>> key, Function<T, T> dataManipulator) {
        this.setDataF(key, dataManipulator);
        if (!this.container.getExecutor().isLogicalClient()) {
            this.syncServerPlayerData(key, (ServerPlayer)this.container.getServerExecutor().getOriginal());
        } else {
            this.syncLocalPlayerData(key, (LocalPlayer)this.container.getClientExecutor().getOriginal());
        }
    }

    private <T> void syncServerPlayerData(DeferredHolder<SkillDataKey<?>, ? extends SkillDataKey<T>> key, ServerPlayer serverplayer) {
        SPHandleSkillData msg = new SPHandleSkillData(SPHandleSkillData.WorkType.MODIFY, this.container.getSlot(), serverplayer.getId(), (Holder<SkillDataKey<?>>)key);
        ((SkillDataKey)key.value()).encode((ByteBuf)msg.buffer(), this.getDataValue(key));
        EpicFightNetworkManager.sendToPlayer(msg, serverplayer, new CustomPacketPayload[0]);
        if (((SkillDataKey)key.value()).syncronizeToRemotePlayers()) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)serverplayer, new CustomPacketPayload[0]);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private <T> void syncLocalPlayerData(DeferredHolder<SkillDataKey<?>, ? extends SkillDataKey<T>> key, LocalPlayer player) {
        CPHandleSkillData msg = new CPHandleSkillData(this.container.getSlot(), (Holder<SkillDataKey<?>>)key);
        ((SkillDataKey)key.value()).encode((ByteBuf)msg.buffer(), this.getDataValue(key));
        EpicFightNetworkManager.sendToServer(msg, new CustomPacketPayload[0]);
    }

    public void onTracked(EpicFightNetworkManager.PayloadBundleBuilder bundleBuilder) {
        this.data.forEach((key, val) -> {
            if (((SkillDataKey)key.value()).syncronizeToRemotePlayers()) {
                SPHandleSkillData msg = new SPHandleSkillData(SPHandleSkillData.WorkType.MODIFY, this.container.getSlot(), ((Player)this.container.executor.getOriginal()).getId(), (Holder<SkillDataKey<?>>)key);
                ((SkillDataKey)key.value()).encode((ByteBuf)msg.buffer(), val);
                bundleBuilder.and(msg);
            }
        });
    }

    public <T> T getDataValue(DeferredHolder<SkillDataKey<?>, ? extends SkillDataKey<T>> key) {
        return (T)(this.hasData((Holder<SkillDataKey<?>>)key) ? this.data.get(key) : null);
    }

    public <T> Optional<T> getDataValueOptional(DeferredHolder<SkillDataKey<?>, ? extends SkillDataKey<T>> key) {
        return Optional.ofNullable(this.data.get(key));
    }

    @ApiStatus.Internal
    public Object getRawDataValue(Holder<SkillDataKey<?>> key) {
        return this.data.get(key);
    }

    public boolean hasData(Holder<SkillDataKey<?>> key) {
        return this.data.containsKey(key);
    }

    public void clearData() {
        this.data.clear();
    }
}

