/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.projectile;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.EverlastingAllegiance;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.ExtraDamageInstance;
import yesman.epicfight.world.damagesource.StunType;

public class ThrownTridentPatch
extends ProjectilePatch<ThrownTrident> {
    private boolean innateActivated;
    private int returnTick;
    private float independentXRotO;
    private float independentXRot;
    public float renderXRot;
    public float renderXRotO;
    public float renderYRot;
    public float renderYRotO;

    public ThrownTridentPatch(ThrownTrident original) {
        super(original);
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        if (this.innateActivated) {
            SPEntityPairingPacket packet = new SPEntityPairingPacket(((ThrownTrident)this.original).getId(), EntityPairingPacketTypes.TRIDENT_THROWN);
            packet.buffer().writeInt(this.returnTick);
            packet.buffer().writeInt(((ThrownTrident)this.original).tickCount);
            EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer, new CustomPacketPayload[0]);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void entityPairing(SPEntityPairingPacket packet) {
        super.entityPairing(packet);
        if (packet.pairingPacketType() == EntityPairingPacketTypes.TRIDENT_THROWN) {
            this.innateActivated = true;
            this.returnTick = packet.buffer().readInt();
            ((ThrownTrident)this.original).tickCount = packet.buffer().readInt();
        }
    }

    @Override
    protected void setMaxStrikes(ThrownTrident projectileEntity, int maxStrikes) {
        projectileEntity.setPierceLevel((byte)(maxStrikes - 1));
    }

    @Override
    public void onJoinWorld(ThrownTrident projectileEntity, EntityJoinLevelEvent event) {
        super.onJoinWorld(projectileEntity, event);
        if (!this.isLogicalClient()) {
            EpicFightCapabilities.getUnparameterizedEntityPatch(projectileEntity.getOwner(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
                SkillContainer container = playerpatch.getSkill(SkillSlots.WEAPON_INNATE);
                if (container.getSkill() instanceof EverlastingAllegiance) {
                    EverlastingAllegiance.setThrownTridentEntityId(container, projectileEntity.getId());
                }
            });
            this.armorNegation = 20.0f;
        }
    }

    public void tickEnd() {
        if (!this.isLogicalClient()) {
            if (((ThrownTrident)this.original).dealtDamage) {
                EpicFightCapabilities.getUnparameterizedEntityPatch(((ThrownTrident)this.original).getOwner(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
                    SkillContainer container = playerpatch.getSkill(SkillSlots.WEAPON_INNATE);
                    if (container.getSkill() instanceof EverlastingAllegiance && EverlastingAllegiance.getThrownTridentEntityId(container) > -1) {
                        EverlastingAllegiance.setThrownTridentEntityId(container, -1);
                    }
                });
            }
            if (this.innateActivated) {
                List entities = ((ThrownTrident)this.original).level().getEntities(this.original, ((ThrownTrident)this.original).getBoundingBox().inflate(1.0, 1.0, 1.0));
                EpicFightDamageSource source = EpicFightDamageSources.trident(((ThrownTrident)this.original).getOwner(), this.original).setStunType(StunType.HOLD).addRuntimeTag(EpicFightDamageTypeTags.WEAPON_INNATE).addExtraDamage(ExtraDamageInstance.SWEEPING_EDGE_ENCHANTMENT.create(new float[0])).setBaseArmorNegation(30.0f).attachDamageModifier(ValueModifier.multiplier(1.4f));
                for (Entity entity : entities) {
                    if (entity.is(((ThrownTrident)this.original).getOwner())) continue;
                    float f = 8.0f;
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingentity = (LivingEntity)entity;
                    f = EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)((ThrownTrident)this.original).level()), (ItemStack)((ThrownTrident)this.original).getPickupItemStackOrigin(), (Entity)livingentity, (DamageSource)source, (float)f);
                    if (!entity.hurt((DamageSource)source, f)) continue;
                    entity.playSound((SoundEvent)EpicFightSounds.BLADE_HIT.get(), 1.0f, 1.0f);
                    ((ServerLevel)entity.level()).sendParticles((ParticleOptions)((HitParticleType)((Object)EpicFightParticles.HIT_BLADE.get())), entity.position().x, entity.position().y + (double)entity.getBbHeight() * 0.5, entity.position().z, 0, 0.0, 0.0, 0.0, 1.0);
                }
            }
        }
        if (this.innateActivated) {
            int elapsedTicks = Math.max(((ThrownTrident)this.original).tickCount - this.returnTick - 10, 0);
            Vec3 toOwner = ((ThrownTrident)this.original).getOwner().getEyePosition().subtract(((ThrownTrident)this.original).position());
            double length = toOwner.length();
            double speed = Math.min(Math.pow(elapsedTicks, 2.0) * 5.0E-4 + Math.abs((double)elapsedTicks * 0.05), Math.min(10.0, length));
            Vec3 toMaster = toOwner.normalize().scale(speed);
            ((ThrownTrident)this.original).setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
            Vec3 pos = ((ThrownTrident)this.original).position();
            ((ThrownTrident)this.original).setPos(pos.x + toMaster.x, pos.y + toMaster.y, pos.z + toMaster.z);
            ((ThrownTrident)this.original).setXRot(0.0f);
            ((ThrownTrident)this.original).xRotO = 0.0f;
            ((ThrownTrident)this.original).setYRot(0.0f);
            ((ThrownTrident)this.original).yRotO = 0.0f;
            this.independentXRotO = this.independentXRot;
            this.independentXRot += 60.0f;
            ((ThrownTrident)this.original).xRotO = this.independentXRotO;
            ((ThrownTrident)this.original).setXRot(this.independentXRot);
            if (((ThrownTrident)this.original).tickCount % 3 == 0) {
                ((ThrownTrident)this.original).playSound((SoundEvent)EpicFightSounds.WHOOSH_ROD.get(), 3.0f, 1.0f);
            }
        }
    }

    public boolean isInnateActivated() {
        return this.innateActivated;
    }

    public void catchByPlayer(PlayerPatch<?> playerpatch) {
        playerpatch.playAnimationSynchronized(Animations.EVERLASTING_ALLEGIANCE_CATCH, 0.0f);
    }

    public void recalledBySkill() {
        ((ThrownTrident)this.original).playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
        ((ThrownTrident)this.original).dealtDamage = true;
        this.innateActivated = true;
        this.independentXRot = ((ThrownTrident)this.original).getXRot();
        this.returnTick = ((ThrownTrident)this.original).tickCount;
        this.initialFirePosition = ((ThrownTrident)this.original).position();
    }

    @Override
    public EpicFightDamageSource createEpicFightDamageSource() {
        return EpicFightDamageSources.trident(this.original, ((ThrownTrident)this.original).getOwner()).setStunType(StunType.SHORT).addRuntimeTag((TagKey<DamageType>)DamageTypeTags.IS_PROJECTILE).setBaseArmorNegation(this.armorNegation).setBaseImpact(this.impact).setInitialPosition(this.initialFirePosition);
    }
}

