/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat.controlify;

import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.InputBindingBuilder;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.api.entrypoint.InitContext;
import dev.isxander.controlify.api.entrypoint.PreInitContext;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.utils.render.Blit;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import yesman.epicfight.api.client.camera.EpicFightCameraAPI;
import yesman.epicfight.api.client.input.InputMode;
import yesman.epicfight.api.client.input.action.EpicFightInputAction;
import yesman.epicfight.api.client.input.action.MinecraftInputAction;
import yesman.epicfight.api.client.input.controller.EpicFightControllerModProvider;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.compat.controlify.EpicFightControlifyBindContexts;
import yesman.epicfight.compat.controlify.EpicFightControlifyControllerMod;
import yesman.epicfight.compat.controlify.screenop.SkillBookScreenProcessor;
import yesman.epicfight.compat.controlify.screenop.SkillEditScreenProcessor;
import yesman.epicfight.main.EpicFightMod;

@ApiStatus.Internal
public class EpicFightControlifyEntrypoint
implements ControlifyEntrypoint {
    private static InputBindingSupplier attack;
    private static InputBindingSupplier mobility;
    private static InputBindingSupplier guard;
    private static InputBindingSupplier dodge;
    private static InputBindingSupplier switchMode;
    private static InputBindingSupplier weaponInnateSkill;
    private static InputBindingSupplier weaponInnateSkillTooltip;
    private static InputBindingSupplier openSkillEditorScreen;
    private static InputBindingSupplier openConfigScreen;
    private static InputBindingSupplier switchVanillaModeDebugging;
    private static InputBindingSupplier lockOn;
    private static InputBindingSupplier lockOnShiftLeft;
    private static InputBindingSupplier lockOnShiftRight;
    private static InputBindingSupplier lockOnShiftFreely;

    public void onControllersDiscovered(ControlifyApi controlify) {
    }

    public void onControlifyInit(InitContext context) {
        EpicFightControlifyEntrypoint.registerModIntegration();
    }

    public void onControlifyPreInit(PreInitContext context) {
        ControlifyBindApi registrar = ControlifyBindApi.get();
        EpicFightControlifyEntrypoint.registerCustomRadialIcons();
        EpicFightControlifyBindContexts.EpicFight.register(registrar);
        EpicFightControlifyEntrypoint.registerInputBindings(registrar);
        EpicFightControlifyEntrypoint.registerEvents();
        EpicFightControlifyEntrypoint.registerGuides();
        EpicFightControlifyEntrypoint.registerScreenProcessors();
    }

    private static void registerCustomRadialIcons() {
        for (EpicFightRadialIcons icon : EpicFightRadialIcons.values()) {
            ResourceLocation location = icon.getId();
            RadialIcons.registerIcon((ResourceLocation)location, (graphics, x, y, tickDelta) -> {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
                graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                Blit.blitTex((GuiGraphics)graphics, (ResourceLocation)location, (int)0, (int)0, (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
                graphics.m_280168_().m_85849_();
            });
        }
    }

    private static void registerInputBindings(ControlifyBindApi registrar) {
        for (EpicFightInputAction action : EpicFightInputAction.values()) {
            EpicFightControlifyEntrypoint.registerInputBinding(registrar, action);
        }
    }

    @NotNull
    private static InputBindingSupplier registerInputBinding(@NotNull ControlifyBindApi registrar, @NotNull EpicFightInputAction action) {
        MutableComponent combatCategory = Component.m_237115_((String)"key.epicfight.combat");
        MutableComponent guiCategory = Component.m_237115_((String)"key.epicfight.gui");
        MutableComponent cameraCategory = Component.m_237115_((String)"key.epicfight.camera");
        MutableComponent systemCategory = Component.m_237115_((String)"key.epicfight.system");
        return switch (action) {
            default -> throw new IncompatibleClassChangeError();
            case EpicFightInputAction.ATTACK -> attack = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$1(action, (Component)combatCategory, arg_0));
            case EpicFightInputAction.MOBILITY -> mobility = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$2(action, (Component)combatCategory, arg_0));
            case EpicFightInputAction.GUARD -> guard = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$3(action, (Component)combatCategory, arg_0));
            case EpicFightInputAction.DODGE -> dodge = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$4(action, (Component)combatCategory, arg_0));
            case EpicFightInputAction.LOCK_ON -> lockOn = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$5(action, (Component)cameraCategory, arg_0));
            case EpicFightInputAction.LOCK_ON_SHIFT_LEFT -> lockOnShiftLeft = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$6(action, (Component)cameraCategory, arg_0));
            case EpicFightInputAction.LOCK_ON_SHIFT_RIGHT -> lockOnShiftRight = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$7(action, (Component)cameraCategory, arg_0));
            case EpicFightInputAction.LOCK_ON_SHIFT_FREELY -> lockOnShiftFreely = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$8(action, (Component)cameraCategory, arg_0));
            case EpicFightInputAction.SWITCH_MODE -> switchMode = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$9(action, (Component)systemCategory, arg_0));
            case EpicFightInputAction.WEAPON_INNATE_SKILL -> weaponInnateSkill = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$10(action, (Component)combatCategory, arg_0));
            case EpicFightInputAction.WEAPON_INNATE_SKILL_TOOLTIP -> weaponInnateSkillTooltip = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$11(action, (Component)guiCategory, arg_0));
            case EpicFightInputAction.OPEN_SKILL_SCREEN -> openSkillEditorScreen = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$12(action, (Component)guiCategory, arg_0));
            case EpicFightInputAction.OPEN_CONFIG_SCREEN -> openConfigScreen = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$13(action, (Component)guiCategory, arg_0));
            case EpicFightInputAction.SWITCH_VANILLA_MODEL_DEBUGGING -> switchVanillaModeDebugging = registrar.registerBinding(arg_0 -> EpicFightControlifyEntrypoint.lambda$registerInputBinding$14(action, (Component)systemCategory, arg_0));
        };
    }

    @NotNull
    private static InputBindingBuilder applyCommonBindingProperties(@NotNull EpicFightInputAction action, @NotNull InputBindingBuilder builder) {
        TranslationKeys translationKeys = TranslationKeys.fromAction(action);
        KeyMapping keyMappingToIgnore = action.keyMapping();
        return builder.id(EpicFightControlifyEntrypoint.getBindingId(action)).name(translationKeys.getNameComponent()).description(translationKeys.getDescriptionComponent()).addKeyCorrelation(keyMappingToIgnore);
    }

    @NotNull
    private static ResourceLocation getBindingId(@NotNull EpicFightInputAction action) {
        String path = switch (action) {
            default -> throw new IncompatibleClassChangeError();
            case EpicFightInputAction.ATTACK -> "attack";
            case EpicFightInputAction.MOBILITY -> "mobility";
            case EpicFightInputAction.GUARD -> "guard";
            case EpicFightInputAction.DODGE -> "dodge";
            case EpicFightInputAction.LOCK_ON -> "lock_on";
            case EpicFightInputAction.LOCK_ON_SHIFT_LEFT -> "lock_on_shift_left";
            case EpicFightInputAction.LOCK_ON_SHIFT_RIGHT -> "lock_on_shift_right";
            case EpicFightInputAction.LOCK_ON_SHIFT_FREELY -> "lock_on_shift_freely";
            case EpicFightInputAction.SWITCH_MODE -> "switch_mode";
            case EpicFightInputAction.WEAPON_INNATE_SKILL -> "weapon_innate_skill";
            case EpicFightInputAction.WEAPON_INNATE_SKILL_TOOLTIP -> "weapon_innate_skill_tooltip";
            case EpicFightInputAction.OPEN_SKILL_SCREEN -> "open_skill_editor_screen";
            case EpicFightInputAction.OPEN_CONFIG_SCREEN -> "open_config_screen";
            case EpicFightInputAction.SWITCH_VANILLA_MODEL_DEBUGGING -> "switch_vanilla_mode_debugging";
        };
        return EpicFightMod.rl(path);
    }

    private static void registerModIntegration() {
        EpicFightControllerModProvider.set("epicfight", new EpicFightControlifyControllerMod());
    }

    private static void registerEvents() {
        ControlifyEvents.LOOK_INPUT_MODIFIER.register(event -> {
            double multiplier = 10.0;
            Vector2f lookInput = event.lookInput();
            double dy = (double)lookInput.x * 10.0;
            double dx = (double)lookInput.y * 10.0;
            if (EpicFightCameraAPI.getInstance().turnCamera(dy, dx)) {
                lookInput.zero();
            }
        });
    }

    private static void registerGuides() {
    }

    @NotNull
    public static InputBinding getControlifyBinding(@NotNull EpicFightInputAction action) {
        InputBindingSupplier bindingSupplier = switch (action) {
            default -> throw new IncompatibleClassChangeError();
            case EpicFightInputAction.ATTACK -> attack;
            case EpicFightInputAction.MOBILITY -> mobility;
            case EpicFightInputAction.GUARD -> guard;
            case EpicFightInputAction.DODGE -> dodge;
            case EpicFightInputAction.LOCK_ON -> lockOn;
            case EpicFightInputAction.LOCK_ON_SHIFT_LEFT -> lockOnShiftLeft;
            case EpicFightInputAction.LOCK_ON_SHIFT_RIGHT -> lockOnShiftRight;
            case EpicFightInputAction.LOCK_ON_SHIFT_FREELY -> lockOnShiftFreely;
            case EpicFightInputAction.SWITCH_MODE -> switchMode;
            case EpicFightInputAction.WEAPON_INNATE_SKILL -> weaponInnateSkill;
            case EpicFightInputAction.WEAPON_INNATE_SKILL_TOOLTIP -> weaponInnateSkillTooltip;
            case EpicFightInputAction.OPEN_SKILL_SCREEN -> openSkillEditorScreen;
            case EpicFightInputAction.OPEN_CONFIG_SCREEN -> openConfigScreen;
            case EpicFightInputAction.SWITCH_VANILLA_MODEL_DEBUGGING -> switchVanillaModeDebugging;
        };
        @Nullable InputBinding binding = bindingSupplier.onOrNull(EpicFightControlifyEntrypoint.requireControllerEntity());
        return Objects.requireNonNull(binding, "The binding for the action " + action.name() + " is not yet registered.");
    }

    @NotNull
    public static InputBinding getControlifyBinding(@NotNull MinecraftInputAction action) {
        InputBindingSupplier bindingSupplier = switch (action) {
            default -> throw new IncompatibleClassChangeError();
            case MinecraftInputAction.ATTACK_DESTROY -> ControlifyBindings.ATTACK;
            case MinecraftInputAction.MOVE_FORWARD -> ControlifyBindings.WALK_FORWARD;
            case MinecraftInputAction.MOVE_BACKWARD -> ControlifyBindings.WALK_BACKWARD;
            case MinecraftInputAction.MOVE_LEFT -> ControlifyBindings.WALK_LEFT;
            case MinecraftInputAction.MOVE_RIGHT -> ControlifyBindings.WALK_RIGHT;
            case MinecraftInputAction.SPRINT -> ControlifyBindings.SPRINT;
            case MinecraftInputAction.SNEAK -> ControlifyBindings.SNEAK;
            case MinecraftInputAction.USE -> ControlifyBindings.USE;
            case MinecraftInputAction.SWAP_OFF_HAND -> ControlifyBindings.SWAP_HANDS;
            case MinecraftInputAction.DROP -> ControlifyBindings.DROP_INGAME;
            case MinecraftInputAction.TOGGLE_PERSPECTIVE -> ControlifyBindings.CHANGE_PERSPECTIVE;
            case MinecraftInputAction.JUMP -> ControlifyBindings.JUMP;
        };
        @Nullable InputBinding binding = bindingSupplier.onOrNull(EpicFightControlifyEntrypoint.requireControllerEntity());
        return Objects.requireNonNull(binding, "The binding for the action " + action.name() + " is not yet registered.");
    }

    @NotNull
    public static ControlifyApi getApi() {
        return ControlifyApi.get();
    }

    @NotNull
    public static ControllerEntity requireControllerEntity() {
        Optional optionalControllerEntity = EpicFightControlifyEntrypoint.getApi().getCurrentController();
        if (optionalControllerEntity.isEmpty()) {
            String message = String.format("The method IEpicFightControllerMod#getInputState must not be called when the input mode is not %s", InputMode.CONTROLLER.name());
            EpicFightMod.LOGGER.error(message);
            throw new IllegalStateException(message);
        }
        return (ControllerEntity)optionalControllerEntity.get();
    }

    private static void registerScreenProcessors() {
        ScreenProcessorProvider.registerProvider(SkillEditScreen.class, SkillEditScreenProcessor::new);
        ScreenProcessorProvider.registerProvider(SkillBookScreen.class, SkillBookScreenProcessor::new);
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$14(EpicFightInputAction action, Component systemCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(systemCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.IN_GAME});
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$13(EpicFightInputAction action, Component guiCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(guiCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.IN_GAME}).radialCandidate(RadialIcons.getItem((Item)Items.f_42451_));
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$12(EpicFightInputAction action, Component guiCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(guiCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.IN_GAME}).radialCandidate(EpicFightRadialIcons.SKILL_BOOK.getId());
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$11(EpicFightInputAction action, Component guiCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(guiCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.ANY_SCREEN});
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$10(EpicFightInputAction action, Component combatCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(combatCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.EpicFight.COMBAT_MODE});
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$9(EpicFightInputAction action, Component systemCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(systemCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.IN_GAME}).radialCandidate(EpicFightRadialIcons.UCHIGATANA.getId());
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$8(EpicFightInputAction action, Component cameraCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(cameraCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.EpicFight.LOCK_ON});
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$7(EpicFightInputAction action, Component cameraCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(cameraCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.EpicFight.LOCK_ON});
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$6(EpicFightInputAction action, Component cameraCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(cameraCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.EpicFight.LOCK_ON});
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$5(EpicFightInputAction action, Component cameraCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(cameraCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.EpicFight.COMBAT_MODE});
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$4(EpicFightInputAction action, Component combatCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(combatCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.EpicFight.COMBAT_MODE});
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$3(EpicFightInputAction action, Component combatCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(combatCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.EpicFight.COMBAT_MODE});
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$2(EpicFightInputAction action, Component combatCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(combatCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.EpicFight.COMBAT_MODE});
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBinding$1(EpicFightInputAction action, Component combatCategory, InputBindingBuilder builder) {
        return EpicFightControlifyEntrypoint.applyCommonBindingProperties(action, builder).category(combatCategory).allowedContexts(new BindContext[]{EpicFightControlifyBindContexts.EpicFight.COMBAT_MODE});
    }

    private static enum EpicFightRadialIcons {
        UCHIGATANA(EpicFightMod.rl("textures/item/uchigatana_gui.png")),
        SKILL_BOOK(EpicFightMod.rl("textures/item/skillbook.png"));

        @NotNull
        private final ResourceLocation id;

        private EpicFightRadialIcons(ResourceLocation id) {
            this.id = id;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }
    }

    private record TranslationKeys(@NotNull String name, @NotNull String description) {
        @NotNull
        private Component getNameComponent() {
            return Component.m_237115_((String)this.name());
        }

        @NotNull
        private Component getDescriptionComponent() {
            return Component.m_237115_((String)this.description());
        }

        @NotNull
        private static TranslationKeys fromAction(@NotNull EpicFightInputAction action) {
            return switch (action) {
                default -> throw new IncompatibleClassChangeError();
                case EpicFightInputAction.ATTACK -> new TranslationKeys("key.epicfight.attack", "key.epicfight.attack.description");
                case EpicFightInputAction.DODGE -> new TranslationKeys("key.epicfight.dodge", "key.epicfight.dodge.description");
                case EpicFightInputAction.GUARD -> new TranslationKeys("key.epicfight.guard", "key.epicfight.guard.description");
                case EpicFightInputAction.LOCK_ON -> new TranslationKeys("key.epicfight.lock_on", "key.epicfight.lock_on.description");
                case EpicFightInputAction.LOCK_ON_SHIFT_LEFT -> new TranslationKeys("key.epicfight.lock_on_shift_left", "key.epicfight.lock_on_shift_left.description");
                case EpicFightInputAction.LOCK_ON_SHIFT_RIGHT -> new TranslationKeys("key.epicfight.lock_on_shift_right", "key.epicfight.lock_on_shift_right.description");
                case EpicFightInputAction.LOCK_ON_SHIFT_FREELY -> new TranslationKeys("key.epicfight.lock_on_shift_freely", "key.epicfight.lock_on_shift_freely.description");
                case EpicFightInputAction.SWITCH_MODE -> new TranslationKeys("key.epicfight.switch_mode", "key.epicfight.switch_mode.description");
                case EpicFightInputAction.WEAPON_INNATE_SKILL -> new TranslationKeys("key.epicfight.weapon_innate_skill", "key.epicfight.weapon_innate_skill.description");
                case EpicFightInputAction.WEAPON_INNATE_SKILL_TOOLTIP -> new TranslationKeys("key.epicfight.show_tooltip", "key.epicfight.show_tooltip.description");
                case EpicFightInputAction.OPEN_SKILL_SCREEN -> new TranslationKeys("key.epicfight.skill_gui", "key.epicfight.skill_gui.description");
                case EpicFightInputAction.OPEN_CONFIG_SCREEN -> new TranslationKeys("key.epicfight.config", "key.epicfight.config.description");
                case EpicFightInputAction.SWITCH_VANILLA_MODEL_DEBUGGING -> new TranslationKeys("key.epicfight.switch_vanilla_model_debug", "key.epicfight.switch_vanilla_model_debug.description");
                case EpicFightInputAction.MOBILITY -> new TranslationKeys("key.epicfight.mover_skill", "key.epicfight.mover_skill.description");
            };
        }
    }
}

